/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import com.bmc.arsys.plugins.ftsconfig.helper.shared.Indentation;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.XPATHHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser {
    public static final String ISO_8859_1 = "ISO-8859-1";
    private String fileName_;
    private Document document_;
    private Indentation indentation_;
    private String charset_;

    public XMLParser(String fileName) throws Exception {
        this.fileName_ = fileName;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.document_ = factory.newDocumentBuilder().parse(new File(fileName));
        this.indentation_ = new Indentation();
        this.charset_ = ISO_8859_1;
    }

    public XMLParser(File file) throws Exception {
        this.fileName_ = file.getAbsolutePath();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.document_ = factory.newDocumentBuilder().parse(file);
        this.indentation_ = new Indentation();
        this.charset_ = ISO_8859_1;
    }

    public XMLParser(InputStream file) throws Exception {
        this.fileName_ = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.document_ = factory.newDocumentBuilder().parse(file);
        this.indentation_ = new Indentation();
        this.charset_ = ISO_8859_1;
    }

    public Indentation getIndentation() {
        return this.indentation_;
    }

    public void setIndentation(Indentation indentation) {
        this.indentation_ = indentation;
    }

    public String getCharset() {
        return this.charset_;
    }

    public void setCharset(String charset) {
        this.charset_ = charset;
    }

    public List<Node> getNodeList(String xpathString) throws Exception {
        List<Node> nodeList = XPATHHelper.getNodes(this.document_, xpathString);
        if (nodeList == null) {
            throw new Exception("The XPath string was written incorect - please verify...[" + xpathString + "]");
        }
        return nodeList;
    }

    public List<String> getNodesValue(String xpathString) throws Exception {
        ArrayList<String> entities = new ArrayList<String>();
        List<Node> nodeList = this.getNodeList(xpathString);
        for (Node node : nodeList) {
            NodeList childsNodes = node.getChildNodes();
            Node child = childsNodes.item(0);
            String tagValue = "";
            if (child != null) {
                tagValue = child.getNodeValue();
            }
            entities.add(tagValue);
        }
        return entities;
    }

    public List<String> getNodesAttributes(String xpathString, String attributeName) throws Exception {
        ArrayList<String> attributes = new ArrayList<String>();
        List<Node> nodeList = this.getNodeList(xpathString);
        for (Node node : nodeList) {
            String attributeValue = node.getAttributes().getNamedItem(attributeName).getNodeValue();
            attributes.add(attributeValue);
        }
        return attributes;
    }

    public String getNodeValue(String xpathString) throws Exception {
        Node child = this.getChild(xpathString);
        String initalValue = new String("");
        if (child != null) {
            initalValue = child.getNodeValue();
        } else {
            Element parent = (Element)XPATHHelper.getNode(this.document_, xpathString);
            initalValue = parent.getNodeValue();
        }
        return initalValue;
    }

    public void updateNodesValue(String xpathString, List<String> values) throws Exception {
        List<Node> nodeList = this.getNodeList(xpathString);
        Iterator<Node> iter = nodeList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Node node = iter.next();
            String value = values.get(i);
            NodeList childsNodes = node.getChildNodes();
            Node child = childsNodes.item(0);
            if (child != null) {
                child.setNodeValue(value);
            } else {
                Element parent = (Element)node;
                child = parent.getFirstChild();
                parent.appendChild(this.document_.createTextNode(value));
            }
            ++i;
        }
    }

    public void updateNodeValue(String xpathString, String value) throws Exception {
        Node child = this.getChild(xpathString);
        if (child != null) {
            child.setNodeValue(value);
        } else {
            Node node = XPATHHelper.getNode(this.document_, xpathString);
            if (node.getNodeType() == 1) {
                Element parent = (Element)node;
                child = parent.getFirstChild();
                if (child == null) {
                    parent.appendChild(this.document_.createTextNode(value));
                } else {
                    child.setNodeValue(value);
                }
            } else if (node.getNodeType() == 2) {
                node.setNodeValue(value);
            }
        }
    }

    public void addAttributeToElement(String xpathString, String name, String value) throws Exception {
        Node root = XPATHHelper.getNode(this.document_, xpathString);
        if (root == null) {
            throw new Exception("The XPath string was written incorect - please verify...");
        }
        if (root.getNodeType() != 1) {
            throw new Exception("The input xpath should be an element");
        }
        ((Element)root).setAttribute(name, value);
    }

    public void addElementToElement(String xpathString, String element) throws Exception {
        this.addElementToElement(xpathString, element, null);
    }

    public void addElementToElement(String xpathString, String element, String value) throws Exception {
        Node root = XPATHHelper.getNode(this.document_, xpathString);
        if (root == null) {
            throw new Exception("The XPath string was written incorect - please verify...");
        }
        if (root.getNodeType() != 1) {
            throw new Exception("The input XPath should be an element");
        }
        Element item = this.document_.createElement(element);
        if (value != null) {
            item.appendChild(this.document_.createTextNode(value));
        }
        root.appendChild(item);
    }

    public void addElementToElement(String xpathString, String element, String value, String attributeName, String attributeValue) throws Exception {
        Node root = XPATHHelper.getNode(this.document_, xpathString);
        if (root == null) {
            throw new Exception("The XPath string was written incorect - please verify...");
        }
        if (root.getNodeType() != 1) {
            throw new Exception("The input XPath should be an element");
        }
        Element item = this.document_.createElement(element);
        item.setAttribute(attributeName, attributeValue);
        if (value != null) {
            item.appendChild(this.document_.createTextNode(value));
        }
        root.appendChild(item);
    }

    public void addElementAfterElement(String xpathString, String element, String value) throws Exception {
        Node root = XPATHHelper.getNode(this.document_, xpathString);
        if (root == null) {
            throw new Exception("The XPath string was written incorect - please verify...");
        }
        if (root.getNodeType() != 1) {
            throw new Exception("The input XPath should be an element");
        }
        Element item = this.document_.createElement(element);
        if (value != null) {
            item.appendChild(this.document_.createTextNode(value));
        }
        root.getParentNode().insertBefore(item, root.getNextSibling());
    }

    public void addElementAfterElement(String xpathString, String element, String value, String attributeName, String attributeValue) throws Exception {
        Node root = XPATHHelper.getNode(this.document_, xpathString);
        if (root == null) {
            throw new Exception("The XPath string was written incorect - please verify...");
        }
        if (root.getNodeType() != 1) {
            throw new Exception("The input XPath should be an element");
        }
        Element item = this.document_.createElement(element);
        item.setAttribute(attributeName, attributeValue);
        if (value != null) {
            item.appendChild(this.document_.createTextNode(value));
        }
        root.getParentNode().insertBefore(item, root.getNextSibling());
    }

    public void appendNode(String xpathString, Node node) throws Exception {
        Node root = XPATHHelper.getNode(this.document_, xpathString);
        if (root == null) {
            throw new Exception("The XPath string was written incorect - please verify...");
        }
        if (root.getNodeType() != 1) {
            throw new Exception("The input XPath should be an element");
        }
        Node tempNode = this.document_.importNode(node, true);
        root.appendChild(tempNode);
    }

    public Node getNode(String xpathString) throws Exception {
        Node node = XPATHHelper.getNode(this.document_, xpathString);
        if (node == null) {
            throw new Exception("The XPath string was written incorect - please verify...");
        }
        if (node.getNodeType() != 1) {
            throw new Exception("The input XPath should be an element");
        }
        return node;
    }

    public void removeNode(String xpathString) throws Exception {
        Node node = XPATHHelper.getNode(this.document_, xpathString);
        node.getParentNode().removeChild(node);
    }

    public void commit() {
        this.commit(this.fileName_, null);
    }

    public void commitWithDTD(String dtdFile) {
        this.commit(this.fileName_, dtdFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(String fileName, String dtdFile) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            if (dtdFile != null) {
                transformer.setOutputProperty("doctype-system", dtdFile);
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.getCharset());
            String increment = this.getIndentation().getIndentationIncrement();
            String indentAmount = "2";
            if (increment != null) {
                indentAmount = Integer.toString(increment.length());
            }
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", indentAmount);
            transformer.setOutputProperty("indent", "yes");
        }
        catch (TransformerConfigurationException tce) {
            // empty catch block
        }
        DOMSource source = new DOMSource(this.document_);
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        StreamResult result = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                osw = new OutputStreamWriter((OutputStream)fos, this.getCharset());
                result = new StreamResult(osw);
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            try {
                if (transformer != null) {
                    transformer.transform(source, result);
                }
            }
            catch (TransformerException te) {
                // empty catch block
            }
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Throwable t) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private Node getChild(String xpathString) throws Exception {
        Node child = null;
        Node node = XPATHHelper.getNode(this.document_, xpathString);
        if (node == null) {
            throw new Exception("The XPath string was written incorect - please verify...[" + xpathString + "]");
        }
        child = node.getFirstChild();
        return child;
    }
}

