/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.plugins.configchecker.CheckResultNotifier;
import com.bmc.arsys.plugins.configchecker.ConfigCheck;
import com.bmc.arsys.plugins.configchecker.ConfigCheckerFilterPlugin;
import com.bmc.arsys.plugins.configchecker.ServerContext;
import com.bmc.arsys.plugins.configchecker.UDMCheckRAppPassword;
import com.bmc.arsys.plugins.configchecker.UDMDataManagementFilePath;
import com.bmc.arsys.plugins.configchecker.UDMServerConfCheck;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UdmChecker
implements ConfigCheck {
    private static Logger logger = Logger.getLogger(ConfigCheckerFilterPlugin.class);
    private CheckResultNotifier notifyUpdate = null;
    private String check;
    private ServerContext serverContext = null;
    private ConfigCheck.ExitCode exitCode = ConfigCheck.ExitCode.PASS;
    private List<String> errorMessages = null;

    public UdmChecker(String check, CheckResultNotifier notifyUpdate) {
        this.notifyUpdate = notifyUpdate;
        this.check = check;
    }

    @Override
    public boolean init(ServerContext serverContext) {
        this.serverContext = serverContext;
        this.errorMessages = new ArrayList<String>();
        return true;
    }

    @Override
    public void performValidation() {
        try {
            if (UDMChecks.ARR_CONF.toString().equals(this.check) || this.check.equalsIgnoreCase("ALL")) {
                UDMServerConfCheck confCheck = new UDMServerConfCheck(UDMChecks.ARR_CONF, this.serverContext, this.notifyUpdate);
                confCheck.run();
            }
            if (UDMChecks.RAPP_PASSWD.toString().equals(this.check) || this.check.equalsIgnoreCase("ALL")) {
                UDMCheckRAppPassword rAppCheck = new UDMCheckRAppPassword(UDMChecks.RAPP_PASSWD, this.serverContext, this.notifyUpdate);
                rAppCheck.run();
            }
            if (UDMChecks.DATA_LOAD_FILE_PATH.toString().equals(this.check) || this.check.equalsIgnoreCase("ALL")) {
                UDMDataManagementFilePath dmfpCheck = new UDMDataManagementFilePath(UDMChecks.DATA_LOAD_FILE_PATH, this.serverContext, this.notifyUpdate);
                dmfpCheck.run();
            }
            if (UDMChecks.UDM_PLUGIN_CONG.toString().equals(this.check) || this.check.equalsIgnoreCase("ALL")) {
                UDMServerConfCheck pluginCheck = new UDMServerConfCheck(UDMChecks.UDM_PLUGIN_CONG, this.serverContext, this.notifyUpdate);
                pluginCheck.run();
            }
        }
        catch (Exception ex) {
            this.exitCode = ConfigCheck.ExitCode.FAIL;
            logger.debug((Object)ex.toString());
            this.errorMessages.add("UDM Check failed : " + ex.getMessage());
        }
    }

    @Override
    public ConfigCheck.ExitCode getExitCode() {
        return this.exitCode;
    }

    @Override
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    static enum UDMChecks {
        DEFAULT("UDM Check"),
        ARR_CONF("Check ARServer Configuration"),
        RAPP_PASSWD("Check Remedy Application Service Password"),
        DATA_LOAD_FILE_PATH("Check Data Management Load File Path"),
        UDM_PLUGIN_CONG("Check UDM plugin config"),
        SQL_DB_CONG("Check SQL DB Configuration");

        private String name;

        public String toString() {
            return this.name;
        }

        private UDMChecks(String name) {
            this.name = name;
        }

        public static boolean validCheck(String in) {
            return in.equalsIgnoreCase(ARR_CONF.toString()) || in.equalsIgnoreCase(RAPP_PASSWD.toString()) || in.equalsIgnoreCase(DATA_LOAD_FILE_PATH.toString()) || in.equalsIgnoreCase(UDM_PLUGIN_CONG.toString()) || in.equalsIgnoreCase("ALL");
        }
    }
}

