/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.util.ARUtilEgcp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArConfHelper {
    public static String getArConfName() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return "conf" + File.separator + "ar.cfg";
        }
        return "conf" + File.separator + "ar.conf";
    }

    public static boolean parseARConfigParam(String fileName, String parameterName, ArrayList<String> resultList) {
        try {
            String currentRecord;
            FileReader fr = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fr);
            while ((currentRecord = br.readLine()) != null) {
                if ((currentRecord = currentRecord.trim()).startsWith("#")) continue;
                currentRecord = currentRecord.toUpperCase();
                String uParameter = parameterName.toUpperCase();
                if (!currentRecord.startsWith(uParameter = uParameter + ":")) continue;
                String val = currentRecord.substring(currentRecord.indexOf(":") + 1);
                val = val.trim();
                resultList.add(val);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Caught FileNotFoundException: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            System.err.println("Caught IOException: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static String getLocalServerName(String arConfFile) {
        String localServerName = null;
        ArrayList<String> resultList = new ArrayList<String>();
        if (!ArConfHelper.parseARConfigParam(arConfFile, "SERVER-CONNECT-NAME", resultList)) {
            return null;
        }
        if (resultList.size() == 0) {
            ArrayList<String> resultList2 = new ArrayList<String>();
            if (!ArConfHelper.parseARConfigParam(arConfFile, "SERVER-NAME", resultList2)) {
                return null;
            }
            if (resultList2.size() > 0) {
                localServerName = resultList2.get(0);
            }
        } else if (resultList.size() > 0) {
            localServerName = resultList.get(0);
        }
        return localServerName.toUpperCase();
    }

    public static Map<String, String> getServerRAppPaswordColl(ARServerUser user) throws ARException {
        ArithmeticOrRelationalOperand op1 = new ArithmeticOrRelationalOperand(new Value(1));
        ArithmeticOrRelationalOperand op2 = new ArithmeticOrRelationalOperand(new Value(1));
        RelationalOperationInfo relOp = new RelationalOperationInfo(1, op1, op2);
        QualifierInfo defaultQualifier = new QualifierInfo(relOp);
        SortInfo sortInfo = new SortInfo(1, 1);
        ArrayList<SortInfo> sortList = new ArrayList<SortInfo>(1);
        sortList.add(sortInfo);
        int[] fieldIds = new int[]{8, 123};
        ARUtilEgcp util = new ARUtilEgcp();
        HashMap<String, String> serverPassword = new HashMap<String, String>();
        List entryList = user.getListEntryObjects("UDM:RAppPassword", defaultQualifier, 0, 0, sortList, fieldIds, false, null);
        if (entryList != null) {
            for (Entry entry : entryList) {
                Value val = (Value)entry.get((Object)8);
                String hostName = val.toString();
                val = (Value)entry.get((Object)123);
                String password = val != null ? val.toString() : null;
                if (password == null || password.length() <= 0) continue;
                password = util.GCEUtilApp(password);
                serverPassword.put(hostName.toUpperCase(), password);
            }
        }
        return serverPassword;
    }

    public static HashMap<String, String> isItServerGroupEnv(ARServerUser user) {
        try {
            HashMap<String, String> uniqueMembers = new HashMap<String, String>();
            String sql = "SELECT serverName FROM servgrp_board ORDER BY 1";
            SQLResult schemaIdSqlResult = user.getListSQL(sql, 0, Boolean.FALSE.booleanValue());
            List resultList = null;
            if (schemaIdSqlResult != null) {
                resultList = schemaIdSqlResult.getContents();
                for (List members : resultList) {
                    String member;
                    String[] ip;
                    Value val = (Value)members.get(0);
                    if (val == null || (ip = ArConfHelper.getIpAddresses(member = val.toString().toUpperCase())) == null) continue;
                    uniqueMembers.put(member, ip[0]);
                    System.out.println("SvgGrp member : " + member + " : " + ip[0]);
                }
            }
            return uniqueMembers;
        }
        catch (ARException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isServerGroupEnv(ARServerUser user) {
        HashMap<String, String> members = ArConfHelper.isItServerGroupEnv(user);
        return members.size() > 1;
    }

    public static String[] getIpAddresses(String serverName) {
        try {
            String[] ipAddresses;
            InetAddress[] inetAddresses = InetAddress.getAllByName(serverName);
            if (inetAddresses != null && inetAddresses.length > 0) {
                ipAddresses = new String[inetAddresses.length];
                int count = 0;
                for (InetAddress inetAddress : inetAddresses) {
                    ipAddresses[count++] = inetAddress.getHostAddress();
                }
            } else {
                ipAddresses = new String[]{};
            }
            return ipAddresses;
        }
        catch (UnknownHostException ex) {
            System.out.println(ex.toString());
            return null;
        }
    }
}

