/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;

public class WildCardPhraseQueryEnum
extends WildcardQuery {
    private static final Logger LOGGER = Logger.getLogger(WildCardPhraseQueryEnum.class);

    WildCardPhraseQueryEnum(Term term) {
        super(term);
    }

    public ArrayList<Term> getTermList(IndexReader reader) {
        List<TermsEnum> enumerators = this.getEnums(reader);
        HashSet<Term> termsSet = new HashSet<Term>();
        if (enumerators != null && !enumerators.isEmpty()) {
            for (TermsEnum enumerator : enumerators) {
                if (enumerator == null) continue;
                try {
                    BytesRef bytesRef = null;
                    while ((bytesRef = enumerator.next()) != null) {
                        Term t = new Term(this.term.field(), BytesRef.deepCopyOf((BytesRef)bytesRef));
                        termsSet.add(t);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " rewrite: Failed to get the next possibile wildcard item."), (Throwable)e);
                }
            }
        }
        return new ArrayList<Term>(termsSet);
    }

    private List<TermsEnum> getEnums(IndexReader reader) {
        ArrayList<TermsEnum> termsEnumList = new ArrayList<TermsEnum>();
        try {
            List<Terms> termsList = this.getTermsList(reader);
            for (Terms terms : termsList) {
                termsEnumList.add(this.getTermsEnum(terms));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " getEnum: Failed to get list of wildcard possibilities."), (Throwable)e);
        }
        return termsEnumList;
    }

    private List<Terms> getTermsList(IndexReader reader) {
        ArrayList<Terms> termsList = new ArrayList<Terms>();
        try {
            List atomicReaderContexts = reader.leaves();
            if (atomicReaderContexts != null) {
                for (AtomicReaderContext atomicReaderContext : atomicReaderContexts) {
                    Terms terms;
                    AtomicReader atomicReader;
                    if (atomicReaderContext == null || (atomicReader = atomicReaderContext.reader()) == null || (terms = atomicReader.terms(this.term.field())) == null) continue;
                    termsList.add(terms);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " getTerms: Failed to get getTerms."), (Throwable)e);
        }
        return termsList;
    }
}

