/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class FTSThesaurusFilter
extends TokenFilter {
    private static final Logger LOGGER = Logger.getLogger(FTSThesaurusFilter.class);
    public static final String TOKEN_TYPE_SYNONYM = "SYNONYM";
    private Stack<String> synonymStack;
    private Hashtable<String, String[]> thesTable;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    public FTSThesaurusFilter(TokenStream in, Hashtable<String, String[]> thesTable) {
        super(in);
        this.synonymStack = new Stack();
        this.thesTable = thesTable;
    }

    private void addAliasesToStack(String term) throws IOException {
        String[] synonyms = this.thesTable.get(term);
        if (synonyms == null) {
            return;
        }
        for (int i = 0; i < synonyms.length; ++i) {
            this.synonymStack.push(synonyms[i]);
        }
    }

    public final boolean incrementToken() throws IOException {
        if (this.synonymStack.size() > 0) {
            String term = this.synonymStack.pop();
            this.termAtt.setEmpty();
            this.termAtt.append(term);
            this.typeAtt.setType(TOKEN_TYPE_SYNONYM);
            this.posIncAtt.setPositionIncrement(0);
            return true;
        }
        if (this.input.incrementToken()) {
            this.addAliasesToStack(this.termAtt.toString());
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.synonymStack.clear();
    }
}

