/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;

public class IndexDocIterator {
    private final IndexReader indexReader;
    private final int totalNumDocs;
    private int currentDocNum;

    public IndexDocIterator(IndexReader indexReader, int totalNumDocs) {
        this.indexReader = indexReader;
        this.totalNumDocs = totalNumDocs;
        this.currentDocNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document next() throws IOException {
        Document doc = null;
        while (this.currentDocNum < this.totalNumDocs && doc == null) {
            try {
                if (this.isDeleted(this.currentDocNum)) continue;
                doc = this.indexReader.document(this.currentDocNum);
            }
            finally {
                ++this.currentDocNum;
            }
        }
        return doc;
    }

    private boolean isDeleted(int docNumber) {
        Bits liveDocBits = MultiFields.getLiveDocs((IndexReader)this.indexReader);
        return liveDocBits != null && liveDocBits.get(docNumber);
    }

    public void reset() {
        this.currentDocNum = 0;
    }

    public int getTotalNumDocs() {
        return this.totalNumDocs;
    }

    public int getCurrentDocNum() {
        return this.currentDocNum;
    }
}

