/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.remoting.rmi;

import com.bmc.thirdparty.org.springframework.remoting.rmi.RmiBasedExporter;
import com.bmc.thirdparty.org.springframework.remoting.rmi.RmiInvocationHandler;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocation;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;

class RmiInvocationWrapper
implements RmiInvocationHandler {
    private final Object wrappedObject;
    private final RmiBasedExporter rmiExporter;

    public RmiInvocationWrapper(Object wrappedObject, RmiBasedExporter rmiExporter) {
        Assert.notNull(wrappedObject, "Object to wrap is required");
        Assert.notNull(rmiExporter, "RMI exporter is required");
        this.wrappedObject = wrappedObject;
        this.rmiExporter = rmiExporter;
    }

    @Override
    public String getTargetInterfaceName() {
        Class<?> ifc = this.rmiExporter.getServiceInterface();
        return ifc != null ? ifc.getName() : null;
    }

    @Override
    public Object invoke(RemoteInvocation invocation) throws RemoteException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.rmiExporter.invoke(invocation, this.wrappedObject);
    }
}

