/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.utils.ARByteArrayBuffer;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class ARFileHandler {
    private static Logger log = Logger.getLogger(ARFileHandler.class);
    private static final String LOCAL_LINE_SEPERATOR = System.getProperty("os.name").contains("Win") ? System.getProperty("line.separator") : "\n";
    private static final String LOCAL_SYSTEM_FILE_ENCODING = System.getProperty("file.encoding");
    private static final String XML_DOC_INDICATOR = "?xml version=";
    public static final String XML_FIRST_EOL_INDICATOR = "?>";
    public static final String XML_ENCODING_INDICATOR = "encoding=";
    public static final String DEF_LEADING_CHARSET_INDICATOR = "char-set: ";

    private ARFileHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String filePathName) throws IOException {
        String line = null;
        String charsetName = "";
        BufferedReader bfReader = null;
        FileReader fReader = null;
        try {
            fReader = new FileReader(filePathName);
            bfReader = new BufferedReader(fReader);
            while ((line = bfReader.readLine()) != null) {
                if (line.trim().equals("")) continue;
                charsetName = ARFileHandler.parseForCharsetName(line);
                break;
            }
        }
        finally {
            if (bfReader != null) {
                bfReader.close();
            }
            if (fReader != null) {
                fReader.close();
            }
        }
        if (charsetName.equals("")) {
            charsetName = ARCharSet.getServerKnownCharSetString(LOCAL_SYSTEM_FILE_ENCODING);
        }
        StringBuilder buffer = new StringBuilder();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            int oneChar;
            fis = new FileInputStream(filePathName);
            String javaCharSet = ARCharSet.getServerCharSetName(";" + charsetName);
            isr = new InputStreamReader((InputStream)fis, javaCharSet);
            bfReader = new BufferedReader(isr);
            while ((oneChar = bfReader.read()) > -1) {
                if (oneChar == 26) {
                    throw new UnsupportedEncodingException("not translatable");
                }
                buffer.append((char)oneChar);
            }
            String string = ARFileHandler.addCharSetNameToDef(buffer.toString(), charsetName);
            return string;
        }
        finally {
            if (bfReader != null) {
                try {
                    bfReader.close();
                }
                catch (IOException e) {
                    log.warn("close file: " + filePathName + " failed", e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    log.warn("close file: " + filePathName + " failed", e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.warn("close file: " + filePathName + " failed", e);
                }
            }
        }
    }

    public static byte[] readAndConvertTextFile(String filePathName, String newCharSetName) throws IOException {
        if (newCharSetName == null) {
            newCharSetName = "utf-8";
        }
        return ARFileHandler.readTextFile(filePathName).getBytes(newCharSetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextToFile(String fileContent, String filePath, String charsetName, boolean overwrite) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bfWriter = null;
        try {
            fos = new FileOutputStream(filePath, !overwrite);
            osw = new OutputStreamWriter((OutputStream)fos, charsetName);
            bfWriter = new BufferedWriter(osw);
            bfWriter.write(fileContent);
            bfWriter.flush();
        }
        finally {
            if (bfWriter != null) {
                try {
                    bfWriter.close();
                }
                catch (Throwable e) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Throwable e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    public static void writeTextToFile(String fileContent, String filePath, boolean overwrite) throws IOException {
        ARFileHandler.writeTextToFile(fileContent, filePath, ARFileHandler.parseForCharsetName(ARFileHandler.getFirstLine(fileContent)), overwrite);
    }

    public static boolean isXMLDoc(String StrLineBuf) {
        return StrLineBuf != null && StrLineBuf.contains(XML_DOC_INDICATOR);
    }

    public static String parseForCharsetName(String line) {
        String encodingName = "";
        if (line == null || line.length() == 0) {
            return encodingName;
        }
        int encodeNameBeginIndex = -1;
        int encodeNameEndIndex = -1;
        if (ARFileHandler.isXMLDoc(line)) {
            encodeNameBeginIndex = line.indexOf(XML_ENCODING_INDICATOR) + XML_ENCODING_INDICATOR.length() + 1;
            encodeNameEndIndex = line.indexOf(XML_FIRST_EOL_INDICATOR) - 1;
            if (encodeNameBeginIndex >= 0 && encodeNameEndIndex >= 0 && encodeNameEndIndex > encodeNameBeginIndex) {
                encodingName = line.substring(encodeNameBeginIndex, encodeNameEndIndex).trim();
            }
        } else if (line.contains(DEF_LEADING_CHARSET_INDICATOR)) {
            encodeNameBeginIndex = line.indexOf(":") + 1;
            encodeNameEndIndex = line.indexOf(LOCAL_LINE_SEPERATOR);
            if (encodeNameBeginIndex >= 0 && encodeNameEndIndex >= 0 && encodeNameEndIndex > encodeNameBeginIndex) {
                encodingName = line.substring(encodeNameBeginIndex, encodeNameEndIndex).trim();
            } else if (encodeNameBeginIndex > 0 && encodeNameEndIndex == -1) {
                encodingName = line.substring(encodeNameBeginIndex).trim();
            }
        }
        return encodingName;
    }

    public static String replaceCharSetNameInXMLDoc(String xmlString, String newEncoding) {
        if (!ARFileHandler.isXMLDoc(xmlString) || newEncoding == null || newEncoding.length() == 0) {
            return xmlString;
        }
        String fileEncodingName = ARFileHandler.parseForCharsetName(ARFileHandler.getFirstLine(xmlString));
        if (fileEncodingName.equalsIgnoreCase(newEncoding)) {
            return xmlString;
        }
        return xmlString.replaceFirst(fileEncodingName, newEncoding);
    }

    public static String getFirstLine(String defContent) {
        int firstLineIdx = defContent.indexOf(LOCAL_LINE_SEPERATOR);
        if (firstLineIdx < 0) {
            return defContent;
        }
        return defContent.substring(0, firstLineIdx);
    }

    public static String addCharSetNameToDef(String defContent, String charSetName) {
        if (defContent == null || defContent.length() < 1 || charSetName == null || charSetName.length() == 0) {
            return defContent;
        }
        int firstLineIdx = defContent.indexOf(LOCAL_LINE_SEPERATOR);
        if (firstLineIdx < 0) {
            return defContent;
        }
        String firstLine = ARFileHandler.getFirstLine(defContent);
        if (ARFileHandler.isXMLDoc(firstLine)) {
            return defContent;
        }
        String fileCharset = ARFileHandler.parseForCharsetName(firstLine);
        if (!fileCharset.equals("")) {
            if (fileCharset.equals(charSetName)) {
                return defContent;
            }
            defContent = defContent.substring((DEF_LEADING_CHARSET_INDICATOR + charSetName).length());
        }
        StringBuilder headerBuf = new StringBuilder();
        headerBuf.append(DEF_LEADING_CHARSET_INDICATOR);
        headerBuf.append(charSetName).append(LOCAL_LINE_SEPERATOR);
        headerBuf.append(defContent);
        return headerBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void concatenateFiles(String file1, String file2, String file3) throws IOException {
        SequenceInputStream f3 = null;
        FileInputStream f1 = null;
        FileInputStream f2 = null;
        BufferedInputStream inStream = null;
        FilterOutputStream outStream = null;
        try {
            f1 = new FileInputStream(file1);
            f2 = new FileInputStream(file2);
            f3 = new SequenceInputStream(f1, f2);
            inStream = new BufferedInputStream(f3);
            outStream = new BufferedOutputStream(System.out);
            inStream.skip(500L);
            boolean eof = false;
            int byteCount = 0;
            while (!eof) {
                int c = inStream.read();
                if (c == -1) {
                    eof = true;
                    continue;
                }
                ((BufferedOutputStream)outStream).write((char)c);
                ++byteCount;
            }
            String bytesRead = String.valueOf(byteCount);
            bytesRead = bytesRead + " bytes were read\n";
            ((BufferedOutputStream)outStream).write(bytesRead.getBytes(), 0, bytesRead.length());
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error("close instream failed", e);
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error("close outstream failed", e);
                }
            }
            if (f1 != null) {
                try {
                    f1.close();
                }
                catch (IOException e) {
                    log.error("close file: " + file1 + " failed", e);
                }
            }
            if (f2 != null) {
                try {
                    f2.close();
                }
                catch (IOException e) {
                    log.error("close file: " + file2 + " failed", e);
                }
            }
        }
    }

    public static byte[] readBytesFromFile(String filePathName) throws IOException {
        File file = new File(filePathName);
        return ARFileHandler.readBytesFromFile(file);
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        return ARFileHandler.readBytesFromFile(file, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromFile(File file, int offset, int length) throws IOException {
        if (length == 0) {
            return null;
        }
        if (offset < 0) {
            offset = 0;
        }
        int numBytesToRead = length;
        if (length < 0) {
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                log.error("Cannot read the whole file " + file.getCanonicalFile() + ". Can only read " + Integer.MAX_VALUE + " bytes a time");
            }
            numBytesToRead = (int)fileSize;
        }
        FileInputStream fStream = new FileInputStream(file);
        BufferedInputStream inputStream = new BufferedInputStream(fStream);
        byte[] bytes = null;
        try {
            bytes = new byte[numBytesToRead];
            int numBytesRead = inputStream.read(bytes, offset, numBytesToRead);
            if (length < 0 && numBytesRead < numBytesToRead) {
                String msg = "Could not read the whole file " + file.getCanonicalFile();
                log.error(msg);
                throw new IOException(msg);
            }
        }
        finally {
            inputStream.close();
            ((InputStream)fStream).close();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesIntoFile(byte[] buffer, String filePathName) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(filePathName);
            if (buffer != null) {
                outputStream.write(buffer);
            }
            outputStream.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesIntoFile(ARByteArrayBuffer buf, File file) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(file);
            outputStream.write(buf.getBuffer());
            outputStream.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesIntoFile(byte[] buffer, File file) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(file);
            outputStream.write(buffer);
            outputStream.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendBytesIntoFile(byte[] buffer, String filePathName) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(filePathName, true);
            outputStream.write(buffer);
            outputStream.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendBytesIntoFile(byte[] buffer, File file) throws IOException {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(file, true);
            outputStream.write(buffer);
            outputStream.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeObject(String fileName, Object obj) throws IOException {
        FileOutputStream fo = null;
        ObjectOutputStream so = null;
        try {
            fo = new FileOutputStream(fileName);
            so = new ObjectOutputStream(fo);
            so.writeObject(obj);
            so.flush();
        }
        finally {
            if (so != null) {
                try {
                    so.close();
                    so = null;
                }
                catch (Throwable e) {}
            }
            if (fo != null) {
                try {
                    fo.close();
                    fo = null;
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deSerializeObject(String fileName) throws IOException, ClassNotFoundException {
        Object deserializabledObj = null;
        FileInputStream fi = null;
        ObjectInputStream si = null;
        try {
            fi = new FileInputStream(fileName);
            si = new ObjectInputStream(fi);
            deserializabledObj = si.readObject();
        }
        finally {
            if (si != null) {
                try {
                    si.close();
                    si = null;
                }
                catch (Throwable e) {}
            }
            if (fi != null) {
                try {
                    fi.close();
                    fi = null;
                }
                catch (Throwable e) {}
            }
        }
        return deserializabledObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(String filePath) {
        StringBuffer strBuff = new StringBuffer();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(filePath));
            while ((str = in.readLine()) != null) {
                strBuff.append(str);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            log.error("File Not Found while trying to read ", e);
            String string = null;
            return string;
        }
        catch (IOException e1) {
            log.error("IOException  while trying to read file", e1);
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return strBuff.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(File fileToWrite, String stringToWrite) {
        boolean success = false;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(fileToWrite));
            out.write(stringToWrite);
            out.close();
            success = true;
        }
        catch (IOException e) {
            log.error("Write to file failed ", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable e) {}
                out = null;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExportBytesToFile(byte[] exportBytes, String filePath, boolean overwrite, String charSetName, String defaultEncoding) throws IOException {
        boolean isWin = System.getProperty("os.name").contains("Win");
        String lineSep = System.getProperty("line.separator");
        if (charSetName == null) {
            charSetName = "utf-8";
        }
        boolean eucJP = false;
        if (charSetName.equals("EUC_JP")) {
            eucJP = true;
        }
        BufferedReader br = null;
        BufferedWriter bfWriter = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(exportBytes), charSetName));
            int chunkSize = 2048;
            char[] chunkChars = new char[chunkSize];
            String chunk = null;
            int howManyRead = br.read(chunkChars);
            if (howManyRead != -1) {
                chunk = ARFileHandler.processExportChunk(howManyRead, chunkChars, isWin, eucJP, lineSep);
            }
            if (chunk != null) {
                chunk = ARFileHandler.addCharSetNameToDef(chunk, defaultEncoding);
                charSetName = ARFileHandler.parseForCharsetName(ARFileHandler.getFirstLine(chunk));
                bfWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, !overwrite), charSetName));
                bfWriter.write(chunk);
                while ((howManyRead = br.read(chunkChars)) != -1) {
                    chunk = ARFileHandler.processExportChunk(howManyRead, chunkChars, isWin, eucJP, lineSep);
                    bfWriter.write(chunk);
                }
            }
        }
        finally {
            if (bfWriter != null) {
                bfWriter.flush();
                bfWriter.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    private static String processExportChunk(int offset, char[] chunkChars, boolean isWin, boolean isEucJP, String lineSep) throws UnsupportedEncodingException {
        String chunk = null;
        chunk = offset < chunkChars.length ? new String(chunkChars, 0, offset) : new String(chunkChars);
        if (isEucJP) {
            chunk = new String(chunk.getBytes("SJIS"), "windows-31j");
        }
        if (isWin) {
            chunk = chunk.replace("\n", lineSep);
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readImportBytesFromFile(String filePath, String serverCharSet) throws IOException, UnsupportedEncodingException {
        String line = null;
        String charsetName = "";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader bfReader = null;
        OutputStream bfWriter = null;
        byte[] importBytes = null;
        FileReader fReader = null;
        try {
            fReader = new FileReader(filePath);
            bfReader = new BufferedReader(fReader);
            while ((line = bfReader.readLine()) != null) {
                if (line.trim().equals("")) continue;
                charsetName = ARFileHandler.parseForCharsetName(line);
                break;
            }
            if (charsetName.equals("")) {
                charsetName = ARCharSet.getServerKnownCharSetString(LOCAL_SYSTEM_FILE_ENCODING);
            }
            fis = new FileInputStream(filePath);
            String javaCharSet = ARCharSet.getServerCharSetName(";" + charsetName);
            isr = new InputStreamReader((InputStream)fis, javaCharSet);
            bfReader = new BufferedReader(isr);
            int chunkSize = 2048;
            char[] chunkChars = new char[chunkSize];
            String chunk = null;
            int howManyRead = bfReader.read(chunkChars);
            if (howManyRead != -1) {
                chunk = String.valueOf(chunkChars, 0, howManyRead);
                chunk = chunk.replace("\r\n", "\n");
            }
            if (chunk != null) {
                String firstLine = chunk.substring(0, chunk.indexOf("\n"));
                if (ARFileHandler.isXMLDoc(firstLine)) {
                    chunk = ARFileHandler.replaceCharSetNameInXMLDoc(chunk, serverCharSet);
                }
                bfWriter = new ByteArrayOutputStream();
                bfWriter.write(StringByteUtil.stringToMaxByteArray(chunk, serverCharSet, chunk.getBytes(serverCharSet).length));
                while ((howManyRead = bfReader.read(chunkChars)) != -1) {
                    chunk = String.valueOf(chunkChars, 0, howManyRead);
                    if ((chunk = chunk.replace("\r\n", "\n")).contains("\u001a")) {
                        throw new UnsupportedEncodingException("not translatable");
                    }
                    bfWriter.write(StringByteUtil.stringToMaxByteArray(chunk, serverCharSet, chunk.getBytes(serverCharSet).length));
                }
                importBytes = ((ByteArrayOutputStream)bfWriter).toByteArray();
            }
        }
        finally {
            if (bfWriter != null) {
                bfWriter.flush();
                ((ByteArrayOutputStream)bfWriter).close();
            }
            if (bfReader != null) {
                bfReader.close();
            }
            if (bfReader != null) {
                bfReader.close();
            }
            if (fReader != null) {
                fReader.close();
            }
        }
        return importBytes;
    }
}

