/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.qual.ARQualifierEncoder;
import java.math.BigDecimal;
import java.util.List;

public class ARAssignEncoder {
    private static final String SEPARATOR = "\\";
    private ARServerUser context;
    private AssignInfo assign;

    public ARAssignEncoder(AssignInfo assign, ARServerUser context) {
        this.context = context;
        this.assign = assign;
    }

    public String encode() throws ARException {
        return this.encodeAssignmentInfo(this.assign);
    }

    private String encodeAssignmentInfo(AssignInfo af) throws ARException {
        StringBuilder result = new StringBuilder();
        if (af == null) {
            return result.toString();
        }
        int assignType = af.getAssignType();
        int tag = 100 + assignType;
        result.append(tag + SEPARATOR);
        switch (assignType) {
            case 1: {
                Value val = af.getValue();
                String encodedVal = this.encodeValue(val);
                result.append(encodedVal);
                break;
            }
            case 2: {
                AssignFieldInfo afI = af.getField();
                result.append(this.encodeAssignFieldInfo(afI));
                break;
            }
            case 3: {
                result.append(af.getProcess().length() + SEPARATOR);
                result.append(af.getProcess() + SEPARATOR);
                break;
            }
            case 4: {
                ArithOpAssignInfo arOp = af.getArithOp();
                result.append(this.encodeArithOpAssignInfo(arOp));
                break;
            }
            case 5: {
                FunctionAssignInfo faI = af.getFunction();
                result.append(this.encodeFunctionAssignInfo(faI));
                break;
            }
            case 6: {
                result.append(this.encodeDDEAction(af.getDde()));
                break;
            }
            case 7: {
                result.append(ARAssignEncoder.encodeAssignSQLInfo(af.getSql()));
                break;
            }
            case 8: {
                result.append(this.encodeAssignFilterApiInfo(af.getFilterApi()));
                break;
            }
        }
        return result.toString();
    }

    private String encodeFunctionAssignInfo(FunctionAssignInfo faI) {
        StringBuilder result = new StringBuilder();
        result.append(faI.getFunctionCode() + SEPARATOR);
        result.append(faI.getNumItems() + SEPARATOR);
        List<AssignInfo> assignInfoList = faI.getParameterList();
        for (int i = 0; i < assignInfoList.size(); ++i) {
            AssignInfo item = assignInfoList.get(i);
            try {
                result.append(this.encodeAssignmentInfo(item));
                continue;
            }
            catch (ARException e) {
                // empty catch block
            }
        }
        return result.toString();
    }

    private String encodeValue(Value obj) {
        StringBuilder result = new StringBuilder();
        int dataType = 0;
        int len = 0;
        int dataTypeLoop = obj.getDataType().toInt();
        switch (dataTypeLoop) {
            case 0: {
                dataType = 0;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 1: {
                dataType = 1;
                result.append(dataType + SEPARATOR);
                Keyword kw = (Keyword)obj.getValue();
                result.append(kw.toInt() + SEPARATOR);
                break;
            }
            case 2: {
                if (obj.getDataType().toInt() == 2) {
                    result.append(this.encodeIntegerValue(obj));
                    break;
                }
                if (obj.getDataType().toInt() != 4) break;
                result.append(this.encodeCharValue(obj));
                break;
            }
            case 3: {
                result.append("3\\");
                result.append(obj.getValue().toString() + SEPARATOR);
                break;
            }
            case 4: {
                result.append("4\\");
                if (obj.getDataType().toInt() == 4) {
                    result.append(this.encodeCharValue(obj));
                    break;
                }
                if (obj.getDataType().toInt() != 2) break;
                result.append(this.encodeIntegerValue(obj));
                break;
            }
            case 5: {
                String diaryVal;
                dataType = 5;
                result.append(dataType + SEPARATOR);
                if (obj.getValue() instanceof DiaryListValue) {
                    DiaryListValue dlv = (DiaryListValue)obj.getValue();
                    diaryVal = dlv.toString();
                } else {
                    diaryVal = obj.getValue().toString();
                }
                result.append(diaryVal.trim() + SEPARATOR);
                break;
            }
            case 6: {
                dataType = 6;
                result.append(dataType + SEPARATOR);
                Number nbe = (Number)obj.getValue();
                result.append(nbe.intValue() + SEPARATOR);
                break;
            }
            case 7: {
                dataType = 7;
                result.append(dataType + SEPARATOR);
                Timestamp tme = (Timestamp)obj.getValue();
                result.append(tme.getValue() + SEPARATOR);
                break;
            }
            case 8: {
                dataType = 8;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 9: {
                dataType = 9;
                result.append(dataType + SEPARATOR);
                ByteListValue blv = (ByteListValue)obj.getValue();
                result.append(blv.getValue() + SEPARATOR);
                break;
            }
            case 10: {
                dataType = 10;
                result.append(dataType + SEPARATOR);
                len = obj.getValue().toString().trim().length();
                result.append(len + SEPARATOR);
                result.append(obj.getValue().toString().trim() + SEPARATOR);
                break;
            }
            case 11: {
                dataType = 11;
                result.append(dataType + SEPARATOR);
                AttachmentValue atvl = (AttachmentValue)obj.getValue();
                result.append(atvl.getValue() + SEPARATOR);
                break;
            }
            case 12: {
                result.append(this.encodeCurrencyValue(obj));
                break;
            }
            case 13: {
                dataType = 13;
                result.append(dataType + SEPARATOR);
                DateInfo dti = (DateInfo)obj.getValue();
                result.append(dti.getValue() + SEPARATOR);
                break;
            }
            case 14: {
                if (obj.getValue() instanceof Time) {
                    Time tm = (Time)obj.getValue();
                    dataType = 14;
                    result.append(dataType + SEPARATOR);
                    result.append(tm.getValue() + SEPARATOR);
                    break;
                }
                dataType = 4;
                result.append(dataType + SEPARATOR);
                result.append(obj.getValue().toString().length() + SEPARATOR);
                result.append(obj.getValue() + SEPARATOR);
                break;
            }
            case 30: {
                dataType = 30;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 31: {
                dataType = 31;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 32: {
                dataType = 32;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 33: {
                dataType = 33;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 34: {
                dataType = 34;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 35: {
                dataType = 35;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 36: {
                dataType = 36;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 37: {
                dataType = 37;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 40: {
                dataType = 40;
                result.append(dataType + SEPARATOR);
                Long lg = (Long)obj.getValue();
                result.append(lg + SEPARATOR);
                break;
            }
            case 41: {
                dataType = 41;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 42: {
                dataType = 42;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 43: {
                dataType = 43;
                result.append(dataType + SEPARATOR);
                break;
            }
            case 100: {
                dataType = 100;
                result.append(dataType + SEPARATOR);
                break;
            }
        }
        return result.toString();
    }

    private String encodeIntegerValue(Value obj) {
        StringBuilder result = new StringBuilder();
        int dataType = 2;
        result.append(dataType + SEPARATOR);
        Number nb = (Number)obj.getValue();
        result.append(nb.intValue() + SEPARATOR);
        return result.toString();
    }

    private String encodeCharValue(Value obj) {
        StringBuilder result = new StringBuilder();
        int len = obj.getValue().toString().length();
        result.append(len + SEPARATOR);
        result.append(obj.getValue().toString() + SEPARATOR);
        return result.toString();
    }

    private String encodeCurrencyValue(Value obj) {
        StringBuilder result = new StringBuilder();
        int dType = obj.getDataType().toInt();
        switch (dType) {
            case 12: {
                result.append("12\\");
                String currVal = obj.getCurrencyValue();
                CurrencyValue cv = (CurrencyValue)obj.getValue();
                int currLenField = currVal.length() + 13;
                result.append(currLenField + SEPARATOR + currVal.length() + SEPARATOR + currVal + SEPARATOR);
                if (cv.getCurrencyCode().length() == 0) break;
                result.append(cv.getCurrencyCode().length() + SEPARATOR + cv.getCurrencyCode() + SEPARATOR + "0" + SEPARATOR + "0" + SEPARATOR + SEPARATOR);
                break;
            }
            case 7: {
                result.append("7\\");
                Timestamp tme = (Timestamp)obj.getValue();
                result.append(tme.getValue() + SEPARATOR);
                break;
            }
            case 2: {
                result.append(this.encodeIntegerValue(obj));
                break;
            }
            case 10: {
                result.append("10\\");
                int len = obj.getValue().toString().trim().length();
                result.append(len + SEPARATOR);
                BigDecimal bd = (BigDecimal)obj.getValue();
                result.append(bd.doubleValue() + SEPARATOR);
            }
        }
        return result.toString();
    }

    private String encodeArithOpAssignInfo(ArithOpAssignInfo arOp) throws ARException {
        StringBuilder result = new StringBuilder();
        result.append(arOp.getOperation() + SEPARATOR);
        String leftAOI = this.encodeAssignmentInfo(arOp.getOperandLeft());
        result.append(leftAOI);
        String rightAOI = this.encodeAssignmentInfo(arOp.getOperandRight());
        result.append(rightAOI);
        return result.toString();
    }

    private static String encodeAssignSQLInfo(AssignSQLInfo info) {
        StringBuilder result = new StringBuilder();
        result.append(info.getServer().length()).append(SEPARATOR);
        result.append(info.getServer()).append(SEPARATOR);
        result.append(info.getSqlCommand().length()).append(SEPARATOR);
        result.append(info.getSqlCommand()).append(SEPARATOR);
        result.append(info.getValueIndex()).append(SEPARATOR);
        result.append(info.getNoMatchOption()).append(SEPARATOR);
        result.append(info.getMultiMatchOption()).append(SEPARATOR);
        return result.toString();
    }

    private String encodeAssignFieldInfo(AssignFieldInfo assignField) throws ARException {
        StringBuilder result = new StringBuilder();
        int fldTag = assignField.getTag();
        result.append(assignField.getServer().length() + SEPARATOR);
        String frm = assignField.getForm();
        result.append(assignField.getServer() + SEPARATOR);
        result.append(frm.length() + SEPARATOR);
        result.append(frm + SEPARATOR);
        result.append(fldTag + SEPARATOR);
        int fId = assignField.getFieldId();
        result.append(fId + SEPARATOR);
        QualifierInfo qual = assignField.getQualifier();
        if (qual != null) {
            ARQualifierEncoder qualEncoder = new ARQualifierEncoder(qual, this.getContext());
            String encodedQFI = qualEncoder.encode();
            result.append(encodedQFI);
        } else {
            result.append("0\\");
        }
        int nmo = assignField.getNoMatchOption();
        result.append(nmo + SEPARATOR);
        int mmo = assignField.getMultiMatchOption();
        result.append(mmo + SEPARATOR);
        return result.toString();
    }

    private String encodeDDEAction(DDEAction ddeAction) {
        StringBuilder result = new StringBuilder();
        result.append(ddeAction.getServiceName().length()).append(SEPARATOR);
        result.append(ddeAction.getServiceName()).append(SEPARATOR);
        result.append(ddeAction.getTopic().length()).append(SEPARATOR);
        result.append(ddeAction.getTopic()).append(SEPARATOR);
        result.append(ddeAction.getAction()).append(SEPARATOR);
        result.append(ddeAction.getPathToProgram().length()).append(SEPARATOR);
        result.append(ddeAction.getPathToProgram()).append(SEPARATOR);
        result.append(0).append(SEPARATOR);
        String strCommand = ddeAction.getCommand();
        if (strCommand != null && strCommand.length() != 0) {
            result.append(strCommand.length()).append(SEPARATOR);
        } else {
            result.append(SEPARATOR);
        }
        result.append(ddeAction.getItem().length()).append(SEPARATOR);
        result.append(ddeAction.getItem()).append(SEPARATOR);
        return result.toString();
    }

    private String encodeAssignFilterApiInfo(AssignFilterApiInfo info) throws ARException {
        StringBuilder result = new StringBuilder();
        result.append(info.getService().length()).append(SEPARATOR);
        result.append(info.getService()).append(SEPARATOR);
        result.append(info.getInputValues().size()).append(SEPARATOR);
        List<AssignInfo> items = info.getInputValues();
        for (AssignInfo item : items) {
            result.append(this.encodeAssignmentInfo(item));
        }
        result.append(info.getValueIndex()).append(SEPARATOR);
        return result.toString();
    }

    private ARServerUser getContext() {
        return this.context;
    }
}

