/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.arrpc.rpcext.NetworkWebSocketFactory;
import com.bmc.arsys.utils.LogBytes;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import org.acplt.oncrpc.ArLogBytes;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.ArNetworkSocketHelper;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.apache.log4j.Logger;

public class ArOncRpcSocketClient
extends OncRpcTcpClient {
    private static Logger logger = Logger.getLogger(ArOncRpcSocketClient.class);
    private ArNetworkSocket networkSocket;

    public ArOncRpcSocketClient(InetAddress host, int program, int version) throws OncRpcException, IOException {
        super(host, program, version);
    }

    public ArOncRpcSocketClient(InetAddress host, int program, int version, int port, int bufferSize, int timeout) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize, timeout);
    }

    public ArOncRpcSocketClient(InetAddress host, int program, int version, int port, int bufferSize) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize);
    }

    public ArOncRpcSocketClient(InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        super(host, program, version, port);
    }

    public ArOncRpcSocketClient(InetAddress host, int program, int version, int port, int bufferSize, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize, networkSessionInfo);
    }

    public ArOncRpcSocketClient(InetAddress host, int program, int version, int port, int bufferSize, int timeout, Map<Object, Object> networkSessionInfo) throws OncRpcException, IOException {
        super(host, program, version, port, bufferSize, timeout, networkSessionInfo);
    }

    @Override
    protected ArNetworkSocket createNewtowrkSocketHelper(InetAddress host, int port, int timeout, Map<Object, Object> sessionInfo) throws IOException {
        if (!ArOncRpcSocketClient.checkForSkipConnection(sessionInfo)) {
            if (host == null) {
                if (sessionInfo != null) {
                    host = InetAddress.getByName((String)sessionInfo.get("webSocket.server"));
                } else {
                    throw new RuntimeException("Server name is null");
                }
            }
            this.networkSocket = super.createNewtowrkSocketHelper(host, port, timeout, null);
        } else {
            try {
                this.networkSocket = this.createWebSocket(host, this.port, timeout, sessionInfo);
            }
            catch (IOException e) {
                String url = (String)sessionInfo.get("webSocket.URL");
                StringBuilder msg = new StringBuilder();
                String serverNameInSession = "";
                if (sessionInfo != null) {
                    serverNameInSession = (String)sessionInfo.get("webSocket.server");
                }
                msg.append("createWebSocket to " + serverNameInSession + ":" + port);
                if (url != null) {
                    msg.append(" through " + url);
                }
                msg.append(" failed w ");
                msg.append(e.getLocalizedMessage());
                logger.error(msg.toString());
                throw e;
            }
        }
        return this.networkSocket;
    }

    @Override
    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object obj, ArNetworkSocket networkSocket, int senderLen) throws IOException {
        if (super.getSocket() == null && networkSocket.getSocket() instanceof Socket) {
            super.setSocket(networkSocket.getSocket());
        }
        this.sendingXdr = new ArXdrTcpEncodingStream(networkSocket, senderLen);
        return this.sendingXdr;
    }

    @Override
    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object obj, ArNetworkSocket networkSocket, int senderLen) throws IOException {
        if (super.getSocket() == null && networkSocket.getSocket() instanceof Socket) {
            super.setSocket(networkSocket.getSocket());
        }
        this.receivingXdr = new ArXdrTcpDecodingStream(networkSocket, senderLen);
        return this.receivingXdr;
    }

    @Override
    protected void closeSocket() {
        if (this.networkSocket != null) {
            try {
                try {
                    logger.debug("networkSocket.closeSocket() is called. About to close socket " + this.networkSocket);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.networkSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.networkSocket = null;
        }
    }

    @Override
    public void setSoTimeout(int timeout) throws IOException {
        if (this.networkSocket == null) {
            super.setSoTimeout(timeout);
        } else {
            this.networkSocket.setSoTimeout(timeout);
        }
    }

    @Override
    public ArNetworkSocket getSocketHelper() {
        return this.networkSocket;
    }

    @Override
    public Object getSocket() {
        return this.networkSocket.getSocket();
    }

    @Override
    public void setSocket(Object so) {
        this.networkSocket.setSocket(so);
        if (so instanceof Socket) {
            super.setSocket(so);
        } else {
            super.setSocket(so);
        }
    }

    public ArNetworkSocket createWebSocket(InetAddress address, int port, int timeout, Map<Object, Object> sessionInfo) throws IOException {
        String url = null;
        String login = null;
        String password = null;
        String factoryClassName = null;
        String arserverName = null;
        if (sessionInfo != null) {
            arserverName = (String)sessionInfo.get("webSocket.server");
            url = (String)sessionInfo.get("webSocket.URL");
            login = (String)sessionInfo.get("webSocket.login");
            password = (String)sessionInfo.get("webSocket.password");
            factoryClassName = (String)sessionInfo.get("com.bmc.arsys.api.websocket.factoryClass");
            if (factoryClassName == null) {
                factoryClassName = "com.bmc.arsys.arrpc.rpcext.websocket.kaazing.NetworkWebSocketFactoryImpl";
            }
        }
        try {
            if (url != null && url.length() > 0) {
                Class<?> factoryClass = this.getClass().getClassLoader().loadClass(factoryClassName);
                NetworkWebSocketFactory factory = (NetworkWebSocketFactory)factoryClass.newInstance();
                this.networkSocket = factory.create(address, port, timeout, url, login, password);
                if (logger.isDebugEnabled()) {
                    logger.debug("Will connect to " + (String)sessionInfo.get("webSocket.server") + ":" + this.port + " tunneling " + url);
                }
                this.networkSocket.connect();
            } else {
                if (this.host == null) {
                    this.host = InetAddress.getByName((String)sessionInfo.get("webSocket.server"));
                }
                arserverName = this.host.getHostName();
                this.networkSocket = new ArNetworkSocketHelper(this.host, port, timeout, null);
                this.networkSocket.connect();
                this.setSocket(this.networkSocket.getSocket());
            }
        }
        catch (Exception e) {
            logger.error("Error when connecting to " + arserverName + ":" + this.port + " tunneling " + url, e);
            throw new IOException("Cannot create socket: " + e.getMessage());
        }
        return this.networkSocket;
    }

    public static void setNetworkBytesLog(boolean flag) {
        ArLogBytes.setDebugOn(flag);
    }

    public static void logNetworkMsg(String msg, int id, Exception e) {
        String newMsg = id > 0 ? String.format("[%03d] : " + msg, id) : msg;
        if (logger.isDebugEnabled()) {
            if (e != null) {
                logger.debug(newMsg, e);
            } else {
                logger.debug(newMsg);
            }
        }
    }

    public static void logNetworkBytes(byte[] in, int start, int len, String msg, int id) {
        String newMsg = id > 0 ? String.format("[%03d] : " + msg, id) : msg;
        if (logger.isTraceEnabled()) {
            LogBytes.printByteArrayAsHex(in, start, len, newMsg);
        } else if (logger.isDebugEnabled()) {
            logger.debug(newMsg);
        }
    }
}

