/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ArNioXdrTcpDecodingStream
extends ArXdrTcpDecodingStream {
    private static Logger log = Logger.getLogger(ArNioXdrTcpDecodingStream.class);
    private SocketChannel channel;
    private int transmissionTimeout;
    private int transmissionTimeoutEnc;
    private int encryptionCallSoTimeOutFactor = 1;

    public ArNioXdrTcpDecodingStream(SocketChannel streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket.socket(), bufferSize);
        this.channel = streamingSocket;
    }

    @Override
    protected void readBuffer(InputStream stream, byte[] bytes, int bytesToRead) throws IOException, OncRpcException {
        int byteOffset = 0;
        ByteBuffer buffer = ByteBuffer.allocate(bytesToRead);
        int bytesLeft = bytesToRead;
        if (log.isTraceEnabled()) {
            log.trace("ReadBuffer, bytesLeft=" + bytesLeft);
        }
        long start = System.currentTimeMillis();
        while (bytesLeft > 0) {
            int bytesRead = this.channel.read(buffer);
            if (bytesRead < 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Remote host aborted a request.");
                }
                throw new OncRpcException(4);
            }
            if (bytesRead == 0 && System.currentTimeMillis() - start > (long)this.getTransmissionTimeout()) {
                if (log.isTraceEnabled()) {
                    log.trace("ReadBuffer, bytesRead=" + bytesRead);
                }
                throw new OncRpcException(-1);
            }
            bytesLeft -= bytesRead;
            byteOffset += bytesRead;
            if (!log.isTraceEnabled()) continue;
            log.trace("ReadBuffer, bytesRead=" + bytesRead + "byteOffset=" + byteOffset);
        }
        byte[] readBytes = buffer.array();
        System.arraycopy(readBytes, 0, bytes, 0, bytesToRead);
    }

    public int getTransmissionTimeout() {
        if (this.isArProcessOn()) {
            return this.transmissionTimeoutEnc;
        }
        return this.transmissionTimeout;
    }

    public void setTransmissionTimeout(int transmissionTimeout) {
        this.transmissionTimeout = transmissionTimeout;
        this.transmissionTimeoutEnc = transmissionTimeout * this.encryptionCallSoTimeOutFactor;
    }

    @Override
    public void close() throws OncRpcException, IOException {
        if (this.channel != null) {
            if (this.channel.socket() != null) {
                this.channel.socket().close();
            }
            this.channel.close();
        }
        super.close();
    }
}

