/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.session.ArRpcTimeOut;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.ApiValueBase;
import com.bmc.arsys.apitransport.chunking.ARChunkProcessorFactory;
import com.bmc.arsys.apitransport.session.AREncryptAPISessionNodeBase;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiThreadLocalStorageBlock;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arrpc.ArBoolean;
import com.bmc.arsys.arrpc.ArByteList;
import com.bmc.arsys.arrpc.ArControlStruct12;
import com.bmc.arsys.arrpc.ArLocalizationInfo;
import com.bmc.arsys.arrpc.ArPropList;
import com.bmc.arsys.arrpc.ArPropStruct;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.utils.ARMachineGUID;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class ArRpcCallContext {
    private AREncryptAPISessionNodeBase _encCtx;
    private String _serverKey;
    private ArControlStruct12 _control;
    private boolean _encryptAPICalls = false;
    private boolean _skipXdrEncryption = true;
    private int _apiClientType;
    private int _vuiType;
    private boolean _doOverrideExistingSession;
    private int _rpcProgmNumber;
    private int _chunkResponseSize;
    private int _timeoutNormal;
    private int _timeoutLong;
    private int _timeoutXLong;
    private String _clientGUID;
    private int _internalArCallTimeout;
    private static final String _machineSourceId = ARMachineGUID.setMachineGuid();
    private static String _clientAddress = null;
    private static Logger logger = Logger.getLogger(ArRpcCallContext.class);

    protected ArRpcCallContext(String serverName, int port) {
        this.init();
        this.setServerKey(serverName, port);
    }

    private void init() {
        this._encCtx = new AREncryptAPISessionNodeBase();
        if (_clientAddress == null) {
            try {
                _clientAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                _clientAddress = "localhost";
                logger.error("Unknow InetAddress getLocalHost, " + e.getLocalizedMessage());
            }
        }
        this._clientGUID = _machineSourceId != null && _machineSourceId.length() != 0 ? _machineSourceId : _clientAddress;
        this._chunkResponseSize = 500000;
        this._timeoutNormal = 120;
        this._timeoutLong = 300;
        this._timeoutXLong = 1800;
        this._doOverrideExistingSession = false;
    }

    protected void cleanRpcCallContext() {
    }

    protected void setEncryptAPICalls(boolean encryptAPICalls) {
        this._encryptAPICalls = encryptAPICalls;
    }

    public boolean isAnEncryptedAPICall() {
        return this._encryptAPICalls && !this._skipXdrEncryption;
    }

    protected void setSkipXdrEncryption(boolean skipXdrEncryption) {
        this._skipXdrEncryption = skipXdrEncryption;
    }

    public String getServerCharSetName() {
        String serverCharSetName = null;
        if (this.getServerContext() != null) {
            serverCharSetName = this.getServerContext().getServerCharSetName();
        }
        if (serverCharSetName == null) {
            serverCharSetName = "windows-1252";
        }
        return serverCharSetName;
    }

    public boolean isLocalizedServerFlag() {
        if (this.getServerContext() != null) {
            return this.getServerContext().isLocalizedServerFlag();
        }
        return false;
    }

    public ARServerContext getServerContext() {
        return ProxyManager.getServerContextMap().get(this._serverKey);
    }

    protected String getServerKey() {
        return this._serverKey;
    }

    private void setServerKey(String serverName, int port) {
        this._serverKey = serverName + ":" + port;
        if (!ProxyManager.getServerContextMap().containsKey(this._serverKey)) {
            ARServerContext serverContext = new ARServerContext();
            serverContext.setServer(serverName);
            serverContext.setPort(port);
            ProxyManager.getServerContextMap().put(this._serverKey, serverContext);
        }
    }

    public ApiValueBase getSessionVariable(int tag) {
        ApiValueBase value = new ApiValueBase();
        switch (tag) {
            case 1: {
                value = new ApiValueBase(this._chunkResponseSize);
                break;
            }
            case 2: {
                if (ApiThreadLocalStorageBlock.getTLB().getInitConnectTimeout() > 120) {
                    value = new ApiValueBase(ApiThreadLocalStorageBlock.getTLB().getInitConnectTimeout());
                    break;
                }
                value = new ApiValueBase(this._timeoutNormal);
                break;
            }
            case 3: {
                value = new ApiValueBase(this._timeoutLong);
                break;
            }
            case 4: {
                value = new ApiValueBase(this._timeoutXLong);
                break;
            }
            case 6: {
                value = new ApiValueBase(ProxyManager.isUseConnectionPooling() ? 1 : 0);
                break;
            }
            case 7: {
                value = new ApiValueBase(this._apiClientType);
                break;
            }
            case 8: {
                value = new ApiValueBase(this._vuiType);
                break;
            }
            case 9: {
                value = new ApiValueBase(this._doOverrideExistingSession ? 1 : 0);
                break;
            }
            case 5: {
                value = new ApiValueBase(this._rpcProgmNumber);
                break;
            }
            case 1960: {
                value = new ApiValueBase(this._clientGUID);
                break;
            }
            case 12: {
                value = new ApiValueBase(this._internalArCallTimeout);
                break;
            }
            default: {
                logger.error("tag " + tag + " is not supported in getSessionVarible()");
            }
        }
        return value;
    }

    public void setSessionVariable(int variableId, ApiValueBase value) throws ARException {
        int intVal = 0;
        long longVal = 0L;
        String charVal = null;
        int dataType = value.getDataType().toInt();
        switch (dataType) {
            case 2: {
                intVal = (Integer)value.getValue();
                break;
            }
            case 4: {
                charVal = (String)value.getValue();
                break;
            }
            case 40: {
                longVal = (Long)value.getValue();
                break;
            }
            default: {
                logger.error("dataType " + dataType + " is not supported in setSessionVarible()");
                throw new ARException(2, 110);
            }
        }
        switch (variableId) {
            case 7: {
                this._apiClientType = intVal;
                break;
            }
            case 8: {
                this._vuiType = intVal;
                break;
            }
            case 9: {
                this._doOverrideExistingSession = intVal == 1;
                break;
            }
            case 1: {
                this._chunkResponseSize = this.calculateResponseSize(intVal);
                break;
            }
            case 2: {
                if (intVal <= 0) {
                    this._timeoutNormal = 120;
                    break;
                }
                this._timeoutNormal = intVal;
                break;
            }
            case 3: {
                if (intVal <= 0) {
                    this._timeoutLong = 300;
                    break;
                }
                this._timeoutLong = intVal;
                break;
            }
            case 4: {
                if (intVal <= 0) {
                    this._timeoutXLong = 1800;
                    break;
                }
                this._timeoutXLong = intVal;
                break;
            }
            case 5: {
                if (!(longVal == 0L || longVal == 390600L || longVal >= 390619L && longVal <= 390669L || longVal >= 390680L && longVal <= 390694L) && (longVal < 390680L || longVal > 390699L)) break;
                this._rpcProgmNumber = (int)longVal;
                break;
            }
            case 1960: {
                if (charVal == null) break;
                this._clientGUID = charVal;
                break;
            }
            case 12: {
                this._internalArCallTimeout = intVal;
                break;
            }
        }
    }

    private int calculateResponseSize(int userChunkSize) {
        int rst = 500000;
        int xdrLimit = 0;
        ARServerContext svrCxt = this.getServerContext();
        if (svrCxt != null) {
            xdrLimit = svrCxt.getRpcClientXDRSizeLimit();
        }
        if (xdrLimit != 0 && userChunkSize != 0) {
            rst = Math.min(xdrLimit, userChunkSize);
        } else if (xdrLimit != 0) {
            rst = xdrLimit;
        } else if (userChunkSize != 0) {
            rst = userChunkSize;
        }
        return rst;
    }

    public int getTimeOutSetting(int procedureNumber) {
        int timeOut = 0;
        if (procedureNumber == 182) {
            return 28800;
        }
        switch (ArRpcTimeOut.getInstance().getTimeOut(procedureNumber)) {
            case 2: {
                timeOut = this._timeoutLong;
                break;
            }
            case 3: {
                timeOut = this._timeoutXLong;
                break;
            }
            default: {
                timeOut = this._timeoutNormal;
            }
        }
        if ((procedureNumber == 34 || procedureNumber == 35) && timeOut < 28800) {
            return 28800;
        }
        return timeOut;
    }

    public ArControlStruct12 loadRpcControlStruct(ApiUserContextI context, int procedureNum) throws ARException {
        if (this._control == null) {
            this._control = new ArControlStruct12();
        }
        this._control.setUser(context.getUser() == null ? "" : context.getUser());
        this._control.setLocaleInfo(new ArLocalizationInfo(context.getLocale(), "UTF-8", context.getTimeZone(), context.getCustomDateFormat(), context.getCustomTimeFormat(), ""));
        if (ARChunkProcessorFactory.isChunkingSupportedCall(procedureNum)) {
            this._control.setMaxResponse(this._chunkResponseSize);
        } else {
            this._control.setMaxResponse(0);
        }
        this._control.setVuiType(this._vuiType);
        this._control.setApiClientType(this._apiClientType);
        this._control.setDone(new ArBoolean(1));
        this._control.setCacheId((int)context.getCacheId());
        this._control.setRequestId(0);
        this._control.setTimeout(this.getSessionVariable(12).getIntValue());
        if (context.getLogging() != null && context.getLogging().isEnabled()) {
            this._control.setLogMask((int)context.getLogging().getType());
        } else {
            this._control.setLogMask(0);
        }
        this._control.threadID = this._doOverrideExistingSession ? (this._control.threadID |= 1) : (this._control.threadID &= 0);
        try {
            this.loadRpcControlStructAuthStr(context);
            this.loadRpcControlStructPropList(context);
            this._control.password.setPasswordStr(context.getPassword(), this.getServerCharSetName());
        }
        catch (AREncryptionException e) {
            throw new ARException(2, e.getErrorNum(), e.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException e1) {
            throw new ARException(2, 9062, e1.getLocalizedMessage());
        }
        return this._control;
    }

    private void loadRpcControlStructAuthStr(ApiUserContextI context) throws UnsupportedEncodingException {
        String ipAddress = null;
        boolean olderServerMajorVersion = false;
        if (this.getServerContext() != null && this.getServerContext().getServerMajorVersion() <= 6) {
            olderServerMajorVersion = true;
        }
        ipAddress = this._apiClientType == 9 && olderServerMajorVersion ? this._clientGUID : _clientAddress;
        String authStr = null;
        String ctxAuthStr = context.getAuthentication();
        authStr = ctxAuthStr == null || ctxAuthStr.length() == 0 ? "0::" + ipAddress : ctxAuthStr.getBytes(this.getServerCharSetName()).length + ":" + ctxAuthStr + ":" + ipAddress;
        this._control.setAuthString(new ArByteList(7, StringByteUtil.stringToMaxByteArray(authStr, this.getServerCharSetName(), authStr.getBytes(this.getServerCharSetName()).length + 1)));
    }

    private void loadRpcControlStructPropList(ApiUserContextI context) throws UnsupportedEncodingException {
        String impersonatedUser = context.getImpersonatedUser();
        String guid = context.getUserSessionGuid();
        int overlayObjType = context.getOverlayObjType();
        int granularOverlayMode = context.getGranularMode();
        String overlayGrpName = context.getOverlayGroup();
        String designOverlayGrp = context.getDesignOverlayGroup();
        String transHandle = null;
        String tenantId = context.getTenantId();
        String ipAddress = context.getEndClientIPAddress();
        String serviceStatMsg = context.getServiceStatMsg();
        if (context instanceof ARServerUser) {
            transHandle = ((ARServerUser)context).getTransactionHandle();
        } else {
            logger.warn("Context is not type of ARServerUser");
        }
        int numProps = 1;
        if (impersonatedUser != null && impersonatedUser.length() != 0) {
            ++numProps;
        }
        if (guid != null && guid.length() != 0) {
            ++numProps;
        }
        if (overlayGrpName != null && overlayGrpName.length() != 0) {
            ++numProps;
        }
        if (tenantId != null && tenantId.length() != 0) {
            ++numProps;
        }
        if (designOverlayGrp != null && designOverlayGrp.length() != 0) {
            ++numProps;
        }
        if (transHandle != null && transHandle.length() != 0) {
            ++numProps;
        }
        if (ipAddress != null && ipAddress.length() != 0) {
            ++numProps;
        }
        if (serviceStatMsg != null && serviceStatMsg.length() != 0) {
            ++numProps;
        }
        ArPropStruct[] props = new ArPropStruct[++numProps];
        int i = 0;
        props[i] = new ArPropStruct(2, new ArValueStruct(4, this._clientGUID));
        ++i;
        if (transHandle != null && transHandle.length() != 0) {
            props[i] = new ArPropStruct(60037, new ArValueStruct(4, transHandle));
            ++i;
        }
        if (impersonatedUser != null && impersonatedUser.length() != 0) {
            props[i] = new ArPropStruct(1, new ArValueStruct(4, context.getImpersonatedUser()));
            if (context.getImpersonatedCacheId() != 0L) {
                this._control.cacheId = (int)context.getImpersonatedCacheId();
            }
            ++i;
        }
        if (guid != null && guid.length() != 0) {
            props[i] = new ArPropStruct(0, new ArValueStruct(4, guid));
            ++i;
        }
        if (overlayGrpName != null && overlayGrpName.length() != 0) {
            props[i] = new ArPropStruct(60058, new ArValueStruct(4, overlayGrpName));
            ++i;
        }
        if (tenantId != null && tenantId.length() != 0) {
            props[i] = new ArPropStruct(60074, new ArValueStruct(4, tenantId));
            ++i;
        }
        if (designOverlayGrp != null && designOverlayGrp.length() != 0) {
            props[i] = new ArPropStruct(60059, new ArValueStruct(4, designOverlayGrp));
            ++i;
        }
        if (ipAddress != null && ipAddress.length() != 0) {
            props[i] = new ArPropStruct(60071, new ArValueStruct(4, ipAddress));
            ++i;
        }
        if (serviceStatMsg != null && serviceStatMsg.length() != 0) {
            props[i] = new ArPropStruct(60073, new ArValueStruct(4, serviceStatMsg));
            ++i;
        }
        props[i] = new ArPropStruct(60068, new ArValueStruct(2, granularOverlayMode));
        ++i;
        this._control.setReservedPropList(new ArPropList(props));
    }

    public AREncryptAPISessionNodeBase getEncCtx() {
        return this._encCtx;
    }
}

