/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.apitransport.ApiUserContextI;

public class ApiProxyType {
    public static final int RPC_NONE = 0;
    public static final int AR_JRPC = 1;
    public static final int AR_JNI_RPC = 2;
    public static final int CMDB_JRPC = 3;
    public static final String AR_PROXY_NAME = "com.bmc.arsys.api.ProxyJRpc";
    static final String AR_JNI_PROXY_NAME = "com.bmc.arsys.api.Proxy";
    public static final String CMDB_PROXY_IDENTIFIER = "cmdbproxy";
    public static final String CMDB_PROXY_POOL_SUFFIX = "_CMDB";
    private int proxyType = 0;

    public ApiProxyType() {
    }

    public ApiProxyType(int rpcType) {
        this.proxyType = rpcType;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(int proxyType) {
        this.proxyType = proxyType;
    }

    public boolean isARJRpcProxyType() {
        boolean flag = false;
        if (1 == this.getProxyType()) {
            flag = true;
        }
        return flag;
    }

    public boolean isCMDBProxyType() {
        boolean flag = false;
        if (3 == this.getProxyType()) {
            flag = true;
        }
        return flag;
    }

    public boolean isARJniProxyType() {
        boolean flag = false;
        if (2 == this.getProxyType()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isARJRpcProxyName(ApiUserContextI context, String proxyClassName) {
        boolean flag = false;
        if (proxyClassName != null && AR_PROXY_NAME.equals(proxyClassName)) {
            flag = true;
        }
        return flag;
    }

    public static boolean isARJniProxyName(ApiUserContextI context, String proxyClassName) {
        boolean flag = false;
        if (proxyClassName != null && AR_JNI_PROXY_NAME.equals(proxyClassName)) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCMDBProxyName(ApiUserContextI context, String proxyClassName) {
        boolean flag = false;
        if (proxyClassName != null && proxyClassName.toLowerCase().contains(CMDB_PROXY_IDENTIFIER)) {
            flag = true;
        }
        return flag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.proxyType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiProxyType other = (ApiProxyType)obj;
        return this.proxyType == other.proxyType;
    }
}

