/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.chunking;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.chunking.ARChunkReceiveProcessor;
import com.bmc.arsys.arrpc.ArBoolean;
import com.bmc.arsys.arrpc.ArFieldValueList;
import com.bmc.arsys.arrpc.ArFieldValueStruct;
import com.bmc.arsys.arrpc.ArGetMultipleEntries12Out;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ARChunkGetMultipleEntries
extends ARChunkReceiveProcessor {
    private static Logger logger = Logger.getLogger(ARChunkGetMultipleEntries.class);
    private ArrayList<ArFieldValueList> entryList;
    private ArBoolean[] existingList;

    @Override
    public void retrieveChunkingData(ArRpcXdrOut out) throws ARException {
        super.retrieveChunkingData(out);
        ArGetMultipleEntries12Out gmeOut = (ArGetMultipleEntries12Out)out;
        ArFieldValueList[] outList = gmeOut.getFieldList().value;
        if (outList == null || outList.length < 1) {
            return;
        }
        int fieldPerEntry = gmeOut.getFieldPerEntry();
        int fvLen = gmeOut.getTotalSent();
        if (this.entryList == null) {
            this.existingList = gmeOut.getExistList().getValue();
            this.entryList = new ArrayList();
            int numFullEntry = fvLen / fieldPerEntry;
            if (logger.isDebugEnabled()) {
                logger.debug("gme: 1st chunking: numFullEntry = " + numFullEntry);
            }
            for (int i = 0; i < numFullEntry; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug("fullEntry append fieldValues list after " + this.entryList.size());
                }
                this.entryList.add(outList[i]);
            }
            int numFieldsInFrag = fvLen % fieldPerEntry;
            if (numFieldsInFrag > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("gme: 1st chunking: numFieldsInFrag = " + numFieldsInFrag);
                }
                ArFieldValueStruct[] fragEntry = new ArFieldValueStruct[numFieldsInFrag];
                for (int i = 0; i < numFieldsInFrag; ++i) {
                    fragEntry[i] = outList[numFullEntry].value[i];
                }
                if (fragEntry.length > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("gme: 1st chunking: fragEntry append fieldValues list after " + this.entryList.size() + " with numNewFragFields = " + numFieldsInFrag);
                    }
                    this.entryList.add(new ArFieldValueList(fragEntry));
                } else if (logger.isDebugEnabled()) {
                    logger.debug("gme: 1st chunking: fragEntry.length " + fragEntry.length);
                }
            }
            if (logger.isDebugEnabled() && this.existingList != null && this.entryList != null) {
                logger.debug("gme: 1st chunking: num full Enties = " + numFullEntry + " existingList = " + this.existingList.length + " entryList generated = " + this.entryList.size());
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("gme: chunking: totalSent = " + fvLen + " fieldPerEntry = " + fieldPerEntry);
            }
            ArFieldValueStruct[] firstEntry = outList[0].value;
            int firstId = firstEntry[0].getFieldId().value;
            ArFieldValueStruct[] lastEntry = this.entryList.get((int)(this.entryList.size() - 1)).value;
            int lastEntryLen = lastEntry.length;
            int lastId = lastEntry[lastEntryLen - 1].fieldId.value;
            if (logger.isDebugEnabled()) {
                logger.debug("entryList.size() = " + this.entryList.size() + " lastEntryLen = " + lastEntryLen);
            }
            int numFieldsInFrag = 0;
            if (fvLen > 0 && firstId == lastId && lastId != 0 && lastId != 15) {
                numFieldsInFrag = 1;
                ArValueStruct fragVal = lastEntry[lastEntryLen - 1].value;
                if (logger.isDebugEnabled()) {
                    logger.debug("fragVal.dataType = " + fragVal.dataType);
                }
                switch (fragVal.dataType) {
                    case 5: {
                        fragVal.diaryVal = fragVal.diaryVal + outList[0].value[0].value.diaryVal;
                        break;
                    }
                    case 4: {
                        fragVal.charVal = fragVal.charVal + outList[0].value[0].value.charVal;
                        break;
                    }
                }
            }
            if (lastEntry.length < fieldPerEntry && (firstId != lastId || fvLen != 1)) {
                int availableLen = fvLen > fieldPerEntry - lastEntryLen ? fieldPerEntry - lastEntryLen : fvLen - numFieldsInFrag;
                ArFieldValueStruct[] newEntry = new ArFieldValueStruct[lastEntryLen + availableLen];
                System.arraycopy(lastEntry, 0, newEntry, 0, lastEntryLen);
                System.arraycopy(firstEntry, numFieldsInFrag, newEntry, lastEntryLen, availableLen);
                if (logger.isDebugEnabled()) {
                    logger.debug("merge Entry additional " + availableLen + " fields, update to fieldValues list at " + this.entryList.size());
                }
                this.entryList.get((int)(this.entryList.size() - 1)).value = newEntry;
                if (logger.isDebugEnabled()) {
                    logger.debug("after merge Entry update entryList.size() = " + this.entryList.size());
                }
                numFieldsInFrag += availableLen;
            }
            int numFullEntry = (fvLen - numFieldsInFrag) / fieldPerEntry;
            if (logger.isDebugEnabled()) {
                logger.debug("numFullEntry = " + numFullEntry);
            }
            for (int i = 0; i < numFullEntry; ++i) {
                ArFieldValueStruct[] entry = new ArFieldValueStruct[fieldPerEntry];
                for (int j = 0; j < fieldPerEntry; ++j) {
                    entry[j] = j + numFieldsInFrag < fieldPerEntry ? outList[i].value[j + numFieldsInFrag] : outList[i + 1].value[j + numFieldsInFrag - fieldPerEntry];
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("fullEntry append fieldValues list after " + this.entryList.size());
                }
                this.entryList.add(new ArFieldValueList(entry));
            }
            int numNewFragFields = (fvLen - numFieldsInFrag) % fieldPerEntry;
            if (numNewFragFields > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("numNewFragFields = " + numNewFragFields);
                }
                ArFieldValueStruct[] fragEntry = new ArFieldValueStruct[numNewFragFields];
                for (int i = 0; i < numNewFragFields; ++i) {
                    fragEntry[i] = i + numFieldsInFrag < fieldPerEntry ? outList[numFullEntry].value[i + numFieldsInFrag] : outList[numFullEntry + 1].value[i + numFieldsInFrag - fieldPerEntry];
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("fragEntry append fieldValues list after " + this.entryList.size() + " with numNewFragFields = " + numNewFragFields);
                }
                this.entryList.add(new ArFieldValueList(fragEntry));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("gme: chunking lastEntryLen = " + lastEntryLen + "; lastId = " + lastId + "; numFullEntry this round = " + numFullEntry);
            }
        }
    }

    @Override
    public void postProcess(ArRpcXdrOut out) throws ARException {
        ((ArGetMultipleEntries12Out)out).getExistList().value = this.existingList;
        if (this.entryList != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("gme: postProcess existList = " + this.existingList.length + " total entry = " + this.entryList.size());
            }
            ((ArGetMultipleEntries12Out)out).getFieldList().value = new ArFieldValueList[this.entryList.size()];
            for (int i = 0; i < this.entryList.size(); ++i) {
                ((ArGetMultipleEntries12Out)out).getFieldList().value[i] = this.entryList.get(i);
            }
        } else {
            ((ArGetMultipleEntries12Out)out).getFieldList().value = null;
        }
    }
}

