/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SqlMenu
extends Menu
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2052241371369789193L;
    private String m_server;
    private String m_sqlCommand;
    private List<Integer> m_labelIndex;
    private int m_valueIndex;

    protected SqlMenu() {
    }

    public SqlMenu(String server, String sqlCommand, int labelIndex, int valueIndex) {
        this.m_server = server;
        this.m_sqlCommand = sqlCommand;
        this.m_labelIndex = new ArrayList<Integer>(5);
        this.m_labelIndex.add(labelIndex);
        for (int i = 1; i < 5; ++i) {
            this.m_labelIndex.add(0);
        }
        this.m_valueIndex = valueIndex;
    }

    public SqlMenu(String server, String sqlCommand, List<Integer> labelIndex, int valueIndex) {
        this.m_server = server;
        this.m_sqlCommand = sqlCommand;
        this.m_labelIndex = labelIndex;
        this.m_valueIndex = valueIndex;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SqlMenu menu = null;
        menu = (SqlMenu)super.clone();
        menu.m_server = this.m_server;
        menu.m_sqlCommand = this.m_sqlCommand;
        menu.m_valueIndex = this.m_valueIndex;
        if (this.m_labelIndex != null) {
            menu.m_labelIndex = new ArrayList<Integer>(this.m_labelIndex.size());
            for (int i = 0; i < this.m_labelIndex.size(); ++i) {
                menu.m_labelIndex.add(new Integer(this.m_labelIndex.get(i)));
            }
        }
        return menu;
    }

    public String getServer() {
        return this.m_server;
    }

    public String getSQLCommand() {
        return this.m_sqlCommand;
    }

    public List<Integer> getLabelIndex() {
        return this.m_labelIndex;
    }

    public int getValueIndex() {
        return this.m_valueIndex;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SqlMenu)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SqlMenu rhs = (SqlMenu)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_server, rhs.m_server).append(this.m_sqlCommand, rhs.m_sqlCommand).append(this.m_labelIndex, rhs.m_labelIndex).append(this.m_valueIndex, rhs.m_valueIndex).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_server).append(this.m_sqlCommand).append(this.m_labelIndex).append(this.m_valueIndex).toHashCode();
    }

    @Override
    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        super.fromVariant(rawData, ctx);
        rawData = (Object[])ARTypeMgr.GetAt((Object)rawData, new int[]{5, 1});
        this.m_server = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_sqlCommand = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 1));
        this.m_labelIndex = ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, ARTypeMgr.GetAt((Object)rawData, 2), ctx);
        this.m_valueIndex = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 3));
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Server", this.m_server).append("Sql Command", this.m_sqlCommand).append("Label Index", this.m_labelIndex).append("Value Index", this.m_valueIndex).toString();
    }

    public void setServer(String server) {
        this.m_server = server;
        this.m_changeFlags.setParameter(9L, true);
    }

    public void setSQLCommand(String sqlCommand) {
        this.m_sqlCommand = sqlCommand;
        this.m_changeFlags.setParameter(9L, true);
    }

    public void setLabelIndex(List<Integer> index) {
        this.m_labelIndex = index;
        this.m_changeFlags.setParameter(9L, true);
    }

    public void setValueIndex(int index) {
        this.m_valueIndex = index;
        this.m_changeFlags.setParameter(9L, true);
    }

    protected List<MenuItem> expandMenu(ARServerUser context) throws ARException {
        List<Object> menuItemList = new ArrayList();
        ARServerUser contextToUse = this.getContextToUse(context);
        if (this.isAdminPrivOverride(this.m_sqlCommand) && contextToUse != context) {
            menuItemList = contextToUse.expandMenu(this);
        } else {
            SQLResult result = contextToUse.getListSQL(this.m_sqlCommand, 0, true);
            List<List<Value>> contents = result.getContents();
            if (contents.size() > 0) {
                menuItemList = this.valueListListToMenuItemList(contents);
            }
        }
        return menuItemList;
    }

    private ARServerUser getContextToUse(ARServerUser context) {
        ARServerUser newContext;
        ARServerUser contextToUse = this.m_server.equalsIgnoreCase(context.getServer()) || this.m_server.equals("@") ? context : (newContext = new ARServerUser(context.getUser(), context.getPassword(), context.getAuthentication(), context.getLocale(), context.getTimeZone(), "", "", this.m_server));
        return contextToUse;
    }

    private boolean isAdminPrivOverride(String sqlCommand) throws ARException {
        return sqlCommand.charAt(0) == '+';
    }

    private List<MenuItem> valueListListToMenuItemList(List<List<Value>> contents) throws ARException {
        int n;
        MenuItem topMenuItem = new MenuItem("", new ArrayList<MenuItem>());
        int valueIndex = this.m_valueIndex - 1;
        int numLevels = 0;
        Iterator<Object> i$ = this.m_labelIndex.iterator();
        while (i$.hasNext() && (n = i$.next().intValue()) != 0) {
            ++numLevels;
        }
        if (numLevels == 0) {
            numLevels = 1;
        }
        for (List list : contents) {
            MenuItem parentMenuItem = topMenuItem;
            String value = ((Value)list.get(valueIndex)).valueToString();
            for (int level = 0; level < numLevels; ++level) {
                String label = new String();
                int labelIndex2 = this.m_labelIndex.get(level);
                if (labelIndex2 <= list.size()) {
                    label = ((Value)list.get(labelIndex2 - 1)).valueToString();
                }
                MenuItem childMenuItem = new MenuItem(label, value);
                List<MenuItem> subMenu = parentMenuItem.getSubMenu();
                if (subMenu != null && subMenu.size() > 0) {
                    MenuItem prevMenuItem = subMenu.get(subMenu.size() - 1);
                    if (level == numLevels - 1) {
                        if (childMenuItem.equals(prevMenuItem)) {
                            parentMenuItem = prevMenuItem;
                            continue;
                        }
                    } else if (label.equals(prevMenuItem.getLabel())) {
                        parentMenuItem = prevMenuItem;
                        continue;
                    }
                }
                parentMenuItem.setSubMenu(childMenuItem);
                parentMenuItem = childMenuItem;
            }
        }
        return topMenuItem.getSubMenu();
    }
}

