/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.ARWebSocketConfig;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DefaultProxyManager;
import com.bmc.arsys.api.PoolingProxyManager;
import com.bmc.arsys.api.ProxyPool;
import com.bmc.arsys.apitransport.ApiConfig;
import com.bmc.arsys.apitransport.ApiConfigI;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.ApiWebSocketConfig;
import com.bmc.arsys.apitransport.connection.ApiProxyManager;
import com.bmc.arsys.apitransport.connection.ApiProxyManagerI;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.utils.ProcessUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class ProxyManager
extends ApiProxyManager {
    protected static final ReentrantLock lock = new ReentrantLock();
    private static Map<String, ARServerContext> arServerContextMap = new Hashtable<String, ARServerContext>();
    private static Logger logger = Logger.getLogger(ProxyManager.class);

    ProxyManager() {
    }

    ProxyManager(int maxProxiesPerServer, int idleConnectionsPerServer, long connectionTimeout, long connectionLifespan, ARTimeUnit unit) {
        super(maxProxiesPerServer, idleConnectionsPerServer, connectionTimeout, connectionLifespan, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiProxyManagerI getProxyManager() {
        if (currentManager == null) {
            lock.lock();
            try {
                if (currentManager == null) {
                    currentManager = ProxyManager.isUseConnectionPooling() ? new PoolingProxyManager(ApiProxyManager.maxProxiesPerServer, ApiProxyManager.idleConnectionsPerServer, ApiProxyManager.connectionTimeout, ApiProxyManager.connectionLifespan, ARTimeUnit.MILLISECONDS) : new DefaultProxyManager();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return currentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectionLimits(int maxPerServer) {
        lock.lock();
        try {
            maxProxiesPerServer = maxPerServer;
            if (logger.isInfoEnabled()) {
                logger.info("Currently, connection pooling " + ProxyManager.isUseConnectionPooling());
                logger.info("Client sets connection limits per server to :" + maxPerServer);
            }
            if (currentManager != null && currentManager instanceof PoolingProxyManager) {
                ((ApiProxyManager)currentManager).adjustProxyPoolVariables(maxPerServer, idleConnectionsPerServer, connectionTimeout, ARTimeUnit.MILLISECONDS);
            }
            if (logger.isInfoEnabled()) {
                ProxyManager.getPoolInformation();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustConnectionPoolVariables(PoolInfo poolsetting) {
        if (logger.isInfoEnabled()) {
            logger.info("Currently, connection pooling " + ProxyManager.isUseConnectionPooling());
        }
        if (poolsetting == null) {
            if (logger.isInfoEnabled()) {
                logger.info("adjustConnectionPoolVariable with poolsetting null. No change");
            }
        } else {
            int idleConnectionsPerServer = poolsetting.getIdleConnectionsPerServer();
            int maxProxyPerServer = poolsetting.getPoolMaxProxyPerServer();
            long connectionTimeout = poolsetting.getPoolConnectionTimeout();
            ARTimeUnit unit = poolsetting.getPoolUnit();
            if (logger.isInfoEnabled()) {
                logger.info("Client adjusts connection variables maximumPoolSize = " + maxProxyPerServer + " minIdleProxySize = " + idleConnectionsPerServer + " connectionTimeout = " + connectionTimeout + " timeUnit = " + (Object)((Object)poolsetting.getPoolUnit()));
            }
            if (idleConnectionsPerServer > maxProxyPerServer) {
                idleConnectionsPerServer = maxProxyPerServer / 2;
                logger.info("idleConnectionsPerServer value cannot be more than maxProxiesPerServer. idleConnectionsPerServer reverted to " + idleConnectionsPerServer);
            }
            lock.lock();
            try {
                ApiProxyManager.idleConnectionsPerServer = idleConnectionsPerServer;
                ApiProxyManager.maxProxiesPerServer = maxProxyPerServer;
                long l = ApiProxyManager.connectionTimeout = unit == null ? connectionTimeout : unit.toMillis(connectionTimeout);
                if (currentManager != null && currentManager instanceof ApiProxyManager) {
                    ((ApiProxyManager)currentManager).adjustProxyPoolVariables(maxProxyPerServer, idleConnectionsPerServer, ApiProxyManager.connectionTimeout, ARTimeUnit.MILLISECONDS);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static long getConnectionLifespan(ARTimeUnit toUnit) {
        if (toUnit == null) {
            return ApiProxyManager.connectionLifespan;
        }
        return ARTimeUnit.MILLISECONDS.convert(ApiProxyManager.connectionLifespan, toUnit);
    }

    public static void setConnectionLifespan(long newConnectionLifespan, ARTimeUnit unit) {
        if (logger.isInfoEnabled()) {
            logger.info("Client set connectionLifespan = " + newConnectionLifespan + " timeUnit = " + (Object)((Object)unit));
        }
        ApiProxyManager.setConnectionLifespan(newConnectionLifespan, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseConnectionPooling(boolean usePooling) {
        logger.info("Client sets useConnectionPooling to : " + usePooling);
        if (useConnectionPooling == usePooling) {
            return;
        }
        if (currentManager != null) {
            logger.debug("ProxyManager setUseConnectionPooling usePooling = " + usePooling + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            lock.lock();
            try {
                useConnectionPooling = usePooling;
                currentManager.clear();
                currentManager = null;
                currentManager = ProxyManager.getProxyManager();
            }
            finally {
                lock.unlock();
            }
        } else {
            logger.debug("ProxyManager directly setUseConnectionPooling usePooling = " + usePooling + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            useConnectionPooling = usePooling;
        }
    }

    public static boolean isUseConnectionPooling() {
        return useConnectionPooling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolInfo[] getPoolInformation() {
        PoolInfo[] pools;
        block9: {
            pools = new PoolInfo[]{};
            try {
                if (!lock.tryLock(30L, TimeUnit.SECONDS)) break block9;
                try {
                    logger.info("UsePooling: " + ProxyManager.isUseConnectionPooling());
                    if (currentManager != null && currentManager instanceof ProxyManager && (pools = ((ProxyManager)currentManager).getInfo()) != null && logger.isInfoEnabled()) {
                        for (int i = 0; i <= pools.length - 1; ++i) {
                            StringBuilder str = new StringBuilder();
                            str.append(", Pool info: server- " + pools[i].getPoolServerName()).append(", # free proxy- " + pools[i].getPoolFree()).append(", # in used- " + pools[i].getPoolInUse()).append(", # not created- " + pools[i].getPoolNotCreated()).append(", establish- " + pools[i].getPoolEstablishTimeFormated()).append(", last used- " + pools[i].getPoolLastUsedTimeFormated()).append(", # ever reached pool size- " + pools[i].getPoolLargestReachedPoolSize()).append(", # maxProxyPerServer- " + pools[i].getPoolMaxProxyPerServer()).append(", # idleConnectionsPerServer- " + pools[i].getIdleConnectionsPerServer()).append(", connectionTimeout setting- " + pools[i].getPoolConnectionTimeoutElapsedTimeFormated()).append(", connectionLifespan setting- " + pools[i].getPoolConnectionLifespanElapsedTimeFormated());
                            logger.info(str);
                        }
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (InterruptedException e) {
                logger.info("Skipped the getPoolInformation after waiting for 30 seconds");
            }
        }
        if (pools == null || pools.length == 0) {
            pools = new PoolInfo[1];
            long c = System.currentTimeMillis();
            pools[0] = new PoolInfo("", 0, 0, ProxyManager.getMaxProxiesPerServer(), c, c, 0, ProxyManager.getMaxProxiesPerServer(), ProxyManager.getIdleConnectionsPerServer(), ProxyManager.getConnectionTimeout(ARTimeUnit.MILLISECONDS), ProxyManager.getConnectionLifespan(ARTimeUnit.MILLISECONDS), ARTimeUnit.MILLISECONDS);
            if (pools != null && logger.isInfoEnabled()) {
                StringBuilder str = new StringBuilder();
                str.append(", Pool setting info: ").append(", # maxProxyPerServer- " + maxProxiesPerServer).append(", # idleConnectionsPerServer- " + idleConnectionsPerServer).append(", connectionTimeout setting- " + ProcessUtil.getElapsedTimeToFormatedString(connectionTimeout)).append(", connectionLifespan setting- " + ProcessUtil.getElapsedTimeToFormatedString(connectionLifespan));
                logger.info(str);
            }
        }
        return pools;
    }

    PoolInfo[] getInfo() {
        PoolInfo[] pools = new PoolInfo[this.serverProxyPools.size()];
        Iterator it = this.serverProxyPools.keySet().iterator();
        int idx = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            ProxyPool tp = (ProxyPool)this.serverProxyPools.get(key);
            pools[idx] = tp.getInfo(key);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(key);
            logger.debug(pools[idx].toString());
        }
        return pools;
    }

    public static Map<String, ARServerContext> getServerContextMap() {
        return arServerContextMap;
    }

    public static ARServerContext getARServerContext(String serverName, int port) {
        String serverKey = serverName + ":" + port;
        return arServerContextMap.get(serverKey);
    }

    @Override
    public ApiProxyI createProxy(ApiUserContextI context) throws ARException {
        return this.getProxyFactory().createProxy(context);
    }

    public static void setWebSocket(ApiUserContextI context, Map<String, ARWebSocketConfig> updateConfigs) {
        logger.info("Client called setWebSocket : " + updateConfigs);
        ApiConfigI apiConfig = context.getApiConfig();
        if (apiConfig instanceof ApiConfig) {
            Map<String, ApiWebSocketConfig> convertedConfig = ProxyManager.convertWebSocketConfig(updateConfigs);
            ((ApiConfig)apiConfig).updateWebSocketSettingsInXml(convertedConfig);
        }
    }

    private static Map<String, ApiWebSocketConfig> convertWebSocketConfig(Map<String, ARWebSocketConfig> updateConfigs) {
        HashMap<String, ARWebSocketConfig> newConfig = null;
        if (updateConfigs != null) {
            newConfig = new HashMap<String, ARWebSocketConfig>();
            for (String key : updateConfigs.keySet()) {
                newConfig.put(key, updateConfigs.get(key));
            }
        }
        return newConfig;
    }

    public static class PoolInfo {
        protected String mServerKey;
        protected int mFree;
        protected int mInUse;
        protected int mNotCreated;
        protected int mMaxProxyPerServer;
        protected int mIdleConnection;
        protected int mLargestReachedPoolSize;
        protected long mConnectionTimeout;
        protected long mConnectionLifespan;
        protected long mLastUsed;
        protected long mEstablished;
        protected ARTimeUnit mUnit;

        public PoolInfo(int maxProxyPerServer, int idleConnectionsPerServer, long connectionTimeout, ARTimeUnit unit) {
            this("", 0, 0, ApiProxyManager.getMaxProxiesPerServer(), System.currentTimeMillis(), System.currentTimeMillis(), 0, maxProxyPerServer, idleConnectionsPerServer, connectionTimeout, 0L, unit);
        }

        PoolInfo(String skey, int inuse, int free, int notCreated, long established, long lastUsed, int largestReachedPoolSize, int maxProxyPerServer, int idleConnectionsPerServer, long connectionTimeout, long connectionLifespan, ARTimeUnit unit) {
            this.mServerKey = skey;
            this.mInUse = inuse;
            this.mFree = free;
            this.mNotCreated = notCreated;
            this.mEstablished = established;
            this.mLastUsed = lastUsed;
            this.mMaxProxyPerServer = maxProxyPerServer;
            this.mIdleConnection = idleConnectionsPerServer;
            this.mConnectionTimeout = connectionTimeout;
            this.mConnectionLifespan = connectionLifespan;
            this.mLargestReachedPoolSize = largestReachedPoolSize;
            this.mUnit = unit;
        }

        public void setPoolMaxProxyPerServer(int mMaxProxyPerServer) {
            this.mMaxProxyPerServer = mMaxProxyPerServer;
        }

        public void setIdleConnectionsPerServer(int idleConnectionsPerServer) {
            this.mIdleConnection = idleConnectionsPerServer;
        }

        public long getPoolConnectionTimeout() {
            return this.mConnectionTimeout;
        }

        public void setPoolConnectionTimeout(long newConnectionTimeout) {
            this.mConnectionTimeout = newConnectionTimeout;
        }

        public long getPoolConnectionLifespan() {
            return this.mConnectionLifespan;
        }

        public void setPoolConnectionLifespan(long newConnectionLifespan) {
            this.mConnectionLifespan = newConnectionLifespan;
        }

        public String getPoolServerName() {
            return this.mServerKey;
        }

        public int getPoolInUse() {
            return this.mInUse;
        }

        public int getPoolFree() {
            return this.mFree;
        }

        public int getPoolNotCreated() {
            return this.mNotCreated;
        }

        public long getPoolLastUsed() {
            return this.mLastUsed;
        }

        public String getPoolLastUsedTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getFormatedTimeUsed(this.mLastUsed);
            }
            return ProcessUtil.getFormatedTimeUsed(this.mUnit.toMillis(this.mLastUsed));
        }

        public String getPoolConnectionTimeoutElapsedTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getElapsedTimeToFormatedString(this.mConnectionTimeout);
            }
            return ProcessUtil.getElapsedTimeToFormatedString(this.mUnit.toMillis(this.mConnectionTimeout));
        }

        public String getPoolEstablishTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getFormatedTimeUsed(this.mEstablished);
            }
            return ProcessUtil.getFormatedTimeUsed(this.mUnit.toMillis(this.mEstablished));
        }

        public String getPoolConnectionLifespanElapsedTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getElapsedTimeToFormatedString(this.mConnectionLifespan);
            }
            return ProcessUtil.getElapsedTimeToFormatedString(this.mUnit.toMillis(this.mConnectionLifespan));
        }

        public int getPoolMaxProxyPerServer() {
            return this.mMaxProxyPerServer;
        }

        public int getIdleConnectionsPerServer() {
            return this.mIdleConnection;
        }

        public long getPoolEstablish() {
            return this.mEstablished;
        }

        public int getPoolLargestReachedPoolSize() {
            return this.mLargestReachedPoolSize;
        }

        public ARTimeUnit getPoolUnit() {
            return this.mUnit;
        }

        public String toString() {
            String str = new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("ServerKey", this.mServerKey).append(" # free proxy", this.mFree).append(" # in used", this.mInUse).append(" # not created", this.mNotCreated).append(" establish at", this.getPoolEstablishTimeFormated()).append(" last used at", this.getPoolLastUsedTimeFormated()).append(" # ever reached pool size", this.mLargestReachedPoolSize).append(" # maxProxyPerServer", this.mMaxProxyPerServer).append(" # idleConnectionsPerServer", this.mIdleConnection).append(" connectionTimeout", this.getPoolConnectionTimeoutElapsedTimeFormated()).append(" connectionLifespan", this.getPoolConnectionLifespanElapsedTimeFormated()).toString();
            if (logger.isTraceEnabled()) {
                logger.trace(str);
            }
            return str;
        }
    }
}

