/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.ProxyPool;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.connection.ApiProxyManager;
import com.bmc.arsys.apitransport.connection.ApiProxyPoolI;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PoolingProxyManager
extends ProxyManager
implements Serializable {
    private static final long serialVersionUID = 7634654297977419586L;

    PoolingProxyManager(int maxProxiesPerServer) {
        super(maxProxiesPerServer, ApiProxyManager.idleConnectionsPerServer, ApiProxyManager.connectionTimeout, ApiProxyManager.connectionLifespan, ARTimeUnit.MILLISECONDS);
    }

    PoolingProxyManager(int maxProxiesPerServer, int minProxiesPerServer, long connectionTimeout, long connectionLifespan, ARTimeUnit unit) {
        super(maxProxiesPerServer, minProxiesPerServer, connectionTimeout, connectionLifespan, unit);
    }

    @Override
    protected ApiProxyPoolI getServerPool(ApiUserContextI context) throws ARException {
        return super.getServerPool(context);
    }

    @Override
    public ApiProxyI getProxy(ApiUserContextI context) throws ARException {
        return super.getProxy(context);
    }

    @Override
    public void releaseProxy(ApiProxyI proxy, ApiUserContextI context) {
        super.releaseProxy(proxy, context);
    }

    @Override
    ProxyManager.PoolInfo[] getInfo() {
        String displayServerKey;
        ApiProxyPoolI pool;
        ArrayList<ProxyManager.PoolInfo> pial = new ArrayList<ProxyManager.PoolInfo>();
        Hashtable<String, ApiProxyPoolI> exclusiveProxyPools = new Hashtable<String, ApiProxyPoolI>();
        Enumeration serverKeys = this.serverProxyPools.keys();
        while (serverKeys.hasMoreElements()) {
            String serverKey = (String)serverKeys.nextElement();
            pool = (ApiProxyPoolI)this.serverProxyPools.get(serverKey);
            if (pool == null || !(pool instanceof ProxyPool)) continue;
            if (exclusiveProxyPools.containsValue(pool)) {
                if (!serverKey.contains(":")) continue;
                Enumeration displayServerKeys = exclusiveProxyPools.keys();
                while (displayServerKeys.hasMoreElements()) {
                    displayServerKey = (String)displayServerKeys.nextElement();
                    ApiProxyPoolI displayPool = (ApiProxyPoolI)exclusiveProxyPools.get(displayServerKey);
                    if (!displayPool.equals(pool)) continue;
                    exclusiveProxyPools.remove(displayServerKey);
                    exclusiveProxyPools.put(serverKey, pool);
                }
                continue;
            }
            exclusiveProxyPools.put(serverKey, pool);
        }
        Enumeration exclusiveServerKey = exclusiveProxyPools.keys();
        while (exclusiveServerKey.hasMoreElements()) {
            displayServerKey = (String)exclusiveServerKey.nextElement();
            pool = (ApiProxyPoolI)exclusiveProxyPools.get(displayServerKey);
            if (pool == null || !(pool instanceof ProxyPool)) continue;
            ProxyManager.PoolInfo info = ((ProxyPool)pool).getInfo(displayServerKey);
            pial.add(info);
        }
        return pial.toArray(new ProxyManager.PoolInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.clear();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Max Proxies Per Server", PoolingProxyManager.getMaxProxiesPerServer()).append("Server Proxy Pools", this.serverProxyPools).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.serverProxyPools).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PoolingProxyManager)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PoolingProxyManager rhs = (PoolingProxyManager)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.serverProxyPools, rhs.serverProxyPools).isEquals();
    }

    @Override
    protected ApiProxyPoolI createNewPool(String serverKey, int maxProxiesPerServer) {
        return new ProxyPool(serverKey, PoolingProxyManager.getMaxProxiesPerServer());
    }
}

