/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.AttachmentField;
import com.bmc.arsys.api.AttachmentPoolField;
import com.bmc.arsys.api.CharacterField;
import com.bmc.arsys.api.ColumnField;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ControlField;
import com.bmc.arsys.api.CurrencyField;
import com.bmc.arsys.api.DateOnlyField;
import com.bmc.arsys.api.DateTimeField;
import com.bmc.arsys.api.DecimalField;
import com.bmc.arsys.api.DiaryField;
import com.bmc.arsys.api.DisplayField;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.FieldKey;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.IntegerField;
import com.bmc.arsys.api.ObjectBase;
import com.bmc.arsys.api.ObjectBaseCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.PageField;
import com.bmc.arsys.api.PageHolderField;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.RealField;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.TableField;
import com.bmc.arsys.api.TimeOnlyField;
import com.bmc.arsys.api.TrimField;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ViewField;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Field
extends ObjectBase
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7226486073853387597L;
    private boolean m_reservedIDOK;
    private FieldMapping m_fieldMap;
    private int m_option;
    private int m_createMode;
    private int m_auditOption;
    private Value m_defaultValue;
    private FieldLimit m_limit;
    private DisplayInstanceMap m_dInstanceList;
    private FieldKey m_key;
    private int m_setFieldOptions;
    private List<PermissionInfo> m_AssignedGroup;
    private ObjectPropertyMap m_objPropList;

    public Field() {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.m_key = new FieldKey(null, 0);
        this.hashValues = new Integer[20];
    }

    public Field(String form, int id) {
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        this.m_key = new FieldKey(form, id);
        this.hashValues = new Integer[20];
    }

    protected Field(String name, List<PermissionInfo> permissionList, String helpText, long lastUpdateTime, String owner, String lastChangedBy, String diaryStr) {
        super(name, null, helpText, lastUpdateTime, owner, lastChangedBy, diaryStr);
        if (this.m_changeFlags == null) {
            this.createChangeFlags();
        }
        if (permissionList == null || permissionList.isEmpty()) {
            this.m_permissionList = permissionList;
        } else {
            this.setPermissions(permissionList);
        }
        this.hashValues = new Integer[20];
        this.calculateHashCode();
    }

    @Override
    protected void createChangeFlags() {
        this.m_changeFlags = new FieldCriteria();
    }

    @Override
    public void setPermissions(List<PermissionInfo> permissionList) {
        if (permissionList == null) {
            this.m_permissionList = null;
        } else {
            this.m_permissionList = new ArrayList(permissionList.size());
            this.m_AssignedGroup = new ArrayList<PermissionInfo>(permissionList.size());
            for (int i = 0; i < permissionList.size(); ++i) {
                int intVal = permissionList.get(i).getGroupID();
                this.m_permissionList.add(new PermissionInfo(intVal, permissionList.get(i).getPermissionValue()));
                this.m_AssignedGroup.add(new PermissionInfo(intVal, permissionList.get(i).getPermissionValue()));
            }
        }
        this.m_changeFlags.setParameter(1L, true);
    }

    public int getDataType() {
        if (this instanceof CharacterField) {
            return 4;
        }
        if (this instanceof IntegerField) {
            return 2;
        }
        if (this instanceof RealField) {
            return 3;
        }
        if (this instanceof DiaryField) {
            return 5;
        }
        if (this instanceof SelectionField) {
            return 6;
        }
        if (this instanceof DateTimeField) {
            return 7;
        }
        if (this instanceof DecimalField) {
            return 10;
        }
        if (this instanceof AttachmentField) {
            return 11;
        }
        if (this instanceof CurrencyField) {
            return 12;
        }
        if (this instanceof DateOnlyField) {
            return 13;
        }
        if (this instanceof TimeOnlyField) {
            return 14;
        }
        if (this instanceof TableField) {
            return 33;
        }
        if (this instanceof ColumnField) {
            return 34;
        }
        if (this instanceof ViewField) {
            return 42;
        }
        if (this instanceof DisplayField) {
            return 43;
        }
        if (this instanceof TrimField) {
            return 31;
        }
        if (this instanceof ControlField) {
            return 32;
        }
        if (this instanceof PageField) {
            return 35;
        }
        if (this instanceof PageHolderField) {
            return 36;
        }
        if (this instanceof AttachmentPoolField) {
            return 37;
        }
        return 0;
    }

    public int getFieldType() {
        switch (this.getDataType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return 1;
            }
            case 11: {
                return 128;
            }
            case 12: 
            case 13: 
            case 14: {
                return 1;
            }
            case 31: {
                return 2;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 32;
            }
            case 34: {
                return 64;
            }
            case 35: {
                return 8;
            }
            case 36: {
                return 16;
            }
            case 37: {
                return 256;
            }
        }
        return 0;
    }

    public void setFieldID(int fid) {
        this.m_key.setFieldID(fid);
    }

    public int getFieldID() {
        return this.m_key.getFieldID();
    }

    public void setForm(String form) {
        this.m_key.setFormName(form);
    }

    public String getForm() {
        return this.m_key.getFormName();
    }

    public void setFieldOption(int opt) {
        this.m_option = opt;
        this.m_changeFlags.setParameter(10L, true);
    }

    public int getFieldOption() {
        return this.m_option;
    }

    public void setSetFieldOptions(int opt) {
        this.m_setFieldOptions = opt;
        this.m_changeFlags.setParameter(16L, true);
    }

    public int getSetFieldOptions() {
        return this.m_setFieldOptions;
    }

    public boolean SetFieldOptionsSet() {
        return this.optionSet(16);
    }

    public boolean optionSet(int index) {
        return this.m_changeFlags.getParameters()[index];
    }

    public void setReservedIDOK(boolean flag) {
        this.m_reservedIDOK = flag;
    }

    public boolean getReservedIDOK() {
        return this.m_reservedIDOK;
    }

    public void setCreateMode(int cm) {
        this.m_createMode = cm;
        this.m_changeFlags.setParameter(11L, true);
    }

    public int getCreateMode() {
        return this.m_createMode;
    }

    public void setAuditOption(int auditOption) {
        this.m_auditOption = auditOption;
        this.m_changeFlags.setParameter(12L, true);
    }

    public int getAuditOption() {
        return this.m_auditOption;
    }

    public void setDefaultValue(Value v) {
        this.m_defaultValue = v;
        this.m_changeFlags.setParameter(13L, true);
    }

    public Value getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setFieldLimit(FieldLimit limit) {
        this.m_limit = limit;
        this.m_changeFlags.setParameter(14L, true);
    }

    public FieldLimit getFieldLimit() {
        return this.m_limit;
    }

    public FieldMapping getFieldMap() {
        return this.m_fieldMap;
    }

    public void setFieldMap(FieldMapping mapInfo) {
        this.m_fieldMap = mapInfo;
        this.m_changeFlags.setParameter(8L, true);
    }

    public void setDisplayInstance(DisplayInstanceMap displayInstance) {
        this.m_dInstanceList = displayInstance;
        this.m_changeFlags.setParameter(15L, true);
    }

    public DisplayInstanceMap getDisplayInstance() {
        return this.m_dInstanceList;
    }

    public void setObjectProperty(ObjectPropertyMap objPropList) {
        this.m_objPropList = objPropList;
        this.m_changeFlags.setParameter(18L, true);
    }

    public ObjectPropertyMap getObjectProperty() {
        return this.m_objPropList;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Field field = (Field)super.clone();
        if (this.m_key != null) {
            field.setKey((FieldKey)this.m_key.clone());
        }
        if (this.m_fieldMap != null) {
            field.setFieldMap((FieldMapping)this.m_fieldMap.clone());
        }
        if (this.m_defaultValue != null) {
            field.setDefaultValue((Value)this.m_defaultValue.clone());
        }
        if (this.m_limit != null) {
            field.setFieldLimit((FieldLimit)this.m_limit.clone());
        }
        if (this.m_dInstanceList != null) {
            field.setDisplayInstance((DisplayInstanceMap)this.m_dInstanceList.clone());
        }
        if (this.m_objPropList != null) {
            field.setObjectProperty((ObjectPropertyMap)this.m_objPropList.clone());
        }
        if (this.m_changeFlags != null) {
            field.m_changeFlags = (FieldCriteria)this.m_changeFlags.clone();
        }
        this.calculateHashCode();
        return field;
    }

    public FieldKey getKey() {
        return this.m_key;
    }

    public void setKey(FieldKey key) {
        this.m_key = key;
    }

    @Override
    public void clear() {
        super.clear();
        this.m_key = null;
        this.m_fieldMap = null;
        this.m_defaultValue = null;
        this.m_limit = null;
        this.m_dInstanceList = null;
    }

    private void fromVariantDuringGet(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.setForm(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 3)));
        this.setFieldID(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 4)));
        this.setName(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 5)));
        this.setFieldMap(FieldMapping.createInstance((Object[])ARTypeMgr.GetAt((Object)rawData, 6), ctx));
        this.setFieldOption(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 8)));
        this.setCreateMode(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 9)));
        this.setAuditOption(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 10)));
        this.setDefaultValue(ARTypeMgr.getInstance().ObjectFromVariant(Value.class, ARTypeMgr.GetAt((Object)rawData, 11), ctx));
        this.setPermissions(ARTypeMgr.getInstance().ObjectListFromVariant(PermissionInfo.class, ARTypeMgr.GetAt((Object)rawData, 12), ctx));
        this.setFieldLimit(FieldLimit.createInstance((Object[])ARTypeMgr.GetAt((Object)rawData, 13), ctx));
        this.setDisplayInstance(ARTypeMgr.getInstance().ObjectFromVariant(DisplayInstanceMap.class, ARTypeMgr.GetAt((Object)rawData, new int[]{14, 0}), ctx));
        this.setHelpText(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 15)));
        this.setLastUpdateTime(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 16)));
        this.setOwner(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 17)));
        this.setLastChangedBy(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 18)));
        this.setDiary(ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 19)));
        this.setObjectProperty(ARTypeMgr.getInstance().ObjectFromVariant(ObjectPropertyMap.class, ARTypeMgr.GetAt((Object)rawData, new int[]{20, 0}), ctx));
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.fromVariantDuringGet(rawData, ctx);
    }

    static Field createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        Field obj = null;
        int dataType = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, new int[]{7}));
        switch (dataType) {
            case 2: {
                obj = ARTypeMgr.getInstance().NewObject(IntegerField.class, ctx);
                break;
            }
            case 3: {
                obj = ARTypeMgr.getInstance().NewObject(RealField.class, ctx);
                break;
            }
            case 5: {
                obj = ARTypeMgr.getInstance().NewObject(DiaryField.class, ctx);
                break;
            }
            case 6: 
            case 8: {
                obj = ARTypeMgr.getInstance().NewObject(SelectionField.class, ctx);
                break;
            }
            case 7: {
                obj = ARTypeMgr.getInstance().NewObject(DateTimeField.class, ctx);
                break;
            }
            case 10: {
                obj = ARTypeMgr.getInstance().NewObject(DecimalField.class, ctx);
                break;
            }
            case 11: {
                obj = ARTypeMgr.getInstance().NewObject(AttachmentField.class, ctx);
                break;
            }
            case 12: {
                obj = ARTypeMgr.getInstance().NewObject(CurrencyField.class, ctx);
                break;
            }
            case 13: {
                obj = ARTypeMgr.getInstance().NewObject(DateOnlyField.class, ctx);
                break;
            }
            case 14: {
                obj = ARTypeMgr.getInstance().NewObject(TimeOnlyField.class, ctx);
                break;
            }
            case 33: {
                obj = ARTypeMgr.getInstance().NewObject(TableField.class, ctx);
                break;
            }
            case 34: {
                obj = ARTypeMgr.getInstance().NewObject(ColumnField.class, ctx);
                break;
            }
            case 42: {
                obj = ARTypeMgr.getInstance().NewObject(ViewField.class, ctx);
                break;
            }
            case 43: {
                obj = ARTypeMgr.getInstance().NewObject(DisplayField.class, ctx);
                break;
            }
            case 31: {
                obj = ARTypeMgr.getInstance().NewObject(TrimField.class, ctx);
                break;
            }
            case 32: {
                obj = ARTypeMgr.getInstance().NewObject(ControlField.class, ctx);
                break;
            }
            case 35: {
                obj = ARTypeMgr.getInstance().NewObject(PageField.class, ctx);
                break;
            }
            case 36: {
                obj = ARTypeMgr.getInstance().NewObject(PageHolderField.class, ctx);
                break;
            }
            case 37: {
                obj = ARTypeMgr.getInstance().NewObject(AttachmentPoolField.class, ctx);
                break;
            }
            default: {
                obj = ARTypeMgr.getInstance().NewObject(CharacterField.class, ctx);
            }
        }
        obj.fromVariant(rawData, ctx);
        return obj;
    }

    static List<Field> buildGMFResponse(Object[] rawData, ARServerUser ctx) {
        int count;
        ArrayList<Field> objectList = new ArrayList<Field>();
        assert (rawData != null && rawData.length == 22);
        String formName = ConversionUtil.getStringValue(rawData[3]);
        int n = count = rawData[5] != null ? ARTypeMgr.GetArrayLength(rawData[5]) : 0;
        assert (count == ARTypeMgr.GetArrayLength(rawData[10]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[11]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[12]) || rawData[12] == null || 0 == ARTypeMgr.GetArrayLength(rawData[12]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[13]));
        int permissionsCount = ARTypeMgr.GetArrayLength(rawData[14]);
        assert (permissionsCount == 0 || count == permissionsCount);
        assert (count == ARTypeMgr.GetArrayLength(rawData[15]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[16]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[17]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[18]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[19]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[20]));
        assert (count == ARTypeMgr.GetArrayLength(rawData[21]));
        for (int i = 0; i < count; ++i) {
            Field obj = null;
            if (!ConversionUtil.getBooleanValue(ARTypeMgr.GetAt((Object)rawData, new int[]{5, i}))) continue;
            Object[] curRawData = new Object[]{0, null, ctx, formName, ARTypeMgr.GetAt((Object)rawData, new int[]{6, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{7, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{8, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{9, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{10, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{11, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{12, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{13, i}), permissionsCount == 0 ? null : ARTypeMgr.GetAt((Object)rawData, new int[]{14, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{15, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{16, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{17, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{18, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{19, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{20, i}), ARTypeMgr.GetAt((Object)rawData, new int[]{21, i})};
            obj = Field.createInstance(curRawData, ctx);
            DisplayInstanceMap.fixARDisplayProps(obj.getDisplayInstance());
            objectList.add(obj);
        }
        return objectList;
    }

    public boolean isCoreField() {
        return Field.isCoreFieldId(this.getFieldID());
    }

    public static boolean isCoreFieldId(int fieldId) {
        switch (fieldId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Reserved IDOK", this.m_reservedIDOK).append("Field Map", this.m_fieldMap).append("Option", this.m_option).append("Create Mode", this.m_createMode).append("Audit Option", this.m_auditOption).append("Default Value", this.m_defaultValue).append("Limit", this.m_limit).append("DInstance List", this.m_dInstanceList).append("Key", this.m_key).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_reservedIDOK).append(this.m_fieldMap).append(this.m_option).append(this.m_createMode).append(this.m_auditOption).append(this.m_defaultValue).append(this.m_limit).append(this.m_dInstanceList).append(this.m_key).append(this.m_setFieldOptions).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Field)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Field rhs = (Field)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_reservedIDOK, rhs.m_reservedIDOK).append(this.m_fieldMap, rhs.m_fieldMap).append(this.m_option, rhs.m_option).append(this.m_createMode, rhs.m_createMode).append(this.m_auditOption, rhs.m_auditOption).append(this.m_defaultValue, rhs.m_defaultValue).append(this.m_limit, rhs.m_limit).append(this.m_dInstanceList, rhs.m_dInstanceList).append(this.m_key, rhs.m_key).append(this.m_setFieldOptions, rhs.m_setFieldOptions).isEquals();
    }

    @Override
    void calculateHashCode() {
        if (this.hashValues == null) {
            this.hashValues = new Integer[20];
        }
        super.calculateHashCode();
        this.hashValues[8] = this.m_fieldMap != null ? Integer.valueOf(this.m_fieldMap.hashCode()) : null;
        this.hashValues[13] = this.m_defaultValue != null ? Integer.valueOf(this.m_defaultValue.hashCode()) : null;
        this.hashValues[14] = this.m_limit != null ? Integer.valueOf(this.m_limit.hashCode()) : null;
        this.hashValues[15] = this.m_dInstanceList != null ? Integer.valueOf(this.m_dInstanceList.hashCode()) : null;
        this.hashValues[18] = this.m_objPropList != null ? Integer.valueOf(this.m_objPropList.hashCode()) : null;
    }

    @Override
    void calculateHashCodeOnGet(ObjectBaseCriteria criteria) {
        super.calculateHashCodeOnGet(criteria == null ? new FieldCriteria() : criteria);
    }

    @Override
    void calculateChangeFlagsOnSet() {
        int hashCode;
        if (this.hashValues == null) {
            this.hashValues = new Integer[20];
        }
        super.calculateChangeFlagsOnSet();
        boolean[] changeFlags = this.m_changeFlags.getParameters();
        if (!changeFlags[8]) {
            if (this.m_fieldMap != null) {
                hashCode = this.m_fieldMap.hashCode();
                if (this.hashValues[8] == null || hashCode != this.hashValues[8]) {
                    this.m_changeFlags.setParameter(8L, true);
                }
                this.hashValues[8] = this.m_fieldMap != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[8] != null) {
                this.m_changeFlags.setParameter(8L, true);
                this.hashValues[8] = null;
            }
        }
        if (!changeFlags[13]) {
            if (this.m_defaultValue != null) {
                hashCode = this.m_defaultValue.hashCode();
                if (this.hashValues[13] == null || hashCode != this.hashValues[13]) {
                    this.m_changeFlags.setParameter(13L, true);
                }
                this.hashValues[13] = this.m_defaultValue != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[13] != null) {
                this.m_changeFlags.setParameter(13L, true);
                this.hashValues[13] = null;
            }
        }
        if (!changeFlags[14]) {
            if (this.m_limit != null) {
                hashCode = this.m_limit.hashCode();
                if (this.hashValues[14] == null || hashCode != this.hashValues[14]) {
                    this.m_changeFlags.setParameter(14L, true);
                }
                this.hashValues[14] = this.m_limit != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[14] != null) {
                this.m_changeFlags.setParameter(14L, true);
                this.hashValues[14] = null;
            }
        }
        if (!changeFlags[15]) {
            if (this.m_dInstanceList != null) {
                hashCode = this.m_dInstanceList.hashCode();
                if (this.hashValues[15] == null || hashCode != this.hashValues[15]) {
                    this.m_changeFlags.setParameter(15L, true);
                }
                this.hashValues[15] = this.m_dInstanceList != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[15] != null) {
                this.m_changeFlags.setParameter(15L, true);
                this.hashValues[15] = null;
            }
        }
        if (!changeFlags[18]) {
            if (this.m_objPropList != null) {
                hashCode = this.m_objPropList.hashCode();
                if (this.hashValues[18] == null || hashCode != this.hashValues[18]) {
                    this.m_changeFlags.setParameter(18L, true);
                }
                this.hashValues[18] = this.m_objPropList != null ? Integer.valueOf(hashCode) : null;
            } else if (this.hashValues[18] != null) {
                this.m_changeFlags.setParameter(18L, true);
                this.hashValues[18] = null;
            }
        }
    }

    public static boolean isGroupList(int fieldId) {
        return fieldId == 104;
    }

    public static boolean isRowLevelAccessField(int fieldId) {
        return fieldId == 112;
    }

    public static boolean isRoleStateMappingField(int fieldId) {
        return (long)fieldId >= 2000L && (long)fieldId <= 2199L;
    }

    public static boolean isMultiAssignField(int fieldId) {
        return Field.isRowLevelAccessField(fieldId) || (long)fieldId >= 60000L && (long)fieldId <= 60999L;
    }

    public static boolean isGroupField(int fieldId) {
        return Field.isGroupList(fieldId) || Field.isMultiAssignField(fieldId) || Field.isRoleStateMappingField(fieldId);
    }

    public boolean isGroupList() {
        return Field.isGroupField(this.getFieldID());
    }

    public boolean isRowLevelAccessField() {
        return Field.isRowLevelAccessField(this.getFieldID());
    }

    public boolean isRoleStateMappingField() {
        return Field.isRoleStateMappingField(this.getFieldID());
    }

    public boolean isMultiAssignField() {
        return Field.isMultiAssignField(this.getFieldID());
    }

    public boolean isGroupField() {
        return Field.isGroupField(this.getFieldID());
    }

    public List<PermissionInfo> getAssignedGroup() {
        return this.m_AssignedGroup;
    }

    void setAssignedGroup(List<PermissionInfo> list) {
        this.m_AssignedGroup = list;
    }
}

