/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.codec.binary.Hex;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public class ByteListValue
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6911321982391669456L;
    private byte[] m_bytes;
    private int m_type;

    protected ByteListValue() {
    }

    public ByteListValue(int nType, byte[] byteArray) {
        this.m_type = nType;
        this.m_bytes = byteArray;
    }

    public Object clone() throws CloneNotSupportedException {
        ByteListValue obj = (ByteListValue)super.clone();
        if (this.m_bytes != null) {
            obj.m_bytes = (byte[])this.m_bytes.clone();
        }
        return obj;
    }

    public int getType() {
        return this.m_type;
    }

    public byte[] getValue() {
        return this.m_bytes;
    }

    public void setType(int nType) {
        this.m_type = nType;
    }

    public void setValue(byte[] val) {
        this.m_bytes = val;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.setType(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0)));
        if (ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 1)) > 0) {
            this.setValue((byte[])ARTypeMgr.GetAt((Object)rawData, 2));
        }
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{new Integer(this.getType()), new Integer(this.getValue() != null ? this.getValue().length : 0), this.getValue()};
        return var;
    }

    static ByteListValue createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        ByteListValue obj = new ByteListValue();
        if (rawData.length == 3) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteListValue)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ByteListValue rhs = (ByteListValue)obj;
        return new EqualsBuilder().append(this.m_type, rhs.m_type).append(this.m_bytes, rhs.m_bytes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_type).append(this.m_bytes).toHashCode();
    }

    private static String byteArrayToHexString(byte[] in, int start, int end) {
        byte[] buf;
        if (in == null) {
            return null;
        }
        int len = in.length;
        if (len <= 0 || len < start) {
            return null;
        }
        if (end < start || end > len) {
            end = len;
        }
        if (in != null && (start != 0 || end != len)) {
            buf = new byte[end - start];
            System.arraycopy(in, start, buf, 0, end - start);
        } else {
            buf = in;
        }
        StringBuffer out = new StringBuffer((end - start + 1) * 2);
        if (start > 0) {
            out.append("...");
        }
        out.append(Hex.encodeHex(buf));
        if (end < len) {
            out.append("...");
        }
        String rslt = new String(out);
        return rslt;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("type", this.m_type).append("bytes", ByteListValue.byteArrayToHexString(this.m_bytes, 0, 64)).toString();
    }

    static ByteListValue deserializeFromObjectStr(String valueStrToExtract) {
        int ib1 = valueStrToExtract.indexOf(";");
        byte[] bytes = null;
        int type = 0;
        String subLineB1 = null;
        if (ib1 < valueStrToExtract.length()) {
            type = new Integer(valueStrToExtract.substring(0, ib1));
            subLineB1 = valueStrToExtract.substring(ib1 + 1);
            int ib2 = subLineB1.indexOf(";");
            if (ib2 < subLineB1.length() && ib2 + 1 < subLineB1.length()) {
                bytes = subLineB1.substring(ib2 + 1).getBytes();
            }
        }
        ByteListValue bInfo = new ByteListValue(type, bytes);
        return bInfo;
    }
}

