/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public class ArithmeticOperationInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8565634548350997817L;
    private int m_operation;
    private ArithmeticOrRelationalOperand m_operandLeft;
    private ArithmeticOrRelationalOperand m_operandRight;
    public static final int AR_ARITH_OP_ADD = 1;
    public static final int AR_ARITH_OP_SUBTRACT = 2;
    public static final int AR_ARITH_OP_MULTIPLY = 3;
    public static final int AR_ARITH_OP_DIVIDE = 4;
    public static final int AR_ARITH_OP_MODULO = 5;
    public static final int AR_ARITH_OP_NEGATE = 6;

    public ArithmeticOperationInfo() {
        this.m_operation = 0;
        this.m_operandLeft = null;
        this.m_operandRight = null;
    }

    public ArithmeticOperationInfo(int operation, ArithmeticOrRelationalOperand op1, ArithmeticOrRelationalOperand op2) throws IllegalArgumentException {
        if (!this.validate(operation)) {
            throw new IllegalArgumentException("invalid operation in ArithmeticOperationInfo constructor");
        }
        this.m_operation = operation;
        this.m_operandLeft = op1;
        this.m_operandRight = op2;
    }

    public ArithmeticOrRelationalOperand getLeftOperand() {
        return this.m_operandLeft;
    }

    public ArithmeticOrRelationalOperand getRightOperand() {
        return this.m_operandRight;
    }

    public int getOperation() {
        return this.m_operation;
    }

    private boolean validate(int operation) {
        return operation >= 1 && operation <= 6;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOperationInfo obj = (ArithmeticOperationInfo)super.clone();
        if (this.m_operandLeft != null) {
            obj.m_operandLeft = (ArithmeticOrRelationalOperand)this.m_operandLeft.clone();
        }
        if (this.m_operandRight != null) {
            obj.m_operandRight = (ArithmeticOrRelationalOperand)this.m_operandRight.clone();
        }
        return obj;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArithmeticOperationInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ArithmeticOperationInfo rhs = (ArithmeticOperationInfo)obj;
        return new EqualsBuilder().append(this.m_operation, rhs.m_operation).append(this.m_operandLeft, rhs.m_operandLeft).append(this.m_operandRight, rhs.m_operandRight).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_operation).append(this.m_operandLeft).append(this.m_operandRight).toHashCode();
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.m_operation = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)rawData, 0));
        if (this.m_operation != 6) {
            this.m_operandLeft = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOrRelationalOperand.class, ARTypeMgr.GetAt((Object)rawData, 1), ctx);
        }
        this.m_operandRight = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOrRelationalOperand.class, ARTypeMgr.GetAt((Object)rawData, 2), ctx);
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{this.getOperation(), ARTypeMgr.getInstance().ObjectToVariant(this.m_operandLeft, ctx), ARTypeMgr.getInstance().ObjectToVariant(this.m_operandRight, ctx)};
        return var;
    }

    static ArithmeticOperationInfo createInstance(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return null;
        }
        ArithmeticOperationInfo obj = new ArithmeticOperationInfo();
        if (rawData.length == 3) {
            obj.fromVariant(rawData, ctx);
        }
        return obj;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Operation", this.m_operation).append("Operand Left", this.m_operandLeft).append("Operand Right", this.m_operandRight).toString();
    }

    public void setOperandLeft(ArithmeticOrRelationalOperand left) {
        this.m_operandLeft = left;
    }

    public void setOperandRight(ArithmeticOrRelationalOperand right) {
        this.m_operandRight = right;
    }

    public void setOperation(int m_operation) {
        this.m_operation = m_operation;
    }
}

