/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.interceptor;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.AopProxyUtils;
import java.io.Serializable;

public abstract class AbstractTraceInterceptor
implements MethodInterceptor,
Serializable {
    protected transient Log defaultLogger = LogFactory.getLog(this.getClass());
    private boolean hideProxyClassNames = false;

    public void setUseDynamicLogger(boolean useDynamicLogger) {
        this.defaultLogger = useDynamicLogger ? null : LogFactory.getLog(this.getClass());
    }

    public void setLoggerName(String loggerName) {
        this.defaultLogger = LogFactory.getLog(loggerName);
    }

    public void setHideProxyClassNames(boolean hideProxyClassNames) {
        this.hideProxyClassNames = hideProxyClassNames;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Log logger = this.getLoggerForInvocation(invocation);
        if (this.isInterceptorEnabled(invocation, logger)) {
            return this.invokeUnderTrace(invocation, logger);
        }
        return invocation.proceed();
    }

    protected Log getLoggerForInvocation(MethodInvocation invocation) {
        if (this.defaultLogger != null) {
            return this.defaultLogger;
        }
        Object target = invocation.getThis();
        Class logCategoryClass = target.getClass();
        if (this.hideProxyClassNames) {
            logCategoryClass = AopProxyUtils.getTargetClass(target);
        }
        return LogFactory.getLog(logCategoryClass);
    }

    protected boolean isInterceptorEnabled(MethodInvocation invocation, Log logger) {
        return this.isLogEnabled(logger);
    }

    protected boolean isLogEnabled(Log logger) {
        return logger.isTraceEnabled();
    }

    protected abstract Object invokeUnderTrace(MethodInvocation var1, Log var2) throws Throwable;
}

