/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.multipart.commons;

import com.bmc.thirdparty.org.apache.commons.fileupload.FileItemFactory;
import com.bmc.thirdparty.org.apache.commons.fileupload.FileUpload;
import com.bmc.thirdparty.org.apache.commons.fileupload.FileUploadBase;
import com.bmc.thirdparty.org.apache.commons.fileupload.FileUploadException;
import com.bmc.thirdparty.org.apache.commons.fileupload.RequestContext;
import com.bmc.thirdparty.org.apache.commons.fileupload.servlet.ServletFileUpload;
import com.bmc.thirdparty.org.apache.commons.fileupload.servlet.ServletRequestContext;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import com.bmc.thirdparty.org.springframework.web.multipart.MaxUploadSizeExceededException;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartException;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartHttpServletRequest;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartResolver;
import com.bmc.thirdparty.org.springframework.web.multipart.commons.CommonsFileUploadSupport;
import com.bmc.thirdparty.org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import com.bmc.thirdparty.org.springframework.web.util.WebUtils;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class CommonsMultipartResolver
extends CommonsFileUploadSupport
implements MultipartResolver,
ServletContextAware {
    public CommonsMultipartResolver() {
    }

    public CommonsMultipartResolver(ServletContext servletContext) {
        this();
        this.setServletContext(servletContext);
    }

    protected FileUpload newFileUpload(FileItemFactory fileItemFactory) {
        return new ServletFileUpload(fileItemFactory);
    }

    public void setServletContext(ServletContext servletContext) {
        if (!this.isUploadTempDirSpecified()) {
            this.getFileItemFactory().setRepository(WebUtils.getTempDir(servletContext));
        }
    }

    public boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((RequestContext)new ServletRequestContext(request));
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        String encoding = this.determineEncoding(request);
        FileUpload fileUpload = this.prepareFileUpload(encoding);
        try {
            List fileItems = ((ServletFileUpload)fileUpload).parseRequest(request);
            CommonsFileUploadSupport.MultipartParsingResult parsingResult = this.parseFileItems(fileItems, encoding);
            return new DefaultMultipartHttpServletRequest(request, parsingResult.getMultipartFiles(), parsingResult.getMultipartParameters());
        }
        catch (FileUploadBase.SizeLimitExceededException ex) {
            throw new MaxUploadSizeExceededException(fileUpload.getSizeMax(), (Throwable)ex);
        }
        catch (FileUploadException ex) {
            throw new MultipartException("Could not parse multipart servlet request", ex);
        }
    }

    protected String determineEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        this.cleanupFileItems(request.getFileMap().values());
    }
}

