/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.filter;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeanWrapper;
import com.bmc.thirdparty.org.springframework.beans.BeanWrapperImpl;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.PropertyValue;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanInitializationException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanNameAware;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.core.io.ResourceEditor;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import com.bmc.thirdparty.org.springframework.web.context.support.ServletContextResourceLoader;
import com.bmc.thirdparty.org.springframework.web.util.NestedServletException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public abstract class GenericFilterBean
implements Filter,
BeanNameAware,
ServletContextAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set requiredProperties = new HashSet();
    private FilterConfig filterConfig;
    private String beanName;
    private ServletContext servletContext;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public final void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws ServletException {
        this.initFilterBean();
    }

    protected final void addRequiredProperty(String property) {
        this.requiredProperties.add(property);
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        Assert.notNull(filterConfig, "FilterConfig must not be null");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing filter '" + filterConfig.getFilterName() + "'");
        }
        this.filterConfig = filterConfig;
        try {
            FilterConfigPropertyValues pvs = new FilterConfigPropertyValues(filterConfig, this.requiredProperties);
            BeanWrapperImpl bw = new BeanWrapperImpl(this);
            ServletContextResourceLoader resourceLoader = new ServletContextResourceLoader(filterConfig.getServletContext());
            bw.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = GenericFilterBean.class$("com.bmc.thirdparty.org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, new ResourceEditor(resourceLoader));
            this.initBeanWrapper(bw);
            bw.setPropertyValues(pvs, true);
        }
        catch (BeansException ex) {
            String msg = "Failed to set bean properties on filter '" + filterConfig.getFilterName() + "': " + ex.getMessage();
            this.logger.error(msg, ex);
            throw new NestedServletException(msg, ex);
        }
        this.initFilterBean();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Filter '" + filterConfig.getFilterName() + "' configured successfully");
        }
    }

    public final void setFilterConfig(FilterConfig filterConfig) {
        try {
            this.init(filterConfig);
        }
        catch (ServletException ex) {
            throw new BeanInitializationException("Couldn't initialize filter bean", ex);
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    public final FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected final String getFilterName() {
        return this.filterConfig != null ? this.filterConfig.getFilterName() : this.beanName;
    }

    protected final ServletContext getServletContext() {
        return this.filterConfig != null ? this.filterConfig.getServletContext() : this.servletContext;
    }

    protected void initFilterBean() throws ServletException {
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FilterConfigPropertyValues
    extends MutablePropertyValues {
        public FilterConfigPropertyValues(FilterConfig config, Set requiredProperties) throws ServletException {
            HashSet missingProps = requiredProperties != null && !requiredProperties.isEmpty() ? new HashSet(requiredProperties) : null;
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                String value = config.getInitParameter(property);
                this.addPropertyValue(new PropertyValue(property, value));
                if (missingProps == null) continue;
                missingProps.remove(property);
            }
            if (missingProps != null && missingProps.size() > 0) {
                throw new ServletException("Initialization from FilterConfig for filter '" + config.getFilterName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, ", "));
            }
        }
    }
}

