/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class CollectionFactory {
    private static final String COMMONS_COLLECTIONS_CLASS_NAME = "org.apache.commons.collections.map.LinkedMap";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$core$CollectionFactory == null ? (class$org$springframework$core$CollectionFactory = CollectionFactory.class$("org.springframework.core.CollectionFactory")) : class$org$springframework$core$CollectionFactory));
    private static boolean commonsCollections3xAvailable;
    static /* synthetic */ Class class$org$springframework$core$CollectionFactory;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$SortedMap;

    public static Set createLinkedSetIfPossible(int initialCapacity) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.debug((Object)"Creating [java.util.LinkedHashSet]");
            return Jdk14CollectionFactory.createLinkedHashSet(initialCapacity);
        }
        if (commonsCollections3xAvailable) {
            logger.debug((Object)"Creating [org.apache.commons.collections.set.ListOrderedSet]");
            return CommonsCollectionFactory.createListOrderedSet(initialCapacity);
        }
        logger.debug((Object)"Falling back to [java.util.HashSet] for linked set");
        return new HashSet(initialCapacity);
    }

    public static Map createLinkedMapIfPossible(int initialCapacity) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.debug((Object)"Creating [java.util.LinkedHashMap]");
            return Jdk14CollectionFactory.createLinkedHashMap(initialCapacity);
        }
        if (commonsCollections3xAvailable) {
            logger.debug((Object)"Creating [org.apache.commons.collections.map.LinkedMap]");
            return CommonsCollectionFactory.createLinkedMap(initialCapacity);
        }
        logger.debug((Object)"Falling back to [java.util.HashMap] for linked map");
        return new HashMap(initialCapacity);
    }

    public static Map createLinkedCaseInsensitiveMapIfPossible(int initialCapacity) {
        if (commonsCollections3xAvailable) {
            logger.debug((Object)"Creating [org.apache.commons.collections.map.ListOrderedMap/CaseInsensitiveMap]");
            return CommonsCollectionFactory.createListOrderedCaseInsensitiveMap(initialCapacity);
        }
        if (JdkVersion.isAtLeastJava14()) {
            logger.debug((Object)"Falling back to [java.util.LinkedHashMap] for linked case-insensitive map");
            return Jdk14CollectionFactory.createLinkedHashMap(initialCapacity);
        }
        logger.debug((Object)"Falling back to [java.util.HashMap] for linked case-insensitive map");
        return new HashMap(initialCapacity);
    }

    public static Map createIdentityMapIfPossible(int initialCapacity) {
        if (JdkVersion.isAtLeastJava14()) {
            logger.debug((Object)"Creating [java.util.IdentityHashMap]");
            return Jdk14CollectionFactory.createIdentityHashMap(initialCapacity);
        }
        if (commonsCollections3xAvailable) {
            logger.debug((Object)"Creating [org.apache.commons.collections.map.IdentityMap]");
            return CommonsCollectionFactory.createIdentityMap(initialCapacity);
        }
        logger.debug((Object)"Falling back to [java.util.HashMap] for identity map");
        return new HashMap(initialCapacity);
    }

    public static Collection createApproximateCollection(Class collectionClass, int initialCapacity) {
        Assert.notNull(collectionClass, "Collection class must not be null");
        if ((class$java$util$List == null ? (class$java$util$List = CollectionFactory.class$("java.util.List")) : class$java$util$List).isAssignableFrom(collectionClass)) {
            return new ArrayList(initialCapacity);
        }
        if ((class$java$util$SortedSet == null ? (class$java$util$SortedSet = CollectionFactory.class$("java.util.SortedSet")) : class$java$util$SortedSet).isAssignableFrom(collectionClass)) {
            return new TreeSet();
        }
        return CollectionFactory.createLinkedSetIfPossible(initialCapacity);
    }

    public static Map createApproximateMap(Class mapClass, int initialCapacity) {
        Assert.notNull(mapClass, "Map class must not be null");
        if ((class$java$util$SortedMap == null ? (class$java$util$SortedMap = CollectionFactory.class$("java.util.SortedMap")) : class$java$util$SortedMap).isAssignableFrom(mapClass)) {
            return new TreeMap();
        }
        return CollectionFactory.createLinkedMapIfPossible(initialCapacity);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (JdkVersion.isAtLeastJava14()) {
            logger.info((Object)"JDK 1.4+ collections available");
        }
        if (ClassUtils.isPresent(COMMONS_COLLECTIONS_CLASS_NAME)) {
            commonsCollections3xAvailable = true;
            logger.info((Object)"Commons Collections 3.x available");
        } else {
            commonsCollections3xAvailable = false;
        }
    }

    private static abstract class CommonsCollectionFactory {
        private CommonsCollectionFactory() {
        }

        private static Set createListOrderedSet(int initialCapacity) {
            return ListOrderedSet.decorate(new HashSet(initialCapacity));
        }

        private static Map createLinkedMap(int initialCapacity) {
            return new LinkedMap(initialCapacity == 0 ? 1 : initialCapacity);
        }

        private static Map createListOrderedCaseInsensitiveMap(int initialCapacity) {
            return ListOrderedMap.decorate((Map)new CaseInsensitiveMap(initialCapacity == 0 ? 1 : initialCapacity));
        }

        private static Map createIdentityMap(int initialCapacity) {
            return new IdentityMap(initialCapacity == 0 ? 1 : initialCapacity);
        }
    }

    private static abstract class Jdk14CollectionFactory {
        private Jdk14CollectionFactory() {
        }

        private static Set createLinkedHashSet(int initialCapacity) {
            return new LinkedHashSet(initialCapacity);
        }

        private static Map createLinkedHashMap(int initialCapacity) {
            return new LinkedHashMap(initialCapacity);
        }

        private static Map createIdentityHashMap(int initialCapacity) {
            return new IdentityHashMap(initialCapacity);
        }
    }
}

