/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrBufferDecodingStream
extends XdrDecodingStream {
    private byte[] buffer;
    private int encodedLength;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrBufferDecodingStream(byte[] byArray, int n2) {
        this.setXdrData(byArray, n2);
    }

    public XdrBufferDecodingStream(byte[] byArray) {
        this.setXdrData(byArray, byArray.length);
    }

    public void setXdrData(byte[] byArray, int n2) {
        if (n2 < 0 || (n2 & 3) != 0) {
            throw new IllegalArgumentException("length of encoded data must be a multiple of four and must not be negative");
        }
        this.buffer = byArray;
        this.encodedLength = n2;
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    @Override
    public InetAddress getSenderAddress() {
        return null;
    }

    @Override
    public int getSenderPort() {
        return 0;
    }

    @Override
    public void beginDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = this.encodedLength - 4;
    }

    @Override
    public void endDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
    }

    @Override
    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.bufferIndex <= this.bufferHighmark) {
            int n2 = this.buffer[this.bufferIndex++];
            n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            return n2;
        }
        throw new OncRpcException(43);
    }

    @Override
    public byte[] xdrDecodeOpaque(int n2) throws OncRpcException, IOException {
        int n3 = n2;
        if ((n3 & 3) != 0) {
            n3 = (n3 & 0xFFFFFFFC) + 4;
        }
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            if (this.bufferIndex <= this.bufferHighmark - n3 + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += n3;
        return byArray;
    }

    @Override
    public void xdrDecodeOpaque(byte[] byArray, int n2, int n3) throws OncRpcException, IOException {
        int n4 = n3;
        if ((n4 & 3) != 0) {
            n4 = (n4 & 0xFFFFFFFC) + 4;
        }
        if (n3 > 0) {
            if (this.bufferIndex <= this.bufferHighmark - n4 + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n2, n3);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += n4;
    }
}

