/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.bind;

import com.bmc.thirdparty.org.springframework.web.HttpRequestMethodNotSupportedException;
import com.bmc.thirdparty.org.springframework.web.bind.ServletRequestBindingException;
import com.bmc.thirdparty.org.springframework.web.bind.ServletRequestUtils;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class RequestUtils {
    public static void rejectRequestMethod(HttpServletRequest request, String method) throws ServletException {
        if (request.getMethod().equals(method)) {
            throw new HttpRequestMethodNotSupportedException(method);
        }
    }

    public static Integer getIntParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return new Integer(RequestUtils.getRequiredIntParameter(request, name));
    }

    public static int getIntParameter(HttpServletRequest request, String name, int defaultVal) {
        try {
            return RequestUtils.getRequiredIntParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static int[] getIntParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredIntParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredIntParameter((ServletRequest)request, name);
    }

    public static int[] getRequiredIntParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredIntParameters((ServletRequest)request, name);
    }

    public static Long getLongParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return new Long(RequestUtils.getRequiredLongParameter(request, name));
    }

    public static long getLongParameter(HttpServletRequest request, String name, long defaultVal) {
        try {
            return RequestUtils.getRequiredLongParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static long[] getLongParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredLongParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new long[0];
        }
    }

    public static long getRequiredLongParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredLongParameter((ServletRequest)request, name);
    }

    public static long[] getRequiredLongParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredLongParameters((ServletRequest)request, name);
    }

    public static Float getFloatParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return new Float(RequestUtils.getRequiredFloatParameter(request, name));
    }

    public static float getFloatParameter(HttpServletRequest request, String name, float defaultVal) {
        try {
            return RequestUtils.getRequiredFloatParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static float[] getFloatParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredFloatParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredFloatParameter((ServletRequest)request, name);
    }

    public static float[] getRequiredFloatParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredFloatParameters((ServletRequest)request, name);
    }

    public static Double getDoubleParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return new Double(RequestUtils.getRequiredDoubleParameter(request, name));
    }

    public static double getDoubleParameter(HttpServletRequest request, String name, double defaultVal) {
        try {
            return RequestUtils.getRequiredDoubleParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static double[] getDoubleParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredDoubleParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredDoubleParameter((ServletRequest)request, name);
    }

    public static double[] getRequiredDoubleParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return ServletRequestUtils.getRequiredDoubleParameters((ServletRequest)request, name);
    }

    public static Boolean getBooleanParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return RequestUtils.getRequiredBooleanParameter(request, name) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean getBooleanParameter(HttpServletRequest request, String name, boolean defaultVal) {
        try {
            return RequestUtils.getRequiredBooleanParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static boolean[] getBooleanParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredBooleanParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        boolean value = ServletRequestUtils.getRequiredBooleanParameter((ServletRequest)request, name);
        if (!value && "".equals(request.getParameter(name))) {
            throw new ServletRequestBindingException("Required boolean parameter '" + name + "' contains no value");
        }
        return value;
    }

    public static boolean[] getRequiredBooleanParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        boolean[] values = ServletRequestUtils.getRequiredBooleanParameters((ServletRequest)request, name);
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (values[i2] || !"".equals(request.getParameterValues(name)[i2])) continue;
            throw new ServletRequestBindingException("Required boolean parameter '" + name + "' contains no value");
        }
        return values;
    }

    public static String getStringParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        if (request.getParameter(name) == null) {
            return null;
        }
        return RequestUtils.getRequiredStringParameter(request, name);
    }

    public static String getStringParameter(HttpServletRequest request, String name, String defaultVal) {
        try {
            return RequestUtils.getRequiredStringParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static String[] getStringParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredStringParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        String value = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request, name);
        if ("".equals(value)) {
            throw new ServletRequestBindingException("Required string parameter '" + name + "' contains no value");
        }
        return value;
    }

    public static String[] getRequiredStringParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        String[] values = ServletRequestUtils.getRequiredStringParameters((ServletRequest)request, name);
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (!"".equals(values[i2])) continue;
            throw new ServletRequestBindingException("Required string parameter '" + name + "' contains no value");
        }
        return values;
    }
}

