/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa.support;

import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerFactoryAccessor;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerFactoryInfo;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerPlus;
import com.bmc.thirdparty.org.springframework.orm.jpa.JpaDialect;
import com.bmc.thirdparty.org.springframework.orm.jpa.SharedEntityManagerCreator;
import com.bmc.thirdparty.org.springframework.util.Assert;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public class SharedEntityManagerBean
extends EntityManagerFactoryAccessor
implements FactoryBean,
InitializingBean {
    private Class entityManagerInterface;
    private EntityManager shared;

    public void setEntityManagerInterface(Class entityManagerInterface) {
        Assert.notNull(entityManagerInterface, "entityManagerInterface must not be null");
        Assert.isAssignable(EntityManager.class, entityManagerInterface);
        this.entityManagerInterface = entityManagerInterface;
    }

    public final void afterPropertiesSet() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf == null) {
            throw new IllegalArgumentException("entityManagerFactory is required");
        }
        Class[] ifcs = null;
        if (emf instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = emfInfo.getEntityManagerInterface();
            }
            ifcs = (jpaDialect = emfInfo.getJpaDialect()) != null && jpaDialect.supportsEntityManagerPlusOperations() ? new Class[]{this.entityManagerInterface, EntityManagerPlus.class} : new Class[]{this.entityManagerInterface};
        } else {
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = EntityManager.class;
            }
            ifcs = new Class[]{this.entityManagerInterface};
        }
        this.shared = SharedEntityManagerCreator.createSharedEntityManager(emf, this.getJpaPropertyMap(), ifcs);
    }

    public EntityManager getObject() {
        return this.shared;
    }

    public Class getObjectType() {
        return this.entityManagerInterface;
    }

    public boolean isSingleton() {
        return true;
    }
}

