/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArClientRequestHandler;
import com.bmc.arsys.arrpc.nio.ArRpcCallHandler;
import com.bmc.arsys.arrpc.nio.ArSelectorThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ArTcpServerTransportBase {
    private static Logger case = Logger.getLogger(ArTcpServerTransportBase.class);
    private final ServerSocketChannel char = ServerSocketChannel.open();
    private final Selector do;
    private int try = 0;
    protected ArClientConnectionAcceptor acceptor;
    private boolean byte;
    private OncRpcDispatchable int;
    private int new;
    private OncRpcServerTransportRegistrationInfo[] if;
    private int for;
    ArSelectorThread[] callSelectors;
    protected int transmissionTimeout = 90000;
    private String a;

    public ArTcpServerTransportBase(InetAddress inetAddress, int n2) throws IOException {
        this.char.socket().bind(new InetSocketAddress(n2));
        this.char.configureBlocking(false);
        this.do = Selector.open();
        SelectionKey selectionKey = this.char.register(this.do, 16);
        this.acceptor = this.createAcceptor();
        selectionKey.attach(this.acceptor);
        this.initCallSelector();
    }

    protected ArClientConnectionAcceptor createAcceptor() {
        return new ArClientConnectionAcceptor();
    }

    protected abstract void initCallSelector() throws IOException;

    public ArTcpServerTransportBase(OncRpcDispatchable oncRpcDispatchable, InetAddress inetAddress, int n2, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n3, boolean bl) throws OncRpcException, IOException {
        this(inetAddress, n2);
        String string = "";
        if (n2 == 0) {
            this.for = this.char.socket().getLocalPort();
            string = " on localPort " + this.for;
        } else {
            this.for = n2;
            string = " on assigned port " + String.valueOf(n2);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("ServerSocketChannel opened TCP for " + inetAddress + string);
        }
        case.debug("ServerSocketChannel opened TCP for " + inetAddress + string);
        this.int = oncRpcDispatchable;
        if (n3 < 1024) {
            n3 = 1024;
        }
        this.new = n3;
        this.if = oncRpcServerTransportRegistrationInfoArray;
        this.byte = bl;
    }

    public void register() throws OncRpcException {
        if (this.byte) {
            try {
                OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getLocalHost());
                int n2 = this.if.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    oncRpcPortmapClient.setPort(this.if[i2].program, this.if[i2].version, 6, this.for);
                }
            }
            catch (Throwable throwable) {
                throw new OncRpcException(16);
            }
        }
    }

    public void registerByName(String string, boolean bl) throws OncRpcException {
        if (bl) {
            try {
                OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getByName(string));
                int n2 = ArRpcBindHelper.getPluginSvrMinVersionToRegisger(InetAddress.getByName(string));
                int n3 = this.if.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.if[i2].version < n2) continue;
                    oncRpcPortmapClient.setPort(this.if[i2].program, this.if[i2].version, 6, this.for);
                }
            }
            catch (Throwable throwable) {
                throw new OncRpcException(16);
            }
        }
    }

    public void unregister() throws OncRpcException {
        if (this.byte) {
            try {
                OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getLocalHost());
                int n2 = this.if.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    oncRpcPortmapClient.unsetPort(this.if[i2].program, this.if[i2].version);
                }
            }
            catch (Throwable throwable) {
                throw new OncRpcException(16);
            }
        }
    }

    public void unregisterByName(String string) throws OncRpcException {
        if (this.byte) {
            try {
                OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getByName(string));
                int n2 = ArRpcBindHelper.getPluginSvrMinVersionToRegisger(InetAddress.getByName(string));
                int n3 = this.if.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.if[i2].version < n2) continue;
                    oncRpcPortmapClient.unsetPort(this.if[i2].program, this.if[i2].version);
                }
            }
            catch (Throwable throwable) {
                throw new OncRpcException(16);
            }
        }
    }

    public void setTransmissionTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = n2;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    public void setCharacterEncoding(String string) {
        this.a = string;
    }

    public String getCharacterEncoding() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            case.debug("Starting Reactor thread thats listening for client connections " + Thread.currentThread().getId());
            Selector selector = this.do;
            while (!Thread.interrupted()) {
                Set<SelectionKey> set;
                selector.select();
                case.trace("******************************selector selected");
                Set<SelectionKey> set2 = set = selector.selectedKeys();
                synchronized (set2) {
                    Iterator<SelectionKey> iterator = set.iterator();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        case.trace("******************************Selector " + selectionKey.selector().hashCode() + " SelectionKey " + selectionKey.hashCode());
                        if (!selectionKey.isValid() || !selectionKey.isAcceptable() || arrayList.contains(selectionKey.attachment())) continue;
                        arrayList.add(selectionKey.attachment());
                        case.trace("******************************Selector " + selectionKey.selector().hashCode() + " SelectionKey " + selectionKey.hashCode() + " contains a package");
                        this.a(selectionKey);
                    }
                    arrayList.clear();
                    set.clear();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            case.error("Exception in reactor thread.", throwable);
            return;
        }
        finally {
            this.cleanUp();
        }
    }

    private void a(SelectionKey selectionKey) {
        ArClientRequestHandler arClientRequestHandler = (ArClientRequestHandler)selectionKey.attachment();
        case.debug("dispatch SelectionKey " + selectionKey.hashCode() + " to attached connection acceptor: " + (arClientRequestHandler == null ? null : Integer.valueOf(arClientRequestHandler.hashCode())));
        if (arClientRequestHandler != null) {
            arClientRequestHandler.handleRequest(selectionKey);
        }
    }

    public void cleanUp() {
        if (this.char != null) {
            try {
                this.do.close();
                this.acceptor.close();
                this.char.socket().close();
                this.char.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finalize() throws Throwable {
        this.cleanUp();
        super.finalize();
    }

    protected ArSelectorThread[] getCallSelectors() {
        return this.callSelectors;
    }

    protected void setCallSelectors(ArSelectorThread[] arSelectorThreadArray) {
        this.callSelectors = arSelectorThreadArray;
    }

    protected void setCallSelector(int n2, ArSelectorThread arSelectorThread) {
        if (this.callSelectors != null) {
            this.callSelectors[n2] = arSelectorThread;
        }
    }

    protected OncRpcDispatchable getCallDispatcher() {
        return this.int;
    }

    protected int getSocketBufferSize() {
        return this.new;
    }

    public void unregister(String string) {
    }

    public boolean isRegPortMapper() {
        return this.byte;
    }

    protected class ArClientConnectionAcceptor
    implements ArClientRequestHandler {
        protected ArClientConnectionAcceptor() {
        }

        synchronized ArSelectorThread getNextSelector() {
            if (ArTcpServerTransportBase.this.try == ArTcpServerTransportBase.this.callSelectors.length) {
                ArTcpServerTransportBase.this.try = 0;
            }
            ArSelectorThread arSelectorThread = ArTcpServerTransportBase.this.callSelectors[ArTcpServerTransportBase.this.try++];
            return arSelectorThread;
        }

        @Override
        public void handleRequest(SelectionKey selectionKey) {
            SocketChannel socketChannel = null;
            try {
                if (selectionKey.isValid() && selectionKey.isAcceptable() && (socketChannel = ArTcpServerTransportBase.this.char.accept()) != null) {
                    case.debug("Client connection accepted. Registering handler");
                    ArSelectorThread arSelectorThread = this.getNextSelector();
                    ArRpcCallHandler arRpcCallHandler = this.createHandler(arSelectorThread, socketChannel);
                    arSelectorThread.addHandler(arRpcCallHandler);
                }
            }
            catch (Throwable throwable) {
                case.error("Error accepting a connection or registering the handler for a connection", throwable);
                selectionKey.cancel();
                try {
                    selectionKey.channel().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (socketChannel != null) {
                        socketChannel.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public ArRpcCallHandler createHandler(ArSelectorThread arSelectorThread, SocketChannel socketChannel) throws IOException {
            throw new IOException("Method need to be overridden");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            int n2 = 0;
            ArSelectorThread[] arSelectorThreadArray = ArTcpServerTransportBase.this.callSelectors;
            synchronized (ArTcpServerTransportBase.this.callSelectors) {
                while (n2 < ArTcpServerTransportBase.this.callSelectors.length) {
                    ArTcpServerTransportBase.this.callSelectors[n2++].close();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

