/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.common.AppException;
import com.bmc.arsys.common.CommonErrors;

public class PropertyDefinition {
    private static final String TRUE_STRING = "T";
    private String propName;
    private Class propType;
    private Object defaultValue;

    public PropertyDefinition(String string, Class clazz, Object object) {
        this.propName = string;
        this.propType = clazz;
        this.defaultValue = object;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public Class getPropertyType() {
        return this.propType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.propName;
    }

    public Object getConvertedValue(String string) throws AppException {
        Object object = string;
        if (this.propType == null) {
            return object;
        }
        if (this.propType == Long.TYPE || this.propType == Long.class) {
            try {
                object = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "long"});
            }
        }
        if (this.propType == Boolean.TYPE || this.propType == Boolean.class) {
            object = TRUE_STRING.equalsIgnoreCase(string) ? Boolean.TRUE : Boolean.FALSE;
        } else if (this.propType == Integer.TYPE || this.propType == Integer.class) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "integer"});
            }
            object = n;
        } else if (this.propType == Float.TYPE || this.propType == Float.class) {
            float f;
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "float"});
            }
            object = Float.valueOf(f);
        } else if (this.propType == Double.TYPE || this.propType == Double.class) {
            double d;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.WRONG_DATA_TYPE.toIntValue(), CommonErrors.WRONG_DATA_TYPE.toDefMsg(), new Object[]{this.toString(), "double"});
            }
            object = d;
        }
        return object;
    }
}

