/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.target;

import com.bmc.thirdparty.org.springframework.aop.IntroductionAdvisor;
import com.bmc.thirdparty.org.springframework.aop.support.DefaultIntroductionAdvisor;
import com.bmc.thirdparty.org.springframework.aop.support.DelegatingIntroductionInterceptor;
import com.bmc.thirdparty.org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import com.bmc.thirdparty.org.springframework.aop.target.ThreadLocalTargetSourceStats;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ThreadLocalTargetSource
extends AbstractPrototypeBasedTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private final ThreadLocal targetInThread = new ThreadLocal();
    private final Set targetSet = Collections.synchronizedSet(new HashSet());
    private int invocationCount;
    private int hitCount;
    static /* synthetic */ Class class$org$springframework$aop$target$ThreadLocalTargetSourceStats;

    public Object getTarget() throws BeansException {
        ++this.invocationCount;
        Object target = this.targetInThread.get();
        if (target == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No target for prototype '" + this.getTargetBeanName() + "' bound to thread: " + "creating one and binding it to thread '" + Thread.currentThread().getName() + "'");
            }
            target = this.newPrototypeInstance();
            this.targetInThread.set(target);
            this.targetSet.add(target);
        } else {
            ++this.hitCount;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.info("Destroying ThreadLocalTargetSource bindings");
        Set set = this.targetSet;
        synchronized (set) {
            Iterator it = this.targetSet.iterator();
            while (it.hasNext()) {
                Object target = it.next();
                if (!(target instanceof DisposableBean)) continue;
                try {
                    ((DisposableBean)target).destroy();
                }
                catch (Exception ex) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Thread-bound target of class [" + target.getClass() + "] threw exception from destroy() method", ex);
                }
            }
            this.targetSet.clear();
        }
        this.targetInThread.set(null);
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getObjectCount() {
        return this.targetSet.size();
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, class$org$springframework$aop$target$ThreadLocalTargetSourceStats == null ? (class$org$springframework$aop$target$ThreadLocalTargetSourceStats = ThreadLocalTargetSource.class$("com.bmc.thirdparty.org.springframework.aop.target.ThreadLocalTargetSourceStats")) : class$org$springframework$aop$target$ThreadLocalTargetSourceStats);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

