/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.antlr.runtime.debug;

import com.bmc.thirdparty.org.antlr.runtime.RecognitionException;
import com.bmc.thirdparty.org.antlr.runtime.Token;
import com.bmc.thirdparty.org.antlr.runtime.debug.BlankDebugEventListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class DebugEventSocketProxy
extends BlankDebugEventListener {
    public static final int DEFAULT_DEBUGGER_PORT = 49153;
    protected int port = 49153;
    protected ServerSocket serverSocket;
    protected Socket socket;
    protected String grammarFileName;
    protected PrintWriter out;
    protected BufferedReader in;

    public DebugEventSocketProxy() {
        this(null, 49153);
    }

    public DebugEventSocketProxy(String string) {
        this(string, 49153);
    }

    public DebugEventSocketProxy(String string, int n2) {
        this.grammarFileName = string;
        this.port = n2;
    }

    public void handshake() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.port);
            this.socket = this.serverSocket.accept();
            this.socket.setTcpNoDelay(true);
            OutputStream outputStream = this.socket.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
            InputStream inputStream = this.socket.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            this.in = new BufferedReader(inputStreamReader);
            this.out.println("ANTLR 1");
            this.out.println("grammar \"" + this.grammarFileName);
            this.out.flush();
        }
    }

    public void commence() {
    }

    public void terminate() {
        this.transmit("terminate");
        this.out.close();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void ack() {
        try {
            this.in.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void transmit(String string) {
        this.out.println(string);
        this.out.flush();
        this.ack();
    }

    public void enterRule(String string) {
        this.transmit("enterRule " + string);
    }

    public void enterAlt(int n2) {
        this.transmit("enterAlt " + n2);
    }

    public void exitRule(String string) {
        this.transmit("exitRule " + string);
    }

    public void enterSubRule(int n2) {
        this.transmit("enterSubRule " + n2);
    }

    public void exitSubRule(int n2) {
        this.transmit("exitSubRule " + n2);
    }

    public void enterDecision(int n2) {
        this.transmit("enterDecision " + n2);
    }

    public void exitDecision(int n2) {
        this.transmit("exitDecision " + n2);
    }

    public void consumeToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeToken " + string);
    }

    public void consumeHiddenToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeHiddenToken " + string);
    }

    public void LT(int n2, Token token) {
        if (token != null) {
            this.transmit("LT " + n2 + " " + this.serializeToken(token));
        }
    }

    public void mark(int n2) {
        this.transmit("mark " + n2);
    }

    public void rewind(int n2) {
        this.transmit("rewind " + n2);
    }

    public void rewind() {
        this.transmit("rewind");
    }

    public void beginBacktrack(int n2) {
        this.transmit("beginBacktrack " + n2);
    }

    public void endBacktrack(int n2, boolean bl) {
        this.transmit("endBacktrack " + n2 + " " + (bl ? 1 : 0));
    }

    public void location(int n2, int n3) {
        this.transmit("location " + n2 + " " + n3);
    }

    public void recognitionException(RecognitionException recognitionException) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("exception ");
        stringBuffer.append(recognitionException.getClass().getName());
        stringBuffer.append(" ");
        stringBuffer.append(recognitionException.index);
        stringBuffer.append(" ");
        stringBuffer.append(recognitionException.line);
        stringBuffer.append(" ");
        stringBuffer.append(recognitionException.charPositionInLine);
        this.transmit(stringBuffer.toString());
    }

    public void beginResync() {
        this.transmit("beginResync");
    }

    public void endResync() {
        this.transmit("endResync");
    }

    public void semanticPredicate(boolean bl, String string) {
        string = this.escapeNewlines(string);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("semanticPredicate ");
        stringBuffer.append(bl);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        this.transmit(stringBuffer.toString());
    }

    public void consumeNode(int n2, String string, int n3) {
        string = this.escapeNewlines(string);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("consumeNode ");
        stringBuffer.append(n2);
        stringBuffer.append(" ");
        stringBuffer.append(n3);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        this.transmit(stringBuffer.toString());
    }

    public void LT(int n2, int n3, String string, int n4) {
        string = this.escapeNewlines(string);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("LN ");
        stringBuffer.append(n2);
        stringBuffer.append(" ");
        stringBuffer.append(n3);
        stringBuffer.append(" ");
        stringBuffer.append(n4);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        this.transmit(stringBuffer.toString());
    }

    public void nilNode(int n2) {
        this.transmit("nilNode " + n2);
    }

    public void createNode(int n2, String string, int n3) {
        string = this.escapeNewlines(string);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("createNodeFromToken ");
        stringBuffer.append(n2);
        stringBuffer.append(" ");
        stringBuffer.append(n3);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        this.transmit(stringBuffer.toString());
    }

    public void createNode(int n2, int n3) {
        this.transmit("createNode " + n2 + " " + n3);
    }

    public void becomeRoot(int n2, int n3) {
        this.transmit("becomeRoot " + n2 + " " + n3);
    }

    public void addChild(int n2, int n3) {
        this.transmit("addChild " + n2 + " " + n3);
    }

    public void setTokenBoundaries(int n2, int n3, int n4) {
        this.transmit("setTokenBoundaries " + n2 + " " + n3 + " " + n4);
    }

    protected String serializeToken(Token token) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(token.getTokenIndex());
        stringBuffer.append(' ');
        stringBuffer.append(token.getType());
        stringBuffer.append(' ');
        stringBuffer.append(token.getChannel());
        stringBuffer.append(' ');
        stringBuffer.append(token.getLine());
        stringBuffer.append(' ');
        stringBuffer.append(token.getCharPositionInLine());
        stringBuffer.append(" \"");
        String string = token.getText();
        if (string == null) {
            string = "";
        }
        string = this.escapeNewlines(string);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected String escapeNewlines(String string) {
        string = string.replaceAll("%", "%25");
        string = string.replaceAll("\n", "%0A");
        string = string.replaceAll("\r", "%0D");
        return string;
    }
}

