/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanPostProcessor;
import com.bmc.thirdparty.org.springframework.web.context.ServletConfigAware;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ServletContextAwareProcessor
implements BeanPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ServletContext servletContext;
    private ServletConfig servletConfig;

    public ServletContextAwareProcessor(ServletContext servletContext) {
        this(servletContext, null);
    }

    public ServletContextAwareProcessor(ServletConfig servletConfig) {
        this(null, servletConfig);
    }

    public ServletContextAwareProcessor(ServletContext servletContext, ServletConfig servletConfig) {
        this.servletContext = servletContext;
        this.servletConfig = servletConfig;
        if (servletContext == null && servletConfig != null) {
            this.servletContext = servletConfig.getServletContext();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ServletContextAware) {
            if (this.servletContext == null) {
                throw new IllegalStateException("Cannot satisfy ServletContextAware for bean '" + beanName + "' without ServletContext");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking setServletContext on ServletContextAware bean '" + beanName + "'");
            }
            ((ServletContextAware)bean).setServletContext(this.servletContext);
        }
        if (bean instanceof ServletConfigAware) {
            if (this.servletConfig == null) {
                throw new IllegalStateException("Cannot satisfy ServletConfigAware for bean '" + beanName + "' without ServletConfig");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invoking setServletConfig on ServletConfigAware bean '" + beanName + "'");
            }
            ((ServletConfigAware)bean).setServletConfig(this.servletConfig);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

