/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.core;

import com.bmc.thirdparty.org.springframework.core.CollectionFactory;
import com.bmc.thirdparty.org.springframework.jdbc.core.RowMapper;
import com.bmc.thirdparty.org.springframework.jdbc.support.JdbcUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class ColumnMapRowMapper
implements RowMapper {
    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Map mapOfColValues = this.createColumnMap(columnCount);
        for (int i2 = 1; i2 <= columnCount; ++i2) {
            String key = this.getColumnKey(rsmd.getColumnName(i2));
            Object obj = this.getColumnValue(rs, i2);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    protected Map createColumnMap(int columnCount) {
        return CollectionFactory.createLinkedCaseInsensitiveMapIfPossible(columnCount);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }
}

