/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jca.cci.connection;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.jca.cci.CannotGetCciConnectionException;
import com.bmc.thirdparty.org.springframework.jca.cci.connection.ConnectionHolder;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationAdapter;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import com.bmc.thirdparty.org.springframework.util.Assert;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;

public abstract class ConnectionFactoryUtils {
    private static final Log logger = LogFactory.getLog(class$org$springframework$jca$cci$connection$ConnectionFactoryUtils == null ? (class$org$springframework$jca$cci$connection$ConnectionFactoryUtils = ConnectionFactoryUtils.class$("com.bmc.thirdparty.org.springframework.jca.cci.connection.ConnectionFactoryUtils")) : class$org$springframework$jca$cci$connection$ConnectionFactoryUtils);
    static /* synthetic */ Class class$org$springframework$jca$cci$connection$ConnectionFactoryUtils;

    public static Connection getConnection(ConnectionFactory cf) throws CannotGetCciConnectionException {
        try {
            return ConnectionFactoryUtils.doGetConnection(cf);
        }
        catch (ResourceException ex) {
            throw new CannotGetCciConnectionException("Could not get CCI connection", ex);
        }
    }

    public static Connection doGetConnection(ConnectionFactory cf) throws ResourceException {
        Assert.notNull(cf, "No ConnectionFactory specified");
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(cf);
        if (conHolder != null) {
            return conHolder.getConnection();
        }
        logger.debug("Opening CCI Connection");
        Connection con = cf.getConnection();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug("Registering transaction synchronization for CCI Connection");
            conHolder = new ConnectionHolder(con);
            conHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization(new ConnectionSynchronization(conHolder, cf));
            TransactionSynchronizationManager.bindResource(cf, conHolder);
        }
        return con;
    }

    public static void releaseConnection(Connection con, ConnectionFactory cf) {
        try {
            ConnectionFactoryUtils.doReleaseConnection(con, cf);
        }
        catch (ResourceException ex) {
            logger.debug("Could not close CCI Connection", ex);
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing CCI Connection", ex);
        }
    }

    public static void doReleaseConnection(Connection con, ConnectionFactory cf) throws ResourceException {
        if (con == null || cf != null && TransactionSynchronizationManager.hasResource(cf)) {
            return;
        }
        con.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConnectionSynchronization
    extends TransactionSynchronizationAdapter {
        private final ConnectionHolder connectionHolder;
        private final ConnectionFactory connectionFactory;
        private boolean holderActive = true;

        public ConnectionSynchronization(ConnectionHolder connectionHolder, ConnectionFactory connectionFactory) {
            this.connectionHolder = connectionHolder;
            this.connectionFactory = connectionFactory;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.connectionFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.connectionFactory, this.connectionHolder);
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.connectionFactory);
            this.holderActive = false;
            ConnectionFactoryUtils.releaseConnection(this.connectionHolder.getConnection(), this.connectionFactory);
        }
    }
}

