/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;

public abstract class XdrEncodingStream {
    private String characterEncoding = null;

    public void beginEncoding(InetAddress inetAddress, int n) throws OncRpcException, IOException {
    }

    public void endEncoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
    }

    public abstract void xdrEncodeInt(int var1) throws OncRpcException, IOException;

    public abstract void xdrEncodeOpaque(byte[] var1, int var2, int var3) throws OncRpcException, IOException;

    public final void xdrEncodeDynamicOpaque(byte[] byArray) throws OncRpcException, IOException {
        this.xdrEncodeInt(byArray.length);
        this.xdrEncodeOpaque(byArray);
    }

    public final void xdrEncodeOpaque(byte[] byArray) throws OncRpcException, IOException {
        this.xdrEncodeOpaque(byArray, 0, byArray.length);
    }

    public final void xdrEncodeOpaque(byte[] byArray, int n) throws OncRpcException, IOException {
        if (byArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        this.xdrEncodeOpaque(byArray, 0, byArray.length);
    }

    public final void xdrEncodeByteVector(byte[] byArray) throws OncRpcException, IOException {
        int n = byArray.length;
        this.xdrEncodeInt(n);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                this.xdrEncodeInt(byArray[i]);
            }
        }
    }

    public final void xdrEncodeByteFixedVector(byte[] byArray, int n) throws OncRpcException, IOException {
        if (byArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                this.xdrEncodeInt(byArray[i]);
            }
        }
    }

    public final void xdrEncodeByte(byte by) throws OncRpcException, IOException {
        this.xdrEncodeInt(by);
    }

    public final void xdrEncodeShort(short s) throws OncRpcException, IOException {
        this.xdrEncodeInt(s);
    }

    public final void xdrEncodeLong(long l) throws OncRpcException, IOException {
        this.xdrEncodeInt((int)(l >>> 32));
        this.xdrEncodeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    public final void xdrEncodeFloat(float f) throws OncRpcException, IOException {
        this.xdrEncodeInt(Float.floatToIntBits(f));
    }

    public final void xdrEncodeDouble(double d) throws OncRpcException, IOException {
        this.xdrEncodeLong(Double.doubleToLongBits(d));
    }

    public final void xdrEncodeBoolean(boolean bl) throws OncRpcException, IOException {
        this.xdrEncodeInt(bl ? 1 : 0);
    }

    public void xdrEncodeString(String string) throws OncRpcException, IOException {
        if (this.characterEncoding != null) {
            this.xdrEncodeDynamicOpaque(string.getBytes(this.characterEncoding));
        } else {
            this.xdrEncodeDynamicOpaque(string.getBytes());
        }
    }

    public final void xdrEncodeShortVector(short[] sArray) throws OncRpcException, IOException {
        int n = sArray.length;
        this.xdrEncodeInt(n);
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeShort(sArray[i]);
        }
    }

    public final void xdrEncodeShortFixedVector(short[] sArray, int n) throws OncRpcException, IOException {
        if (sArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeShort(sArray[i]);
        }
    }

    public final void xdrEncodeIntVector(int[] nArray) throws OncRpcException, IOException {
        int n = nArray.length;
        this.xdrEncodeInt(n);
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeInt(nArray[i]);
        }
    }

    public final void xdrEncodeIntFixedVector(int[] nArray, int n) throws OncRpcException, IOException {
        if (nArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeInt(nArray[i]);
        }
    }

    public final void xdrEncodeLongVector(long[] lArray) throws OncRpcException, IOException {
        int n = lArray.length;
        this.xdrEncodeInt(n);
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeLong(lArray[i]);
        }
    }

    public final void xdrEncodeLongFixedVector(long[] lArray, int n) throws OncRpcException, IOException {
        if (lArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeLong(lArray[i]);
        }
    }

    public final void xdrEncodeFloatVector(float[] fArray) throws OncRpcException, IOException {
        int n = fArray.length;
        this.xdrEncodeInt(n);
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeFloat(fArray[i]);
        }
    }

    public final void xdrEncodeFloatFixedVector(float[] fArray, int n) throws OncRpcException, IOException {
        if (fArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeFloat(fArray[i]);
        }
    }

    public final void xdrEncodeDoubleVector(double[] dArray) throws OncRpcException, IOException {
        int n = dArray.length;
        this.xdrEncodeInt(n);
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeDouble(dArray[i]);
        }
    }

    public final void xdrEncodeDoubleFixedVector(double[] dArray, int n) throws OncRpcException, IOException {
        if (dArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeDouble(dArray[i]);
        }
    }

    public final void xdrEncodeBooleanVector(boolean[] blArray) throws OncRpcException, IOException {
        int n = blArray.length;
        this.xdrEncodeInt(n);
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeBoolean(blArray[i]);
        }
    }

    public final void xdrEncodeBooleanFixedVector(boolean[] blArray, int n) throws OncRpcException, IOException {
        if (blArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeBoolean(blArray[i]);
        }
    }

    public final void xdrEncodeStringVector(String[] stringArray) throws OncRpcException, IOException {
        int n = stringArray.length;
        this.xdrEncodeInt(n);
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeString(stringArray[i]);
        }
    }

    public final void xdrEncodeStringFixedVector(String[] stringArray, int n) throws OncRpcException, IOException {
        if (stringArray.length != n) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < n; ++i) {
            this.xdrEncodeString(stringArray[i]);
        }
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

