/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport;

import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.ConfigKey;
import com.bmc.arsys.apitransport.ApiConfigI;
import com.bmc.arsys.apitransport.ApiConfigLogger;
import com.bmc.arsys.apitransport.ApiConfigManager;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationFactory;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ApiConfig
implements ApiConfigI {
    private static Logger if = Logger.getLogger(ApiConfig.class);
    public static final String PROPERTY_NAME = "APICONFIG";
    public static final String MAINCONFIG_NAME = "ARApiConfig";
    private String do;
    private String for;
    private String a;
    protected boolean jrpcMode;
    protected boolean jrpcModeSet;
    protected int clientRpcVersion;
    protected int minimumSupportedServerRpcVersion;
    protected boolean useConnectionPooling = true;
    protected int maxProxiesPerServer;
    protected int idleConnectionsPerServer;
    protected long connectionTimeout;
    protected long connectionLifespan;
    protected String timeUnitStr;
    ARTimeUnit timeUnit = ARTimeUnit.MINUTES;
    protected int connectionMaxRetries;
    protected int timeLagBetweenRetriesMillSec;
    protected int apiRecordingMode;
    protected String apiRecordingLogDir;
    protected int jniLoadMode;
    protected Configuration config;

    public ApiConfig(String string, String string2) {
        this.initializeLogger();
        this.setConfigName(string);
        this.setConfigFileName(string2);
        try {
            this.applyDefaults();
        }
        catch (Exception exception) {
            if.error("Can not initialize Config defaults", exception);
        }
        try {
            this.a(string2);
            this.applyConfigFileSettings();
        }
        catch (ConfigurationException configurationException) {
            if.error("Default settings are used since we could not load the config from file " + configurationException.getLocalizedMessage());
        }
        catch (Exception exception) {
            if.error("Default settings are used since we can not initialize Config from file", exception);
        }
    }

    protected void initializeLogger() {
        try {
            Logger.class.getMethod("getAllAppenders", new Class[0]);
            ApiConfigLogger.initializeLogging();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void a(String string) throws ConfigurationException {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(string);
        this.config = configurationFactory.getConfiguration();
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    protected void applyDefaults() {
        this.setJrpcMode(Boolean.parseBoolean(ConfigKey.JrpcMode.getDefaultValue()));
        this.jrpcModeSet = false;
        this.setDefaultConnectionSettings();
        this.setClientRpcVersion(Integer.parseInt(ConfigKey.ClientRpcVersion.getDefaultValue()));
        this.setMinimumSupportedServerRpcVersion(Integer.parseInt(ConfigKey.MinimumSupportedServerRpcVersion.getDefaultValue()));
        this.setRpcClientStubType(ConfigKey.RpcClientStubType.getDefaultValue());
        this.setConnectionMaxRetries(Integer.parseInt(ConfigKey.ConnectionMaxRetries.getDefaultValue()));
        this.setTimeLagBetweenRetriesMillSec(Integer.parseInt(ConfigKey.TimeLagBetweenRetriesMillSec.getDefaultValue()));
        this.setApiRecordingMode(Integer.parseInt(ConfigKey.ApiRecordingMode.getDefaultValue()));
        this.setApiRecordingLogDir(ConfigKey.ApiRecordingLogDir.getDefaultValue());
        this.setJniLoadMode(Integer.parseInt(ConfigKey.JniLoadMode.getDefaultValue()));
    }

    protected void applyConfigFileSettings() {
        this.setJrpcMode(this.config);
        this.setClientRpcVersion(this.config.getInt(ConfigKey.ClientRpcVersion.getKey(), this.clientRpcVersion));
        this.setRpcClientStubType(this.config.getString(ConfigKey.RpcClientStubType.getKey(), this.a));
        this.setMinimumSupportedServerRpcVersion(this.config.getInt(ConfigKey.MinimumSupportedServerRpcVersion.getKey(), this.minimumSupportedServerRpcVersion));
        this.setConnectionSettings(this.config);
        this.setTimeLagBetweenRetriesMillSec(this.config.getInt(ConfigKey.TimeLagBetweenRetriesMillSec.getKey(), this.timeLagBetweenRetriesMillSec));
        this.setApiRecordingMode(this.config.getInt(ConfigKey.ApiRecordingMode.getKey(), this.apiRecordingMode));
        this.setApiRecordingLogDir(this.config.getString(ConfigKey.ApiRecordingLogDir.getKey(), this.apiRecordingLogDir));
        this.setJniLoadMode(this.config.getInt(ConfigKey.JniLoadMode.getKey(), this.jniLoadMode));
    }

    protected void setDefaultConnectionSettings() {
        this.useConnectionPooling = Boolean.parseBoolean(ConfigKey.UseConnectionPooling.getDefaultValue());
        this.maxProxiesPerServer = Integer.parseInt(ConfigKey.MaxProxiesPerServer.getDefaultValue());
        this.idleConnectionsPerServer = Integer.parseInt(ConfigKey.idleConnectionsPerServer.getDefaultValue());
        this.timeUnitStr = ConfigKey.TimeUnit.getDefaultValue();
        this.connectionTimeout = Long.parseLong(ConfigKey.ConnectionTimeout.getDefaultValue());
        this.connectionLifespan = Long.parseLong(ConfigKey.ConnectionLifespan.getDefaultValue());
    }

    protected void setConnectionSettings(Configuration configuration) {
        this.useConnectionPooling = configuration.getBoolean(ConfigKey.UseConnectionPooling.getKey(), this.useConnectionPooling);
        this.maxProxiesPerServer = configuration.getInt(ConfigKey.MaxProxiesPerServer.getKey(), this.maxProxiesPerServer);
        this.idleConnectionsPerServer = configuration.getInt(ConfigKey.idleConnectionsPerServer.getKey(), this.idleConnectionsPerServer);
        if (this.idleConnectionsPerServer > this.maxProxiesPerServer) {
            this.idleConnectionsPerServer = this.maxProxiesPerServer / 2;
            if.debug("idleConnectionsPerServer value cannot more than maxProxiesPerServer. Value reverted to " + this.idleConnectionsPerServer);
        }
        this.timeUnitStr = configuration.getString(ConfigKey.TimeUnit.getKey(), this.timeUnitStr);
        this.timeUnit = ARTimeUnit.convert(this.timeUnitStr);
        this.connectionTimeout = configuration.getLong(ConfigKey.ConnectionTimeout.getKey(), this.connectionTimeout);
        this.connectionLifespan = configuration.getLong(ConfigKey.ConnectionLifespan.getKey(), this.connectionLifespan);
        if (if.isDebugEnabled()) {
            if.debug("From Config xml: useConnectionPooling = " + this.useConnectionPooling);
            if.debug("From Config xml: idleConnectionsPerServer = " + this.idleConnectionsPerServer + " maximumPoolSize = " + this.maxProxiesPerServer + " connectionTimeout = " + this.connectionTimeout + " connectionLifespan = " + this.connectionLifespan + " timeUnit = " + this.timeUnitStr);
        }
    }

    protected void setConfigName(String string) {
        this.do = string;
    }

    public String getConfigName() {
        return this.do;
    }

    protected void setConfigFileName(String string) {
        this.for = string;
    }

    protected String getConfigFileName() {
        return this.for;
    }

    public static void register(ApiConfig apiConfig) {
        ApiConfigManager.getInstance().register(apiConfig.getConfigName(), apiConfig);
    }

    public void setJrpcMode(Configuration configuration) {
        if (!this.jrpcModeSet) {
            this.setJrpcMode(configuration.getBoolean(ConfigKey.JrpcMode.getKey(), this.jrpcMode));
            if.info("jrpcMode: " + this.jrpcMode);
        }
    }

    @Override
    public void setJrpcMode(boolean bl) {
        this.jrpcMode = bl;
    }

    @Override
    public boolean getJrpcMode() {
        return this.jrpcMode;
    }

    @Override
    public void setClientRpcVersion(int n2) {
        this.clientRpcVersion = n2;
    }

    @Override
    public int getClientRpcVersion() {
        return this.clientRpcVersion;
    }

    @Override
    public void setJniLoadMode(int n2) {
        this.jniLoadMode = n2;
    }

    @Override
    public int getJniLoadMode() {
        return this.jniLoadMode;
    }

    @Override
    public void setApiRecordingMode(int n2) {
        this.apiRecordingMode = n2;
    }

    @Override
    public int getApiRecording() {
        return this.apiRecordingMode;
    }

    public String getApiRecordingLogDir() {
        return this.apiRecordingLogDir;
    }

    public void setApiRecordingLogDir(String string) {
        this.apiRecordingLogDir = string;
    }

    @Override
    public void setMinimumSupportedServerRpcVersion(int n2) {
        this.minimumSupportedServerRpcVersion = n2;
    }

    @Override
    public int getMinimumSupportedServerRpcVersion() {
        return this.minimumSupportedServerRpcVersion;
    }

    @Override
    public void setConnectionMaxRetries(int n2) {
        this.connectionMaxRetries = n2;
    }

    @Override
    public int getConnectionMaxRetries() {
        return this.connectionMaxRetries;
    }

    @Override
    public void setTimeLagBetweenRetriesMillSec(int n2) {
        this.timeLagBetweenRetriesMillSec = n2;
    }

    @Override
    public int getTimeLagBetweenRetriesMillSec() {
        return this.timeLagBetweenRetriesMillSec;
    }

    public boolean isProxyPoolingOn() {
        return this.useConnectionPooling;
    }

    public int getMaxProxiesPerServer() {
        return this.maxProxiesPerServer;
    }

    public int getIdleConnectionsPerServer() {
        return this.idleConnectionsPerServer;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getConnectionLifespan() {
        return this.connectionLifespan;
    }

    public String getTimeUnitStr() {
        return this.timeUnitStr;
    }

    public ARTimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void setRpcClientStubType(String string) {
        this.a = string;
    }

    @Override
    public String getRpcClientStubType() {
        return this.a;
    }
}

