/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.util;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class WeakReferenceMonitor {
    private static final Log logger = LogFactory.getLog(class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("com.bmc.thirdparty.org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor);
    private static final ReferenceQueue handleQueue = new ReferenceQueue();
    private static final Map trackedEntries = Collections.synchronizedMap(new HashMap());
    private static Thread monitoringThread = null;
    static /* synthetic */ Class class$org$springframework$util$WeakReferenceMonitor;

    public static void monitor(Object handle, ReleaseListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Monitoring handle [" + handle + "] with release listener [" + listener + "]");
        }
        WeakReference<Object> weakRef = new WeakReference<Object>(handle, handleQueue);
        WeakReferenceMonitor.addEntry(weakRef, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(Reference ref, ReleaseListener entry) {
        trackedEntries.put(ref, entry);
        Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("com.bmc.thirdparty.org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
        synchronized (clazz) {
            if (!WeakReferenceMonitor.isMonitoringThreadRunning()) {
                monitoringThread = new Thread((Runnable)new MonitoringProcess(), (class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("com.bmc.thirdparty.org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor).getName());
                monitoringThread.setDaemon(true);
                monitoringThread.start();
            }
        }
    }

    private static ReleaseListener removeEntry(Reference reference) {
        return (ReleaseListener)trackedEntries.remove(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMonitoringThreadRunning() {
        Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("com.bmc.thirdparty.org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
        synchronized (clazz) {
            return monitoringThread != null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ReleaseListener {
        public void released();
    }

    private static class MonitoringProcess
    implements Runnable {
        private MonitoringProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Class clazz;
            block10: {
                block9: {
                    logger.debug("Starting reference monitor thread");
                    try {
                        while (!trackedEntries.isEmpty()) {
                            try {
                                Reference reference = handleQueue.remove();
                                ReleaseListener entry = WeakReferenceMonitor.removeEntry(reference);
                                if (entry == null) continue;
                                entry.released();
                            }
                            catch (InterruptedException ex) {
                                logger.debug("Reference monitor thread interrupted", ex);
                                break;
                            }
                        }
                        logger.debug("Stopping reference monitor thread");
                        if (class$org$springframework$util$WeakReferenceMonitor != null) break block9;
                    }
                    catch (Throwable throwable) {
                        logger.debug("Stopping reference monitor thread");
                        Class clazz2 = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("com.bmc.thirdparty.org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
                        synchronized (clazz2) {
                            monitoringThread = null;
                            throw throwable;
                        }
                    }
                    clazz = class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("com.bmc.thirdparty.org.springframework.util.WeakReferenceMonitor");
                    break block10;
                }
                clazz = class$org$springframework$util$WeakReferenceMonitor;
            }
            Class clazz3 = clazz;
            synchronized (clazz) {
                monitoringThread = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

