/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.util.Arrays;
import org.springframework.aop.ClassFilter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class ClassFilters {
    public static ClassFilter union(ClassFilter a, ClassFilter b) {
        return new UnionClassFilter(new ClassFilter[]{a, b});
    }

    public static ClassFilter intersection(ClassFilter a, ClassFilter b) {
        return new IntersectionClassFilter(new ClassFilter[]{a, b});
    }

    private static class IntersectionClassFilter
    implements ClassFilter,
    Serializable {
        private ClassFilter[] filters;

        public IntersectionClassFilter(ClassFilter[] filters) {
            Assert.notNull(filters, "'filters' cannot be null.");
            this.filters = filters;
        }

        public boolean matches(Class clazz) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].matches(clazz)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof IntersectionClassFilter && ObjectUtils.nullSafeEquals(this.filters, ((IntersectionClassFilter)other).filters);
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }
    }

    private static class UnionClassFilter
    implements ClassFilter,
    Serializable {
        private ClassFilter[] filters;

        public UnionClassFilter(ClassFilter[] filters) {
            Assert.notNull(filters, "'filters' cannot be null.");
            this.filters = filters;
        }

        public boolean matches(Class clazz) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].matches(clazz)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UnionClassFilter && ObjectUtils.nullSafeEquals(this.filters, ((UnionClassFilter)other).filters);
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }
    }
}

