/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.annotation;

import com.bmc.thirdparty.org.springframework.core.BridgeMethodResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationUtils {
    public static Annotation[] getAnnotations(Method method) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotation(annotationType);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        if (!annotationType.isAnnotation()) {
            throw new IllegalArgumentException(annotationType + " is not an annotation");
        }
        A annotation = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        while (annotation == null && (cl = cl.getSuperclass()) != null && !cl.equals(Object.class)) {
            try {
                method = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(method, annotationType);
            }
            catch (NoSuchMethodException ex) {}
        }
        return annotation;
    }
}

