/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.utils;

import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.utils.ARByteArrayBuffer;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ARFileHandler {
    private static Logger if = Logger.getLogger(ARFileHandler.class);
    private static final String for = System.getProperty("os.name").contains("Win") ? System.getProperty("line.separator") : "\n";
    private static final String do = System.getProperty("file.encoding");
    private static final String a = "?xml version=";
    public static final String XML_FIRST_EOL_INDICATOR = "?>";
    public static final String XML_ENCODING_INDICATOR = "encoding=";
    public static final String DEF_LEADING_CHARSET_INDICATOR = "char-set: ";

    private ARFileHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String string) throws IOException {
        String string2 = null;
        String string3 = "";
        BufferedReader bufferedReader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().equals("")) continue;
                string3 = ARFileHandler.parseForCharsetName(string2);
                break;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
        if (string3.equals("")) {
            string3 = ARCharSet.getServerKnownCharSetString(do);
        }
        StringBuilder stringBuilder = new StringBuilder();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            int n2;
            fileInputStream = new FileInputStream(string);
            String string4 = ARCharSet.getServerCharSetName(";" + string3);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string4);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((n2 = bufferedReader.read()) > -1) {
                if (n2 == 26) {
                    throw new UnsupportedEncodingException("not translatable");
                }
                stringBuilder.append((char)n2);
            }
            String string5 = ARFileHandler.addCharSetNameToDef(stringBuilder.toString(), string3);
            return string5;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    if.warn("close file: " + string + " failed", iOException);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    if.warn("close file: " + string + " failed", iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    if.warn("close file: " + string + " failed", iOException);
                }
            }
        }
    }

    public static byte[] readAndConvertTextFile(String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = "utf-8";
        }
        return ARFileHandler.readTextFile(string).getBytes(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextToFile(String string, String string2, String string3, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string2, !bl);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string3);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string);
            bufferedWriter.flush();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Throwable throwable) {}
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void writeTextToFile(String string, String string2, boolean bl) throws IOException {
        ARFileHandler.writeTextToFile(string, string2, ARFileHandler.parseForCharsetName(ARFileHandler.getFirstLine(string)), bl);
    }

    public static boolean isXMLDoc(String string) {
        return string != null && string.contains(a);
    }

    public static String parseForCharsetName(String string) {
        String string2 = "";
        if (string == null || string.length() == 0) {
            return string2;
        }
        int n2 = -1;
        int n3 = -1;
        if (ARFileHandler.isXMLDoc(string)) {
            n2 = string.indexOf(XML_ENCODING_INDICATOR) + XML_ENCODING_INDICATOR.length() + 1;
            n3 = string.indexOf(XML_FIRST_EOL_INDICATOR) - 1;
            if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                string2 = string.substring(n2, n3).trim();
            }
        } else if (string.contains(DEF_LEADING_CHARSET_INDICATOR)) {
            n2 = string.indexOf(":") + 1;
            n3 = string.indexOf(for);
            if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                string2 = string.substring(n2, n3).trim();
            } else if (n2 > 0 && n3 == -1) {
                string2 = string.substring(n2).trim();
            }
        }
        return string2;
    }

    public static String replaceCharSetNameInXMLDoc(String string, String string2) {
        if (!ARFileHandler.isXMLDoc(string) || string2 == null || string2.length() == 0) {
            return string;
        }
        String string3 = ARFileHandler.parseForCharsetName(ARFileHandler.getFirstLine(string));
        if (string3.equalsIgnoreCase(string2)) {
            return string;
        }
        return string.replaceFirst(string3, string2);
    }

    public static String getFirstLine(String string) {
        int n2 = string.indexOf(for);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String addCharSetNameToDef(String string, String string2) {
        if (string == null || string.length() < 1 || string2 == null || string2.length() == 0) {
            return string;
        }
        int n2 = string.indexOf(for);
        if (n2 < 0) {
            return string;
        }
        String string3 = ARFileHandler.getFirstLine(string);
        if (ARFileHandler.isXMLDoc(string3)) {
            return string;
        }
        String string4 = ARFileHandler.parseForCharsetName(string3);
        if (!string4.equals("")) {
            if (string4.equals(string2)) {
                return string;
            }
            string = string.substring((DEF_LEADING_CHARSET_INDICATOR + string2).length());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DEF_LEADING_CHARSET_INDICATOR);
        stringBuilder.append(string2).append(for);
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void concatenateFiles(String string, String string2, String string3) throws IOException {
        SequenceInputStream sequenceInputStream = null;
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileInputStream2 = new FileInputStream(string2);
            sequenceInputStream = new SequenceInputStream(fileInputStream, fileInputStream2);
            bufferedInputStream = new BufferedInputStream(sequenceInputStream);
            filterOutputStream = new BufferedOutputStream(System.out);
            bufferedInputStream.skip(500L);
            boolean bl = false;
            int n2 = 0;
            while (!bl) {
                int n3 = bufferedInputStream.read();
                if (n3 == -1) {
                    bl = true;
                    continue;
                }
                ((BufferedOutputStream)filterOutputStream).write((char)n3);
                ++n2;
            }
            String string4 = String.valueOf(n2);
            string4 = string4 + " bytes were read\n";
            ((BufferedOutputStream)filterOutputStream).write(string4.getBytes(), 0, string4.length());
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    if.error("close instream failed", iOException);
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    if.error("close outstream failed", iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    if.error("close file: " + string + " failed", iOException);
                }
            }
            if (fileInputStream2 != null) {
                try {
                    fileInputStream2.close();
                }
                catch (IOException iOException) {
                    if.error("close file: " + string2 + " failed", iOException);
                }
            }
        }
    }

    public static byte[] readBytesFromFile(String string) throws IOException {
        File file = new File(string);
        return ARFileHandler.readBytesFromFile(file);
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        return ARFileHandler.readBytesFromFile(file, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromFile(File file, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return null;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n3;
        if (n3 < 0) {
            long l2 = file.length();
            if (l2 > Integer.MAX_VALUE) {
                if.error("Cannot read the whole file " + file.getCanonicalFile() + ". Can only read " + Integer.MAX_VALUE + " bytes a time");
            }
            n4 = (int)l2;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        byte[] byArray = null;
        try {
            byArray = new byte[n4];
            int n5 = bufferedInputStream.read(byArray, n2, n4);
            if (n3 < 0 && n5 < n4) {
                String string = "Could not read the whole file " + file.getCanonicalFile();
                if.error(string);
                throw new IOException(string);
            }
        }
        finally {
            bufferedInputStream.close();
            ((InputStream)fileInputStream).close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesIntoFile(byte[] byArray, String string) throws IOException {
        if (byArray != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesIntoFile(ARByteArrayBuffer aRByteArrayBuffer, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(aRByteArrayBuffer.getBuffer());
            fileOutputStream.flush();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBytesIntoFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendBytesIntoFile(byte[] byArray, String string) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string, true);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendBytesIntoFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, true);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeObject(String string, Object object) throws IOException {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
                catch (Throwable throwable) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deSerializeObject(String string) throws IOException, ClassNotFoundException {
        Object object = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            objectInputStream = new ObjectInputStream(fileInputStream);
            object = objectInputStream.readObject();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                    objectInputStream = null;
                }
                catch (Throwable throwable) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                catch (Throwable throwable) {}
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if.error("File Not Found while trying to read ", fileNotFoundException);
            String string3 = null;
            return string3;
        }
        catch (IOException iOException) {
            if.error("IOException  while trying to read file", iOException);
            String string4 = null;
            return string4;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuffer.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(File file, String string) {
        boolean bl = false;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
            bufferedWriter.close();
            bl = true;
        }
        catch (IOException iOException) {
            if.error("Write to file failed ", iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Throwable throwable) {}
                bufferedWriter = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExportBytesToFile(byte[] byArray, String string, boolean bl, String string2, String string3) throws IOException {
        boolean bl2 = System.getProperty("os.name").contains("Win");
        String string4 = System.getProperty("line.separator");
        if (string2 == null) {
            string2 = "utf-8";
        }
        boolean bl3 = false;
        if (string2.equals("EUC_JP")) {
            bl3 = true;
        }
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string2));
            int n2 = 2048;
            char[] cArray = new char[n2];
            String string5 = null;
            int n3 = bufferedReader.read(cArray);
            if (n3 != -1) {
                string5 = ARFileHandler.a(n3, cArray, bl2, bl3, string4);
            }
            if (string5 != null) {
                string5 = ARFileHandler.addCharSetNameToDef(string5, string3);
                string2 = ARFileHandler.parseForCharsetName(ARFileHandler.getFirstLine(string5));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, !bl), string2));
                bufferedWriter.write(string5);
                while ((n3 = bufferedReader.read(cArray)) != -1) {
                    string5 = ARFileHandler.a(n3, cArray, bl2, bl3, string4);
                    bufferedWriter.write(string5);
                }
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private static String a(int n2, char[] cArray, boolean bl, boolean bl2, String string) throws UnsupportedEncodingException {
        String string2 = null;
        string2 = n2 < cArray.length ? new String(cArray, 0, n2) : new String(cArray);
        if (bl2) {
            string2 = new String(string2.getBytes("SJIS"), "windows-31j");
        }
        if (bl) {
            string2 = string2.replace("\n", string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readImportBytesFromFile(String string, String string2) throws IOException, UnsupportedEncodingException {
        String string3 = null;
        String string4 = "";
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        OutputStream outputStream = null;
        byte[] byArray = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.trim().equals("")) continue;
                string4 = ARFileHandler.parseForCharsetName(string3);
                break;
            }
            if (string4.equals("")) {
                string4 = ARCharSet.getServerKnownCharSetString(do);
            }
            fileInputStream = new FileInputStream(string);
            String string5 = ARCharSet.getServerCharSetName(";" + string4);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string5);
            bufferedReader = new BufferedReader(inputStreamReader);
            int n2 = 2048;
            char[] cArray = new char[n2];
            String string6 = null;
            int n3 = bufferedReader.read(cArray);
            if (n3 != -1) {
                string6 = String.valueOf(cArray, 0, n3);
                string6 = string6.replace("\r\n", "\n");
            }
            if (string6 != null) {
                String string7 = string6.substring(0, string6.indexOf("\n"));
                if (ARFileHandler.isXMLDoc(string7)) {
                    string6 = ARFileHandler.replaceCharSetNameInXMLDoc(string6, string2);
                }
                outputStream = new ByteArrayOutputStream();
                outputStream.write(StringByteUtil.stringToMaxByteArray(string6, string2, string6.getBytes(string2).length));
                while ((n3 = bufferedReader.read(cArray)) != -1) {
                    string6 = String.valueOf(cArray, 0, n3);
                    if ((string6 = string6.replace("\r\n", "\n")).contains("\u001a")) {
                        throw new UnsupportedEncodingException("not translatable");
                    }
                    outputStream.write(StringByteUtil.stringToMaxByteArray(string6, string2, string6.getBytes(string2).length));
                }
                byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                ((ByteArrayOutputStream)outputStream).close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return byArray;
    }
}

