/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;

public class OncRpcTcpClient
extends OncRpcClient {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    protected XdrTcpEncodingStream sendingXdr;
    protected XdrTcpDecodingStream receivingXdr;
    protected int transmissionTimeout = 30000;

    public OncRpcTcpClient(InetAddress host, int program, int version) throws OncRpcException, IOException {
        this(host, program, version, 0, 0);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port) throws OncRpcException, IOException {
        this(host, program, version, port, 0);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize) throws OncRpcException, IOException {
        this(host, program, version, port, bufferSize, -1);
    }

    public OncRpcTcpClient(InetAddress host, int program, int version, int port, int bufferSize, int timeout) throws OncRpcException, IOException {
        super(host, program, version, port, 6);
        if (bufferSize == 0) {
            bufferSize = 8192;
        }
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.socketHelper = new OncRpcTcpSocketHelper();
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client will connect to " + host + ":" + this.port);
        }
        this.socket = this.socketHelper.connect(host, this.port, timeout);
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client bound to " + this.socket);
            System.out.println("with localInetAddress: " + this.socket.getLocalSocketAddress() + "; remoteInetAddress: " + this.socket.getRemoteSocketAddress());
        }
        this.socket.setTcpNoDelay(true);
        if (this.socketHelper.getSendBufferSize() < bufferSize) {
            this.socketHelper.setSendBufferSize(bufferSize);
        }
        if (this.socketHelper.getReceiveBufferSize() < bufferSize) {
            this.socketHelper.setReceiveBufferSize(bufferSize);
        }
        this.sendingXdr = this.aNewXdrTcpEncodingStream(null, this.socket, bufferSize);
        this.receivingXdr = this.aNewXdrTcpDecodingStream(null, this.socket, bufferSize);
    }

    @Override
    public void close() throws OncRpcException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException e3) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    @Override
    public synchronized void call(int procedureNumber, int versionNumber, XdrAble params, XdrAble result) throws OncRpcException {
        for (int refreshesLeft = 1; refreshesLeft >= 0; --refreshesLeft) {
            String msg;
            this.nextXid();
            OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, versionNumber, procedureNumber, this.auth);
            OncRpcClientReplyMessage replyHeader = new OncRpcClientReplyMessage(this.auth);
            try {
                if (debugout != null) {
                    msg = "call: ProcNumber=" + procedureNumber + " Sending...." + " msgId=" + this.xid;
                    msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                    debugout.println(msg);
                }
                this.socket.setSoTimeout(this.transmissionTimeout);
                this.beginEncoding(procedureNumber, null, 0);
                callHeader.xdrEncode(this.sendingXdr);
                this.encodeParams(params);
                if (this.timeout != 0) {
                    this.sendingXdr.endEncoding();
                } else {
                    this.sendingXdr.endEncoding(false);
                }
            }
            catch (IOException e2) {
                throw new OncRpcException(3, e2.getLocalizedMessage());
            }
            finally {
                try {
                    this.endEncoding(procedureNumber);
                }
                catch (IOException e3) {
                    throw new OncRpcException(3, e3.getLocalizedMessage());
                }
            }
            if (this.timeout == 0) {
                return;
            }
            try {
                if (debugout != null) {
                    msg = "call: ProcNumber=" + procedureNumber + " Receiving....";
                    msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                    debugout.println(msg);
                }
                while (true) {
                    this.socket.setSoTimeout(this.timeout);
                    this.beginDecoding(procedureNumber);
                    this.socket.setSoTimeout(this.transmissionTimeout);
                    try {
                        replyHeader.xdrDecode(this.receivingXdr);
                    }
                    catch (OncRpcException e4) {
                        this.receivingXdr.endDecoding();
                        throw e4;
                    }
                    if (debugout != null) {
                        msg = "call: ProcNumber=" + procedureNumber + " Received msgId=" + replyHeader.messageId;
                        msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                        debugout.println(msg);
                    }
                    if (replyHeader.messageId == callHeader.messageId) break;
                    if (debugout != null) {
                        msg = "call: ProcNumber=" + procedureNumber + " mismatched msgId. try again!";
                        msg = "/* " + formatter.format(System.currentTimeMillis()) + " */" + msg;
                        debugout.println(msg);
                    }
                    this.receivingXdr.endDecoding();
                }
                if (!replyHeader.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (refreshesLeft > 0 && replyHeader.replyStatus == 1 && replyHeader.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue;
                    throw replyHeader.newException();
                }
                try {
                    this.decodeResult(result);
                }
                catch (OncRpcException e5) {
                    this.receivingXdr.endDecoding();
                    throw e5;
                }
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException e6) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException e7) {
                throw new OncRpcException(4, e7.getLocalizedMessage());
            }
            finally {
                try {
                    this.endDecoding(procedureNumber);
                }
                catch (IOException e8) {
                    throw new OncRpcException(4, e8.getLocalizedMessage());
                }
            }
        }
    }

    public synchronized void batchCall(int procedureNumber, XdrAble params, boolean flush) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage callHeader = new OncRpcClientCallMessage(this.xid, this.program, this.version, procedureNumber, this.auth);
        try {
            this.socket.setSoTimeout(this.transmissionTimeout);
            this.beginEncoding(procedureNumber, null, 0);
            callHeader.xdrEncode(this.sendingXdr);
            params.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding(flush);
        }
        catch (IOException e2) {
            throw new OncRpcException(3, e2.getLocalizedMessage());
        }
        finally {
            try {
                this.endEncoding(procedureNumber);
            }
            catch (IOException e3) {
                throw new OncRpcException(3, e3.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setTimeout(int milliseconds) {
        super.setTimeout(milliseconds);
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.receivingXdr.setCharacterEncoding(characterEncoding);
        this.sendingXdr.setCharacterEncoding(characterEncoding);
    }

    @Override
    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket so) {
        this.socket = so;
    }

    public void encodeParams(XdrAble params) throws OncRpcException, IOException {
        params.xdrEncode(this.sendingXdr);
    }

    public void decodeResult(XdrAble result) throws OncRpcException, IOException {
        result.xdrDecode(this.receivingXdr);
    }

    protected OncRpcTcpSocketHelper getSocketHelper() {
        return this.socketHelper;
    }

    protected void beginDecoding(int procedureNumber) throws IOException, OncRpcException {
        this.receivingXdr.beginDecoding();
    }

    protected void endDecoding(int procedureNumber) throws IOException, OncRpcException {
    }

    protected void beginEncoding(int procedureNumber, InetAddress receiverAddress, int receiverPort) throws IOException, OncRpcException {
        this.sendingXdr.beginEncoding(receiverAddress, receiverPort);
    }

    protected void endEncoding(int procedureNumber) throws IOException, OncRpcException {
    }

    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object obj, Socket socket, int senderLen) throws IOException {
        this.sendingXdr = new XdrTcpEncodingStream(socket, senderLen);
        return this.sendingXdr;
    }

    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object obj, Socket socket, int senderLen) throws IOException {
        this.receivingXdr = new XdrTcpDecodingStream(socket, senderLen);
        return this.receivingXdr;
    }
}

