/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.request;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.context.i18n.LocaleContextHolder;
import com.bmc.thirdparty.org.springframework.web.context.request.RequestContextHolder;
import com.bmc.thirdparty.org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;

public class RequestContextListener
implements ServletRequestListener {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (!(requestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + requestEvent.getServletRequest());
        }
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        LocaleContextHolder.setLocale(request.getLocale());
        RequestContextHolder.setRequestAttributes(new ServletRequestAttributes(request));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bound request context to thread: " + request);
        }
    }

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        requestAttributes.requestCompleted();
        RequestContextHolder.setRequestAttributes(null);
        LocaleContextHolder.setLocale(null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cleared thread-bound request context: " + requestEvent.getServletRequest());
        }
    }
}

