/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.remoting.caucho;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.remoting.RemoteAccessException;
import com.bmc.thirdparty.org.springframework.remoting.RemoteConnectFailureException;
import com.bmc.thirdparty.org.springframework.remoting.RemoteLookupFailureException;
import com.bmc.thirdparty.org.springframework.remoting.RemoteProxyFailureException;
import com.bmc.thirdparty.org.springframework.remoting.support.UrlBasedRemoteAccessor;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.MalformedURLException;

public class BurlapClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor {
    private BurlapProxyFactory proxyFactory = new BurlapProxyFactory();
    private Object burlapProxy;

    public void setProxyFactory(BurlapProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory != null ? proxyFactory : new BurlapProxyFactory();
    }

    public void setUsername(String username) {
        this.proxyFactory.setUser(username);
    }

    public void setPassword(String password) {
        this.proxyFactory.setPassword(password);
    }

    public void setOverloadEnabled(boolean overloadEnabled) {
        this.proxyFactory.setOverloadEnabled(overloadEnabled);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.prepare();
    }

    public void prepare() throws RemoteLookupFailureException {
        try {
            this.burlapProxy = this.createBurlapProxy(this.proxyFactory);
        }
        catch (MalformedURLException ex) {
            throw new RemoteLookupFailureException("Service URL [" + this.getServiceUrl() + "] is invalid", ex);
        }
    }

    protected Object createBurlapProxy(BurlapProxyFactory proxyFactory) throws MalformedURLException {
        Assert.notNull(this.getServiceInterface(), "serviceInterface is required");
        return proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.burlapProxy == null) {
            throw new IllegalStateException("BurlapClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        try {
            return invocation.getMethod().invoke(this.burlapProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof BurlapRuntimeException) {
                BurlapRuntimeException bre = (BurlapRuntimeException)ex.getTargetException();
                Object rootCause = bre.getRootCause() != null ? bre.getRootCause() : bre;
                throw this.convertBurlapAccessException((Throwable)rootCause);
            }
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw this.convertBurlapAccessException(utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Failed to invoke Burlap proxy for remote service [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteAccessException convertBurlapAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Cannot connect to Burlap remote service at [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access Burlap remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

