/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jndi;

import com.bmc.thirdparty.org.springframework.aop.framework.ProxyFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.jndi.JndiObjectLocator;
import com.bmc.thirdparty.org.springframework.jndi.JndiObjectTargetSource;
import com.bmc.thirdparty.org.springframework.jndi.TypeMismatchNamingException;
import javax.naming.NamingException;

public class JndiObjectFactoryBean
extends JndiObjectLocator
implements FactoryBean {
    private Class proxyInterface;
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    private Object defaultObject;
    private Object jndiObject;

    public void setProxyInterface(Class proxyInterface) {
        if (!proxyInterface.isInterface()) {
            throw new IllegalArgumentException("[" + proxyInterface.getName() + "] is not an interface");
        }
        this.proxyInterface = proxyInterface;
    }

    public void setLookupOnStartup(boolean lookupOnStartup) {
        this.lookupOnStartup = lookupOnStartup;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setDefaultObject(Object defaultObject) {
        this.defaultObject = defaultObject;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, NamingException {
        super.afterPropertiesSet();
        if (this.proxyInterface != null) {
            if (this.defaultObject != null) {
                throw new IllegalArgumentException("'defaultObject' is not supported in combination with proxyInterface");
            }
            this.jndiObject = JndiObjectProxyFactory.createJndiObjectProxy(this);
        } else {
            if (!this.lookupOnStartup || !this.cache) {
                throw new IllegalArgumentException("Cannot deactivate 'lookupOnStartup' or 'cache' without specifying a 'proxyInterface'");
            }
            if (this.defaultObject != null && this.getExpectedType() != null && !this.getExpectedType().isInstance(this.defaultObject)) {
                throw new IllegalArgumentException("Default object [" + this.defaultObject + "] of type [" + this.defaultObject.getClass().getName() + "] is not of expected type [" + this.getExpectedType().getName() + "]");
            }
            this.jndiObject = this.lookupWithFallback();
        }
    }

    protected Object lookupWithFallback() throws NamingException {
        try {
            return this.lookup();
        }
        catch (TypeMismatchNamingException ex) {
            throw ex;
        }
        catch (NamingException ex) {
            if (this.defaultObject != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("JNDI lookup failed - returning specified default object instead", ex);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.debug("JNDI lookup failed - returning specified default object instead: " + ex);
                }
                return this.defaultObject;
            }
            throw ex;
        }
    }

    public Object getObject() {
        return this.jndiObject;
    }

    public Class getObjectType() {
        if (this.proxyInterface != null) {
            return this.proxyInterface;
        }
        if (this.jndiObject != null) {
            return this.jndiObject.getClass();
        }
        return this.getExpectedType();
    }

    public boolean isSingleton() {
        return true;
    }

    private static class JndiObjectProxyFactory {
        private JndiObjectProxyFactory() {
        }

        private static Object createJndiObjectProxy(JndiObjectFactoryBean jof) throws NamingException {
            JndiObjectTargetSource targetSource = new JndiObjectTargetSource();
            targetSource.setJndiTemplate(jof.getJndiTemplate());
            targetSource.setJndiName(jof.getJndiName());
            targetSource.setExpectedType(jof.getExpectedType());
            targetSource.setResourceRef(jof.isResourceRef());
            targetSource.setLookupOnStartup(jof.lookupOnStartup);
            targetSource.setCache(jof.cache);
            targetSource.afterPropertiesSet();
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.addInterface(jof.proxyInterface);
            proxyFactory.setTargetSource(targetSource);
            return proxyFactory.getProxy();
        }
    }
}

