/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.beanutils;

import com.bmc.thirdparty.org.apache.commons.beanutils.PropertyUtils;
import com.bmc.thirdparty.org.apache.commons.collections.Predicate;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;

public class BeanPropertyValueEqualsPredicate
implements Predicate {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Object propertyValue;
    private boolean ignoreNull;

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.ignoreNull = ignoreNull;
    }

    public boolean evaluate(Object object) {
        boolean evaluation = false;
        try {
            evaluation = this.evaluateValue(this.propertyValue, PropertyUtils.getProperty(object, this.propertyName));
        }
        catch (IllegalArgumentException e2) {
            String errorMsg = "Problem during evaluation. Null value encountered in property path...";
            if (this.ignoreNull) {
                this.log.warn("WARNING: Problem during evaluation. Null value encountered in property path...", e2);
            }
            this.log.error("ERROR: Problem during evaluation. Null value encountered in property path...", e2);
            throw e2;
        }
        catch (IllegalAccessException e3) {
            String errorMsg = "Unable to access the property provided.";
            this.log.error("Unable to access the property provided.", e3);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException e4) {
            String errorMsg = "Exception occurred in property's getter";
            this.log.error("Exception occurred in property's getter", e4);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException e5) {
            String errorMsg = "Property not found.";
            this.log.error("Property not found.", e5);
            throw new IllegalArgumentException("Property not found.");
        }
        return evaluation;
    }

    private boolean evaluateValue(Object expected, Object actual) {
        return expected == actual || expected != null && expected.equals(actual);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

