/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.LoggingInfo;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.WfdBreakpoint;
import com.bmc.arsys.api.WfdDebugLocation;
import com.bmc.arsys.api.WfdUserContext;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.LocaleCharSet;
import com.bmc.arsys.demo.javadriver.SyncObject;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import com.bmc.arsys.demo.javadriver.ThreadStartInfo;
import com.bmc.arsys.demo.javadriver.WfdCommands;
import com.bmc.arsys.demo.javadriver.WfdOutputWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class WFD
extends JavaDriver {
    boolean executeCommand = true;
    static int quietMode = 0;
    static int randomNumberSeed;
    static String resultDirectory;
    boolean primaryThread = false;
    static String[] commandLineArgs;
    static int maxConnectionPerServer;
    static WfdOutputWriter outputWriter;
    static int currentRpcQueue;
    static boolean javaDriverOnly;
    static int SUPPRESS_RESULTS;
    static int SUPPRESS_HEADERS;
    static int SUPPRESS_PROMPTS;
    static int SUPPRESS_MENU;
    static int SUPPRESS_ERRORS;
    static int SUPPRESS_WARNINGS;
    static int SUPPRESS_TIME;
    static int SUPPRESS_DATE;
    static int SUPPRESS_FOR_WFD;
    static int MAX_NESTED_LOOP_DEPTH;
    static int RAND_MAX;
    static List<WfdBreakpoint> Breakpoints;

    @Override
    void printAuxillaryStatus() {
    }

    @Override
    public ARServerUser getControlStructObject() {
        ThreadControlBlock threadControlBlockPtr = WFD.getThreadControlBlockPtr();
        return threadControlBlockPtr.getContext();
    }

    @Override
    public void setPrimaryThread(boolean primary) {
        this.primaryThread = primary;
    }

    @Override
    public boolean isPrimaryThread() {
        return this.primaryThread;
    }

    @Override
    public void setCommandLineArgs(String[] args) {
        commandLineArgs = args;
    }

    @Override
    public String[] getCommandLineArgs() {
        return commandLineArgs;
    }

    public static void setResultDirectory(String directory) {
        resultDirectory = directory;
    }

    public static String getResultDirectory() {
        return resultDirectory;
    }

    public static void setQuietMode(int value) {
        quietMode = value;
    }

    public static int getQuietMode() {
        return quietMode;
    }

    public static void setRandomNumberSeed(int value) {
        randomNumberSeed = value;
    }

    public static int getRandomNumberSeed() {
        return randomNumberSeed;
    }

    public static boolean notWfdQuiet() {
        return (quietMode & SUPPRESS_FOR_WFD) != 0;
    }

    @Override
    int getNextCommand(StringBuilder args) throws IOException {
        ThreadControlBlock threadControlBlockPtr = WFD.getThreadControlBlockPtr();
        threadControlBlockPtr.setArgs(null);
        outputWriter.driverPrintPrompt("\nCommand: ");
        int commandCode = -99;
        while (commandCode == -99) {
            String buffer;
            InputReader.getInputLine();
            String command = buffer = threadControlBlockPtr.getBuffer();
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) != ' ') continue;
                char[] tempArgs = new char[buffer.length() - i - 1];
                buffer.getChars(i + 1, buffer.length(), tempArgs, 0);
                String tmp = new String(tempArgs);
                threadControlBlockPtr.setArgs(tmp);
                char[] tempCmd = new char[i];
                buffer.getChars(0, i, tempCmd, 0);
                command = new String(tempCmd);
                break;
            }
            if (command.length() == 0 || command.charAt(0) == '#') {
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (command.length() > 6) {
                outputWriter.driverPrintError(" ***Command too long, unrecognized ****\n");
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (command.equals("h") || command.equals("?")) {
                outputWriter.driverPrintHelp();
                outputWriter.driverPrintPrompt("\nCommand: ");
                continue;
            }
            if (command.equals("e") || command.equals("q") || command.equals("x")) {
                commandCode = -1;
                continue;
            }
            commandCode = WfdCommands.getCommandCode(command);
            if (commandCode != -2) {
                threadControlBlockPtr.setCurrentCommand(command);
                continue;
            }
            outputWriter.driverPrintError(" *** Command not recognized ***\n");
            outputWriter.driverPrintPrompt("\nCommand: ");
        }
        return commandCode;
    }

    @Override
    public void processCommands() throws IOException {
        int commandCode = -1;
        StringBuilder argsBuf = new StringBuilder();
        InputReader.setNullPromptOption(true);
        if (this.getControlStructObject().getServer() != null) {
            try {
                this.getControlStructObject().wfdSetDebugMode(65535);
            }
            catch (ARException e) {
                e.printStackTrace();
            }
        }
        block38: while ((commandCode = this.getNextCommand(argsBuf)) != -1) {
            argsBuf = new StringBuilder();
            switch (commandCode) {
                case 0: {
                    this.getARServerUser();
                    continue block38;
                }
                case 1: {
                    this.wfdInitialization();
                    continue block38;
                }
                case 2: {
                    this.termination();
                    continue block38;
                }
                case 3: {
                    this.setServerPort();
                    continue block38;
                }
                case 4: {
                    this.wfdExec(0);
                    this.wfdGetCurrentLocation();
                    continue block38;
                }
                case 28: {
                    this.releaseRunThread();
                    continue block38;
                }
                case 5: {
                    this.wfdGoToBp();
                    this.wfdGetCurrentLocation();
                    continue block38;
                }
                case 6: {
                    this.wfdGetCurrentLocation();
                    continue block38;
                }
                case 7: {
                    this.wfdGetFieldValues();
                    continue block38;
                }
                case 8: {
                    this.wfdSetFieldValues();
                    continue block38;
                }
                case 9: {
                    this.wfdGetDebugMode();
                    continue block38;
                }
                case 10: {
                    this.wfdSetDebugMode();
                    continue block38;
                }
                case 29: {
                    this.wfdDoSetDebugMode(65535);
                    continue block38;
                }
                case 30: {
                    this.wfdDoSetDebugMode(0);
                    continue block38;
                }
                case 11: {
                    this.wfdGetFilterQual();
                    continue block38;
                }
                case 12: {
                    this.wfdSetQualifierResult();
                    continue block38;
                }
                case 13: {
                    this.wfdSetBreakPt();
                    continue block38;
                }
                case 14: {
                    this.wfdClrBreakPt();
                    continue block38;
                }
                case 15: {
                    this.wfdListBreakPt();
                    continue block38;
                }
                case 16: {
                    this.wfdClearBpList();
                    continue block38;
                }
                case 17: {
                    this.wfdTerminateAPI();
                    continue block38;
                }
                case 18: {
                    this.wfdGetStackLocation();
                    continue block38;
                }
                case 20: {
                    this.wfdDumpStack();
                    continue block38;
                }
                case 19: {
                    this.wfdFinishAPI();
                    continue block38;
                }
                case 22: {
                    this.wfdGetKeyword();
                    continue block38;
                }
                case 23: {
                    this.wfdGetUserContext();
                    continue block38;
                }
                case 24: {
                    this.wfdRmtSetBreakPt();
                    continue block38;
                }
                case 25: {
                    this.wfdRmtClrBreakPt();
                    continue block38;
                }
                case 26: {
                    this.wfdRmtListBreakPt();
                    continue block38;
                }
                case 27: {
                    this.wfdRmtClearBpList();
                    continue block38;
                }
                case 31: {
                    outputWriter.printExtraHelp();
                    continue block38;
                }
                case 21: {
                    this.wfdRestart();
                    continue block38;
                }
            }
            outputWriter.driverPrintNotSupportCommand(commandCode);
        }
        if (this.getControlStructObject().getServer() != null) {
            try {
                this.getControlStructObject().wfdSetDebugMode(0);
            }
            catch (ARException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void setClientType() {
        this.getControlStructObject().setClientType(3);
    }

    @Override
    boolean processCommandLine() {
        String[] argv = this.getCommandLineArgs();
        int maxArgumentLen = 0;
        String tempPtr = null;
        int rpcQueue = 0;
        ThreadControlBlock threadControlBlockPtr = WFD.getThreadControlBlockPtr();
        int argc = 0;
        if (argv != null) {
            argc = argv.length;
        }
        block23: for (int i = 0; i < argc; ++i) {
            if (argv[i].charAt(0) != '-' || argv[i].charAt(1) != 'u' && argv[i].charAt(1) != 'p' && argv[i].charAt(1) != 'l' && argv[i].charAt(1) != 's' && argv[i].charAt(1) != 'x' && argv[i].charAt(1) != 'o' && argv[i].charAt(1) != 'd' && argv[i].charAt(1) != 'q' && argv[i].charAt(1) != 'g' && argv[i].charAt(1) != 'c' && argv[i].charAt(1) != 'a' && argv[i].charAt(1) != 'S') {
                outputWriter.driverPrintError("Unrecognized option " + argv[i] + "\n");
                return false;
            }
            char option = argv[i].charAt(1);
            if (argv[i].length() > 2) {
                int cmdLength = argv[i].length() - 2;
                char[] tempCmd = new char[cmdLength];
                argv[i].getChars(2, argv[i].length(), tempCmd, 0);
                tempPtr = new String(tempCmd);
            } else if (++i < argc) {
                tempPtr = argv[i];
            } else {
                outputWriter.driverPrintError("Missing value for -" + option + "  option\n");
                return false;
            }
            switch (option) {
                case 'a': 
                case 'l': 
                case 'p': 
                case 's': 
                case 'u': {
                    maxArgumentLen = 254;
                    break;
                }
                case 'd': 
                case 'x': {
                    maxArgumentLen = 255;
                    break;
                }
                case 'o': 
                case 'q': {
                    maxArgumentLen = 3;
                    break;
                }
                case 'S': 
                case 'g': {
                    maxArgumentLen = 10;
                    break;
                }
                case 'c': {
                    maxArgumentLen = 5;
                }
            }
            if (tempPtr.length() > maxArgumentLen) {
                outputWriter.driverPrintError("Value for -" + option + "  option is too long: " + tempPtr + "\n");
                return false;
            }
            char[] tempCmd = null;
            switch (option) {
                case 'u': {
                    int j;
                    boolean authStringFound = false;
                    for (j = 0; j < tempPtr.length(); ++j) {
                        if (tempPtr.charAt(j) != '\\') continue;
                        tempCmd = new char[j];
                        tempPtr.getChars(0, j, tempCmd, 0);
                        threadControlBlockPtr.setAuthentication(new String(tempCmd));
                        authStringFound = true;
                        break;
                    }
                    if (authStringFound) {
                        int cmdLength = tempPtr.length() - j - 1;
                        tempCmd = new char[cmdLength];
                        tempPtr.getChars(j + 1, tempPtr.length(), tempCmd, 0);
                        threadControlBlockPtr.setUser(new String(tempCmd));
                    } else {
                        threadControlBlockPtr.setUser(tempPtr);
                    }
                    outputWriter.printString("Setting user to " + tempPtr + "\n");
                    continue block23;
                }
                case 'a': {
                    threadControlBlockPtr.setAuthentication(tempPtr);
                    continue block23;
                }
                case 'p': {
                    threadControlBlockPtr.setPassword(tempPtr);
                    continue block23;
                }
                case 'l': {
                    threadControlBlockPtr.setLocale(tempPtr);
                    continue block23;
                }
                case 's': {
                    threadControlBlockPtr.setServer(tempPtr);
                    outputWriter.printString("Setting server to " + tempPtr + "\n");
                    continue block23;
                }
                case 'S': {
                    rpcQueue = new Integer(tempPtr);
                    continue block23;
                }
                case 'x': {
                    this.openInputFile(tempPtr);
                    continue block23;
                }
                case 'o': {
                    this.setOutputSetting(tempPtr);
                    continue block23;
                }
                case 'd': {
                    resultDirectory = tempPtr;
                    continue block23;
                }
                case 'q': {
                    quietMode = new Integer(tempPtr);
                    continue block23;
                }
                case 'g': {
                    randomNumberSeed = new Integer(tempPtr);
                    continue block23;
                }
                case 'c': {
                    this.setOutputCount(tempPtr);
                }
            }
        }
        if (rpcQueue != 0) {
            try {
                this.getControlStructObject().usePrivateRpcQueue(rpcQueue);
                currentRpcQueue = rpcQueue;
            }
            catch (ARException e) {
                outputWriter.printARException(e);
            }
        }
        outputWriter.printString("Setting RPC Queue to " + rpcQueue + "\n");
        return true;
    }

    @Override
    protected void setOutputSetting(String tempPtr) {
        ProxyManager.setConnectionLimits(maxConnectionPerServer);
    }

    @Override
    protected void setOutputCount(String tempPtr) {
    }

    @Override
    void getARServerUser() {
        try {
            InputReader.getARServerUser();
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (IllegalArgumentException e) {
            outputWriter.printString("Bad User or Password...\n");
        }
    }

    @Override
    void openInputFile(String fileName) {
        try {
            InputReader.openInputFile(fileName);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    @Override
    void closeOutputFile() {
        outputWriter.closeOutputFile();
    }

    @Override
    void openOutputFile() {
        try {
            String fileName = InputReader.getString("Filename of output file (): ", "");
            outputWriter.openOutputFile(fileName);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    @Override
    void startRecording() {
        String fileName = null;
        try {
            ThreadControlBlock threadControlBlockPtr = WFD.getThreadControlBlockPtr();
            if (threadControlBlockPtr.getRecordFile() != null) {
                outputWriter.driverPrintWarning(" **** Recording already active; stop previous to start new\n");
            } else {
                fileName = InputReader.getString("Filename of record file (): ", "");
                if (fileName == null || fileName.length() == 0) {
                    outputWriter.driverPrintError(" **** No filename specified so no recording started\n");
                } else {
                    threadControlBlockPtr.setRecordFile(new PrintWriter(new FileOutputStream(new File(fileName))));
                }
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...or opening the file " + fileName + "  .\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    @Override
    void stopRecording() {
        try {
            ThreadControlBlock threadControlBlockPtr = WFD.getThreadControlBlockPtr();
            if (threadControlBlockPtr.getRecordFile() == null) {
                outputWriter.driverPrintWarning(" **** Recording is not active\n");
            } else {
                threadControlBlockPtr.setRecordFile(null);
            }
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    @Override
    void beginLoop() {
        try {
            outputWriter.driverPrintHeader("BEGIN LOOP");
            ThreadControlBlock threadControlBlockObject = WFD.getThreadControlBlockPtr();
            if (threadControlBlockObject.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            int numIterations = InputReader.getInt("Number of iterations (1): ", 1);
            if (numIterations <= 0) {
                numIterations = 1;
            }
            if (threadControlBlockObject.getCurrentLoopDepth() == MAX_NESTED_LOOP_DEPTH - 1) {
                outputWriter.driverPrintError("\n*** Maximum nested loop depth exceeded\n");
                threadControlBlockObject.incrementNumFailedBeginLoop();
                return;
            }
            threadControlBlockObject.incrementCurrentLoopDepth();
            threadControlBlockObject.setNumberOfIterations(threadControlBlockObject.getCurrentLoopDepth(), numIterations);
            threadControlBlockObject.setLoopBeginFilePos(threadControlBlockObject.getCurrentLoopDepth(), threadControlBlockObject.getCurrentInputFilePos());
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    @Override
    void endLoop() throws IOException, FileNotFoundException {
        try {
            outputWriter.driverPrintHeader("END LOOP");
            ThreadControlBlock threadControlBlockObject = WFD.getThreadControlBlockPtr();
            if (threadControlBlockObject.isCurrentInputSourceStdInput()) {
                outputWriter.driverPrintError("\n*** Command must be issued from input file\n");
                return;
            }
            if (threadControlBlockObject.getCurrentLoopDepth() < 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because no corresponding begin loop issued\n");
                return;
            }
            if (threadControlBlockObject.getNumFailedBeginLoop() > 0) {
                outputWriter.driverPrintWarning("\n*** Command ignored because previous begin loop failed\n");
                threadControlBlockObject.reduceNumFailedBeginLoop();
                return;
            }
            long numIterations = threadControlBlockObject.getNumberOfIterations(threadControlBlockObject.getCurrentLoopDepth());
            threadControlBlockObject.reduceNumberOfIterations(threadControlBlockObject.getCurrentLoopDepth());
            if (numIterations - 1L > 0L) {
                int loopDepth = threadControlBlockObject.getCurrentLoopDepth();
                long filePosition = threadControlBlockObject.getLoopBeginFilePos(loopDepth);
                threadControlBlockObject.setCurrentInputFileReadingPostion(filePosition);
            } else {
                threadControlBlockObject.reduceCurrentLoopDepth();
            }
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    @Override
    void setLogging() {
        try {
            boolean enable = InputReader.getBooleanForChangingInfo("enable logging? (T):", true);
            long logType = 0L;
            long whereToLog = 0L;
            String fileName = null;
            if (enable) {
                logType = InputReader.getLong("Logging Type NONE(0), SQL(1), Filter(2), API(16)? (0): ", 0L);
                whereToLog = InputReader.getLong("Return logging records to file(1), status list(2)? (1): ", 1L);
                if ((int)(whereToLog & 1L) == 1) {
                    fileName = InputReader.getString("Name of file to hold returned records: ", "");
                }
            }
            LoggingInfo info = new LoggingInfo(enable, logType, whereToLog, fileName);
            this.getControlStructObject().setLogging(info);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    @Override
    void wfdExecute() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD EXECUTE");
            }
            int mode = InputReader.getInt("Execute mode ? (0): ", 0);
            this.beginAPICall();
            this.getControlStructObject().wfdExecute(mode);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Current Location Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetCurrentLocation() {
        WfdDebugLocation currentLocation = null;
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET CURRENT LOCATION");
            }
            currentLocation = this.getControlStructObject().wfdGetDebugLocation(0);
            outputWriter.printCurrentLocation("Current Location:\n", currentLocation);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    @Override
    void wfdGetDebugMode() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET DEBUG MODE");
            }
            this.beginAPICall();
            int mode = this.getControlStructObject().wfdGetDebugMode();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            System.out.print("Current DebugMode (stop at):\n" + ((mode & 1) != 0 ? "   Begin API\n" : "") + ((mode & 4) != 0 ? "   Qualfier\n" : "") + ((mode & 8) != 0 ? "   Phase 1\n" : "") + ((mode & 0x10) != 0 ? "   Phase 2\n" : "") + ((mode & 0x20) != 0 ? "   Phase 3\n" : "") + ((mode & 2) != 0 ? "   End API\n" : "") + ((mode & 0x40) != 0 ? "   Esc Action\n" : "") + ((mode & 0x80) != 0 ? "   CMDB\n" : ""));
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Debug Mode Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdDoSetDebugMode(int newMode) {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD SET DEBUG MODE");
            }
            this.beginAPICall();
            this.getControlStructObject().wfdSetDebugMode(newMode);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Debug Mode Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    @Override
    void wfdSetDebugMode() {
        int debugMode = 0;
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD SET DEBUG MODE");
            }
            outputWriter.driverPrintHeader("Debug Mode to set (stop at)? : ");
            debugMode = InputReader.getBoolean("   Begin API (T): ", true) ? (debugMode |= 1) : (debugMode &= 0xFFFFFFFE);
            debugMode = InputReader.getBoolean("   Qualifier (T): ", true) ? (debugMode |= 4) : (debugMode &= 0xFFFFFFFB);
            debugMode = InputReader.getBoolean("   Phase 1 (T): ", true) ? (debugMode |= 8) : (debugMode &= 0xFFFFFFF7);
            debugMode = InputReader.getBoolean("   Phase 2 (T): ", true) ? (debugMode |= 0x10) : (debugMode &= 0xFFFFFFEF);
            debugMode = InputReader.getBoolean("   Phase 3 (T): ", true) ? (debugMode |= 0x20) : (debugMode &= 0xFFFFFFDF);
            debugMode = InputReader.getBoolean("   End API (T): ", true) ? (debugMode |= 2) : (debugMode &= 0xFFFFFFFD);
            debugMode = InputReader.getBoolean("   Esc Action (T): ", true) ? (debugMode |= 0x40) : (debugMode &= 0xFFFFFFBF);
            debugMode = InputReader.getBoolean("   CMDB (T): ", true) ? (debugMode |= 0x80) : (debugMode &= 0xFFFFFF7F);
            this.wfdDoSetDebugMode(debugMode);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
    }

    @Override
    void wfdGetFieldValues() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET FIELD VALUES");
            }
            int depth = InputReader.getInt("Field from stack frame ? (0): ", 0);
            this.beginAPICall();
            List<Entry> fieldValues = this.getControlStructObject().wfdGetFieldValues(depth);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printEntry("", "Transaction Fields - ", fieldValues.get(0));
            outputWriter.printEntry("", "Database Fields - ", fieldValues.get(1));
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Field Values Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    @Override
    void wfdSetFieldValues() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Set Field Values");
            }
            ArrayList<Entry> fieldValues = new ArrayList<Entry>(2);
            outputWriter.driverPrintPrompt("Field/value pairs to set in transaction list:\n");
            Entry trans = InputReader.getEntry();
            outputWriter.driverPrintPrompt("Field/value pairs to set in database list:\n");
            Entry dbase = InputReader.getEntry();
            fieldValues.add(0, trans);
            fieldValues.add(1, dbase);
            this.beginAPICall();
            this.getControlStructObject().wfdSetFieldValues(fieldValues);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Debug Mode Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    @Override
    void wfdGetFilterQual() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET FILTER QUALIFIER");
            }
            this.beginAPICall();
            QualifierInfo qualifier = this.getControlStructObject().wfdGetFilterQual();
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printQualifierInfo("", "Filter Qualifier:\n", qualifier);
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Get Filter Qualifier Status", statusList);
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    @Override
    void wfdTerminateAPI() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Terminate API");
            }
            int errorCode = InputReader.getInt("Error Code to return (AR_ERROR_TERMINATED_BY_DEBUGGER): ", 9871);
            this.beginAPICall();
            this.getControlStructObject().wfdTerminateAPI(errorCode);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Terminate API Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    @Override
    void wfdSetQualifierResult() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Set Qualifier Result");
            }
            boolean x = InputReader.getNullPromptOption();
            InputReader.setNullPromptOption(true);
            boolean result = InputReader.getBoolean("Set Qualfier Result, T/F? (T): ", true);
            InputReader.setNullPromptOption(x);
            this.beginAPICall();
            this.getControlStructObject().wfdSetQualifierResult(result);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Wfd Set Qualifier Result Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetKeyword() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Get Keyword Value");
            }
            int kwId = InputReader.getInt("Keyword ID ? (1): ", 1);
            Value val = new Value();
            this.beginAPICall();
            val = this.getControlStructObject().wfdGetKeywordValue(kwId);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printValue("", "Keyword Value:", val);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetUserContext() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD Get User Context");
            }
            int mask = InputReader.getInt("Context Mask? (0): ", 0);
            this.beginAPICall();
            WfdUserContext userInfo = this.getControlStructObject().wfdGetUserContext(mask);
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printWfdUserContext("User Context:", userInfo);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    WfdBreakpoint FindEmptyBP() {
        WfdBreakpoint bp;
        int i;
        for (i = 0; i < Breakpoints.size(); ++i) {
            bp = Breakpoints.get(i);
            if (bp == null) {
                bp = new WfdBreakpoint();
                Breakpoints.add(i, bp);
                bp.id = i;
                continue;
            }
            if (bp.filter.length() != 0) continue;
            return bp;
        }
        bp = new WfdBreakpoint();
        Breakpoints.add(i, bp);
        return bp;
    }

    void wfdSetBreakPt() {
        WfdBreakpoint bp = this.FindEmptyBP();
        if (bp != null) {
            try {
                bp.filter = InputReader.getString("  BP location -\n  Filter: ", "");
                bp.schema = InputReader.getString("  Schema (*): ", "*");
                bp.stage = 3 + InputReader.getInt("  Stage PreQual/Phase1/Phase2/Phase3/Escl/CMDB (0-5) (1): ", 1);
                if (bp.stage < 3 || bp.stage > 8) {
                    bp.filter = null;
                    bp.schema = null;
                    outputWriter.printString("Invalid stage " + bp.stage);
                    return;
                }
                bp.elsePath = InputReader.getBoolean("  Else path? (0): ", false);
                bp.actionNo = InputReader.getInt("  Action number (0): ", 0);
                bp.disable = false;
                bp.passcount = 0;
            }
            catch (IOException e) {
                outputWriter.printString("Problem in getting the input...Driver problem..\n");
            }
            return;
        }
        outputWriter.printString("Problem allocating BreakPoint!\n");
    }

    void wfdClearBpList() {
        for (int i = 0; i < Breakpoints.size(); ++i) {
            WfdBreakpoint bp = Breakpoints.get(i);
            if (bp == null) continue;
            bp.filter = "";
        }
    }

    void wfdClrBreakPt() {
        int bpIndex = 0;
        try {
            bpIndex = InputReader.getInt("Breakpoint to clear (0): ", 0);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        try {
            WfdBreakpoint bp = Breakpoints.get(bpIndex);
            if (bp != null) {
                bp.filter = "";
            }
        }
        catch (RuntimeException e) {
            outputWriter.printString("Breakpoint " + bpIndex + " not found..\n");
        }
    }

    void wfdListBreakPt() {
        for (int i = 0; i < Breakpoints.size(); ++i) {
            WfdBreakpoint bp = Breakpoints.get(i);
            if (bp.filter.length() == 0) continue;
            outputWriter.printBreakpoint("", bp, true);
        }
    }

    boolean checkForBP(WfdDebugLocation location) {
        for (int i = 0; i < Breakpoints.size(); ++i) {
            WfdBreakpoint bp = Breakpoints.get(i);
            if (bp.filter.length() == 0 || !bp.filter.equals(location.Filter) || !bp.schema.equals("*") && !bp.schema.equals(location.SchemaName) || bp.stage != location.Stage || bp.elsePath != location.ElsePath || bp.actionNo != location.ActionNo) continue;
            outputWriter.printString("*** BreakPoint #" + i + " encountered:\n");
            return true;
        }
        return false;
    }

    void wfdGoToBp() {
        WfdDebugLocation location = null;
        outputWriter.printString("WFD Run To BP");
        try {
            while (true) {
                this.getControlStructObject().wfdExecute(0);
                location = this.getControlStructObject().wfdGetDebugLocation(0);
                if (location.Stage != 0) break;
                WFD.sleep(500L);
            }
            while (true) {
                location = this.getControlStructObject().wfdGetDebugLocation(0);
                if (location.Stage != 0 && !this.checkForBP(location)) {
                    if (location.Stage == 1) continue;
                    this.getControlStructObject().wfdExecute(0);
                    continue;
                }
                break;
            }
        }
        catch (ARException e) {
            outputWriter.printARException(e);
        }
        catch (InterruptedException e) {
            outputWriter.printString("Interrupted while waiting for breakpoint.\n");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchThread(boolean flag) {
        block11: {
            ThreadStartInfo threadStartInfo = new ThreadStartInfo();
            try {
                SyncObject waitObject;
                ThreadControlBlock threadControlBlockPtr = WFD.getThreadControlBlockPtr();
                threadStartInfo.setOutputToStdOut();
                threadStartInfo.setAuthentication(this.getControlStructObject().getAuthentication());
                threadStartInfo.setUser(this.getControlStructObject().getUser());
                threadStartInfo.setPassword(this.getControlStructObject().getPassword());
                LocaleCharSet localeCharSet = new LocaleCharSet(this.getControlStructObject().getLocale());
                threadStartInfo.setLocale(localeCharSet.getLocale());
                threadStartInfo.setCharset(localeCharSet.getCharSet());
                threadStartInfo.setServer(this.getControlStructObject().getServer());
                threadStartInfo.setUpperBound(0L);
                threadStartInfo.setWaitFlag(flag);
                if (flag) {
                    threadStartInfo.setWaitObject(threadControlBlockPtr.getWaitObject());
                    threadStartInfo.setReleaseObject(threadControlBlockPtr.getReleaseObject());
                }
                WFD wfd = this.instantiateWFD();
                wfd.setThreadStartInfo(threadStartInfo);
                wfd.setPrimaryThread(false);
                wfd.start();
                threadControlBlockPtr.addThreadHandle(wfd);
                if (!flag) break block11;
                SyncObject syncObject = waitObject = threadControlBlockPtr.getWaitObject();
                synchronized (syncObject) {
                    try {
                        while (!waitObject.getFlag()) {
                            waitObject.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        waitObject.setFlag(true);
                        System.out.println("Interrupted Exception ...in simplethread run");
                    }
                }
            }
            catch (NullPointerException e) {
                try {
                    threadStartInfo.cleanUp();
                    outputWriter.driverPrintException(e);
                }
                catch (IOException ex) {
                    outputWriter.printString("Problem in cleaning up the thread start info..\n");
                }
            }
        }
    }

    protected WFD instantiateWFD() {
        return new WFD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadStartFunction() throws IOException {
        SyncObject waitObject;
        ThreadControlBlock threadControlBlockObject = WFD.getThreadControlBlockPtr();
        threadControlBlockObject.setCurrentInputToStdIn();
        threadControlBlockObject.setOutputFile(this.threadStartInfoObject.getOutputFile(), this.threadStartInfoObject.getOutputFileName(), this.threadStartInfoObject.getIsStdOut());
        threadControlBlockObject.setAuthentication(this.threadStartInfoObject.getAuthentication());
        threadControlBlockObject.setUser(this.threadStartInfoObject.getUser());
        threadControlBlockObject.setPassword(this.threadStartInfoObject.getPassword());
        threadControlBlockObject.setLocale(this.threadStartInfoObject.getLocale());
        threadControlBlockObject.setServer(this.threadStartInfoObject.getServer());
        if (currentRpcQueue != 0) {
            try {
                this.getControlStructObject().usePrivateRpcQueue(currentRpcQueue);
            }
            catch (ARException e) {
                outputWriter.printARException(e);
            }
        }
        threadControlBlockObject.setPrimaryThread(false);
        SyncObject syncObject = waitObject = this.threadStartInfoObject.getWaitObject();
        synchronized (syncObject) {
            waitObject.setFlag(true);
            waitObject.notify();
        }
        SyncObject releaseObject = this.threadStartInfoObject.getReleaseObject();
        releaseObject.setFlag(true);
        SyncObject syncObject2 = releaseObject;
        synchronized (syncObject2) {
            try {
                int rpcUsed = currentRpcQueue;
                while (true) {
                    releaseObject.wait();
                    if (!releaseObject.getFlag()) break;
                    if (rpcUsed != currentRpcQueue) {
                        try {
                            this.getControlStructObject().usePrivateRpcQueue(currentRpcQueue);
                        }
                        catch (ARException e) {
                            outputWriter.printARException(e);
                        }
                    }
                    this.wfdExec(1);
                    this.wfdGetCurrentLocation();
                    rpcUsed = this.getControlStructObject().getServerRpcQueueNumber();
                }
            }
            catch (InterruptedException e) {
                releaseObject.setFlag(false);
                System.out.println("Interrupted Exception ...in simplethread run");
            }
        }
        this.threadStartInfoObject.cleanUp();
        this.threadStartInfoObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void run() {
        boolean unexpectedError = false;
        ThreadControlBlock threadControlBlockPtr = WFD.getThreadControlBlockPtr();
        try {
            if (threadControlBlockPtr == null) {
                threadControlBlockPtr = this.initThreadControlBlockPtr();
            }
            WFD.setQuietMode(SUPPRESS_HEADERS | SUPPRESS_FOR_WFD);
            threadControlBlockPtr.setCurrentInputToStdIn();
            threadControlBlockPtr.setOutputToStdOut();
            if (this.isPrimaryThread()) {
                threadControlBlockPtr.setPrimaryThread(true);
                if (!this.processCommandLine()) {
                    System.exit(1);
                }
                outputWriter.driverPrintHelp();
                this.initCommandProcessing();
                this.launchThread(true);
                this.processCommands();
                return;
            }
            threadControlBlockPtr.setPrimaryThread(false);
            this.threadStartFunction();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            outputWriter.printString("IOException caught\n");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            outputWriter.printString("Exception caught" + e.getLocalizedMessage() + "\n");
            System.out.println(e.getLocalizedMessage());
            unexpectedError = true;
            return;
        }
        finally {
            try {
                this.terminateRunThread();
                this.destroyThreadControlBlockPtr(unexpectedError);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.termCommandProcessing();
                if (this.isPrimaryThread()) {
                    this.cleanupThreadEnvironment();
                }
                if (this.isPrimaryThread()) {
                    System.exit(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyThreadControlBlockPtr(boolean noWait) throws IOException {
        ThreadControlBlock threadControlBlockObject = WFD.getThreadControlBlockPtr();
        try {
            threadControlBlockObject.closeOutputFile();
            threadControlBlockObject.closeInputFiles();
            threadControlBlockObject.closeRecordFile();
            Thread childThread = (Thread)threadControlBlockObject.getThreadHandle();
            while (childThread != null) {
                if (!noWait && childThread.isAlive()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                threadControlBlockObject.deleteThreadHandle();
                childThread = (Thread)threadControlBlockObject.getThreadHandle();
            }
        }
        finally {
            threadControlBlockObject.setWaitObjectToNull();
            threadControlBlockObject.setReleaseObjectToNull();
        }
    }

    public static void main(String[] args) {
        try {
            ProxyManager.setUseConnectionPooling(false);
            WFD wfd = new WFD();
            wfd.setCommandLineArgs(args);
            wfd.setPrimaryThread(true);
            wfd.start();
        }
        catch (Exception e) {
            outputWriter.printString("Error in executing the command\n");
        }
    }

    @Override
    void termination() {
        this.getControlStructObject().logout();
    }

    @Override
    void setServerPort() {
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("SET SERVER PORT");
            }
            int portNumber = InputReader.getInt("The port number of server (0):", 0);
            int progNumber = InputReader.getInt("The RPC program number of Server (0):", 0);
            ARServerUser server = this.getControlStructObject();
            server.setPort(portNumber);
            server.usePrivateRpcQueue(progNumber);
            currentRpcQueue = progNumber;
            List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
            outputWriter.printStatusInfoList("", "Set Server Port Status", statusList);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdExec(int mode) {
        try {
            int[] result = this.getControlStructObject().wfdExecute(mode);
            switch (result[0]) {
                case 1: {
                    outputWriter.print("", "", "Workflow Step");
                    break;
                }
                case 2: {
                    outputWriter.print("", "", "Server Breakpoint Encountered: #" + result[1]);
                    break;
                }
                case 3: {
                    outputWriter.print("", "", "User Break\n");
                    break;
                }
                default: {
                    List<StatusInfo> statusList = this.getControlStructObject().getLastStatus();
                    outputWriter.printStatusInfoList("", "WFD Execute Status", statusList);
                    break;
                }
            }
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdInitialization() {
        outputWriter.print("", "", "Initialization.\nOK\n");
    }

    void wfdRestart() {
        outputWriter.print("", "", "Restart.\nOK\n");
    }

    void notImplementedYet() {
        outputWriter.print("", "", "Sorry not implemented yet.\n");
    }

    void wfdFinishAPI() {
        try {
            int saveMode = this.getControlStructObject().wfdGetDebugMode();
            this.getControlStructObject().wfdSetDebugMode(0);
            while (true) {
                this.getControlStructObject().wfdExecute(0);
                WfdDebugLocation location = this.getControlStructObject().wfdGetDebugLocation(0);
                if (location.Stage == 0) break;
                if (location.Stage != 1) continue;
            }
            this.getControlStructObject().wfdSetDebugMode(saveMode);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    void wfdGetStackLocation() {
        WfdDebugLocation currentLocation = null;
        try {
            if (WFD.notWfdQuiet()) {
                outputWriter.driverPrintHeader("WFD GET CURRENT LOCATION");
            }
            int depth = InputReader.getInt("Stack frame ? (0): ", 0);
            currentLocation = this.getControlStructObject().wfdGetDebugLocation(depth);
            outputWriter.printCurrentLocation("Current Location:\n", currentLocation);
        }
        catch (IOException e) {
            outputWriter.printString("Problem in getting the input...Driver problem..\n");
        }
        catch (NullPointerException e) {
            outputWriter.driverPrintException(e);
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRunThread() {
        SyncObject releaseObject;
        ThreadControlBlock threadControlBlockObject = WFD.getThreadControlBlockPtr();
        SyncObject syncObject = releaseObject = threadControlBlockObject.getReleaseObject();
        synchronized (syncObject) {
            releaseObject.setFlag(true);
            releaseObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateRunThread() {
        SyncObject releaseObject;
        ThreadControlBlock threadControlBlockObject = WFD.getThreadControlBlockPtr();
        SyncObject syncObject = releaseObject = threadControlBlockObject.getReleaseObject();
        synchronized (syncObject) {
            releaseObject.setFlag(false);
            releaseObject.notifyAll();
        }
    }

    void wfdDumpStack() {
        WfdDebugLocation entry;
        Stack<WfdDebugLocation> myStack = new Stack<WfdDebugLocation>();
        try {
            int depth = 0;
            while (true) {
                entry = this.getControlStructObject().wfdGetDebugLocation(depth);
                myStack.push(entry);
                if (entry.Stage != 0) {
                    ++depth;
                    continue;
                }
                break;
            }
        }
        catch (ARException e) {
            this.endAPICall(this.getControlStructObject().getLastStatus());
            outputWriter.printARException(e);
        }
        outputWriter.driverPrintHeader("Current Stack:");
        while (!myStack.isEmpty()) {
            entry = (WfdDebugLocation)myStack.pop();
            outputWriter.printCurrentLocation("Current Location:\n", entry);
        }
    }

    static {
        commandLineArgs = null;
        maxConnectionPerServer = 250;
        outputWriter = new WfdOutputWriter();
        currentRpcQueue = 0;
        javaDriverOnly = true;
        SUPPRESS_RESULTS = 1;
        SUPPRESS_HEADERS = 2;
        SUPPRESS_PROMPTS = 4;
        SUPPRESS_MENU = 8;
        SUPPRESS_ERRORS = 16;
        SUPPRESS_WARNINGS = 32;
        SUPPRESS_TIME = 64;
        SUPPRESS_DATE = 128;
        SUPPRESS_FOR_WFD = 256;
        MAX_NESTED_LOOP_DEPTH = 10;
        RAND_MAX = Short.MAX_VALUE;
        Breakpoints = new ArrayList<WfdBreakpoint>(10);
    }
}

