/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.FieldPropertyDescriptor;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$encoding$ser$BeanSerializer == null ? (class$org$apache$axis$encoding$ser$BeanSerializer = BeanSerializer.class$("org.apache.axis.encoding.ser.BeanSerializer")) : class$org$apache$axis$encoding$ser$BeanSerializer).getName());
    private static final QName MUST_UNDERSTAND_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
    private static final Object[] ZERO_ARGS = new Object[]{"0"};
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected TypeDesc typeDesc = null;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanSerializer;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public BeanSerializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, TypeDesc.getTypeDescForClass(javaType));
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this(javaType, xmlType, typeDesc, null);
        this.propertyDescriptor = typeDesc != null ? typeDesc.getPropertyDescriptors() : BeanUtils.getPd(javaType, null);
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc, BeanPropertyDescriptor[] propertyDescriptor) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.propertyDescriptor = propertyDescriptor;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        Object newVal;
        boolean suppressElement;
        Attributes beanAttrs = this.getObjectAttributes(value, attributes, context);
        boolean isEncoded = context.isEncoded();
        boolean bl = suppressElement = !isEncoded && name.getNamespaceURI().equals("") && name.getLocalPart().equals("any");
        if (!suppressElement) {
            context.startElement(name, beanAttrs);
        }
        if (value != null && value.getClass().isArray() && (newVal = JavaUtils.convert(value, this.javaType)) != null && this.javaType.isAssignableFrom(newVal.getClass())) {
            value = newVal;
        }
        try {
            Object anyVal;
            BeanPropertyDescriptor anyDesc;
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                block19: {
                    QName xmlType;
                    QName qname;
                    block21: {
                        Object propValue;
                        Class javaType;
                        block22: {
                            QName itemQName;
                            boolean isArray;
                            boolean isNillable;
                            boolean isOmittable;
                            String propName;
                            block20: {
                                FieldDesc field;
                                propName = this.propertyDescriptor[i].getName();
                                if (propName.equals("class")) break block19;
                                qname = null;
                                xmlType = null;
                                javaType = this.propertyDescriptor[i].getType();
                                isOmittable = false;
                                isNillable = Types.isNullable(javaType);
                                isArray = false;
                                itemQName = null;
                                if (this.typeDesc == null || (field = this.typeDesc.getFieldByName(propName)) == null) break block20;
                                if (!field.isElement()) break block19;
                                ElementDesc element = (ElementDesc)field;
                                qname = isEncoded ? new QName(element.getXmlName().getLocalPart()) : element.getXmlName();
                                isOmittable = element.isMinOccursZero();
                                isNillable = element.isNillable();
                                isArray = element.isMaxOccursUnbounded();
                                xmlType = element.getXmlType();
                                itemQName = element.getItemQName();
                                context.setItemQName(itemQName);
                            }
                            if (qname == null) {
                                qname = new QName(isEncoded ? "" : name.getNamespaceURI(), propName);
                            }
                            if (xmlType == null) {
                                xmlType = context.getQNameForClass(javaType);
                            }
                            if (!this.propertyDescriptor[i].isReadable()) break block19;
                            if (itemQName == null && (this.propertyDescriptor[i].isIndexed() || isArray)) break block21;
                            propValue = this.propertyDescriptor[i].get(value);
                            if (propValue != null) break block22;
                            if (!isNillable && !isOmittable) {
                                if ((class$java$lang$Number == null ? BeanSerializer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(javaType)) {
                                    try {
                                        Constructor constructor = javaType.getConstructor(SimpleDeserializer.STRING_CLASS);
                                        propValue = constructor.newInstance(ZERO_ARGS);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (propValue == null) {
                                    throw new IOException(Messages.getMessage("nullNonNillableElement", propName));
                                }
                            }
                            if (isOmittable && !isEncoded) break block19;
                        }
                        context.serialize(qname, null, propValue, xmlType, javaType);
                        break block19;
                    }
                    int j = 0;
                    while (j >= 0) {
                        Object propValue = null;
                        try {
                            propValue = this.propertyDescriptor[i].get(value, j);
                            ++j;
                        }
                        catch (Exception e) {
                            j = -1;
                        }
                        if (j < 0) continue;
                        context.serialize(qname, null, propValue, xmlType, this.propertyDescriptor[i].getType());
                    }
                }
                ++i;
            }
            BeanPropertyDescriptor beanPropertyDescriptor = anyDesc = this.typeDesc == null ? null : this.typeDesc.getAnyDesc();
            if (anyDesc != null && (anyVal = anyDesc.get(value)) != null && anyVal instanceof MessageElement[]) {
                MessageElement[] anyContent = (MessageElement[])anyVal;
                int i2 = 0;
                while (i2 < anyContent.length) {
                    MessageElement element = anyContent[i2];
                    element.output(context);
                    ++i2;
                }
            }
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            log.error((Object)Messages.getMessage("exception00"), target);
            throw new IOException(target.toString());
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw new IOException(e.toString());
        }
        if (!suppressElement) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        Element complexType = types.createElement("complexType");
        Element e = null;
        Class superClass = javaType.getSuperclass();
        BeanPropertyDescriptor[] superPd = null;
        List stopClasses = types.getStopClasses();
        if (!(superClass == null || superClass == (class$java$lang$Object == null ? (class$java$lang$Object = BeanSerializer.class$("java.lang.Object")) : class$java$lang$Object) || superClass == (class$java$lang$Exception == null ? (class$java$lang$Exception = BeanSerializer.class$("java.lang.Exception")) : class$java$lang$Exception) || superClass == (class$java$lang$Throwable == null ? (class$java$lang$Throwable = BeanSerializer.class$("java.lang.Throwable")) : class$java$lang$Throwable) || superClass == (class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = BeanSerializer.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException) || superClass == (class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = BeanSerializer.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException) || superClass == (class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = BeanSerializer.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault) || stopClasses != null && stopClasses.contains(superClass.getName()))) {
            String base = types.writeType(superClass);
            Element complexContent = types.createElement("complexContent");
            complexType.appendChild(complexContent);
            Element extension = types.createElement("extension");
            complexContent.appendChild(extension);
            extension.setAttribute("base", base);
            e = extension;
            TypeDesc superTypeDesc = TypeDesc.getTypeDescForClass(superClass);
            superPd = superTypeDesc != null ? superTypeDesc.getPropertyDescriptors() : BeanUtils.getPd(superClass, null);
        } else {
            e = complexType;
        }
        Element all = types.createElement("sequence");
        e.appendChild(all);
        if (Modifier.isAbstract(javaType.getModifiers())) {
            complexType.setAttribute("abstract", "true");
        }
        int i = 0;
        while (i < this.propertyDescriptor.length) {
            String propName = this.propertyDescriptor[i].getName();
            boolean writeProperty = true;
            if (propName.equals("class")) {
                writeProperty = false;
            }
            if (superPd != null && writeProperty) {
                int j = 0;
                while (j < superPd.length && writeProperty) {
                    if (propName.equals(superPd[j].getName())) {
                        writeProperty = false;
                    }
                    ++j;
                }
            }
            if (writeProperty) {
                if (this.typeDesc != null) {
                    Class fieldType = this.propertyDescriptor[i].getType();
                    FieldDesc field = this.typeDesc.getFieldByName(propName);
                    if (field != null) {
                        boolean isAnonymous;
                        QName qname = field.getXmlName();
                        QName fieldXmlType = field.getXmlType();
                        boolean bl = isAnonymous = fieldXmlType != null && fieldXmlType.getLocalPart().startsWith(">");
                        if (qname != null) {
                            propName = qname.getLocalPart();
                        }
                        if (!field.isElement()) {
                            this.writeAttribute(types, propName, fieldType, fieldXmlType, complexType);
                        } else {
                            this.writeField(types, propName, fieldXmlType, fieldType, this.propertyDescriptor[i].isIndexed(), field.isMinOccursZero(), all, isAnonymous, ((ElementDesc)field).getItemQName());
                        }
                    } else {
                        this.writeField(types, propName, null, fieldType, this.propertyDescriptor[i].isIndexed(), false, all, false, null);
                    }
                } else {
                    FieldPropertyDescriptor fpd;
                    Class<?> clazz;
                    boolean done = false;
                    if (this.propertyDescriptor[i] instanceof FieldPropertyDescriptor && types.getTypeQName(clazz = (fpd = (FieldPropertyDescriptor)this.propertyDescriptor[i]).getField().getType()) != null) {
                        this.writeField(types, propName, null, clazz, false, false, all, false, null);
                        done = true;
                    }
                    if (!done) {
                        this.writeField(types, propName, null, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), false, all, false, null);
                    }
                }
            }
            ++i;
        }
        return complexType;
    }

    protected void writeField(Types types, String fieldName, QName xmlType, Class fieldType, boolean isUnbounded, boolean isOmittable, Element where, boolean isAnonymous, QName itemQName) throws Exception {
        Element elem;
        String elementType = null;
        if (isAnonymous) {
            elem = types.createElementWithAnonymousType(fieldName, fieldType, isOmittable, where.getOwnerDocument());
        } else {
            FieldDesc field;
            QName typeQName;
            if (!SchemaUtils.isSimpleSchemaType(xmlType) && Types.isArray(fieldType)) {
                xmlType = null;
            }
            if (itemQName != null && SchemaUtils.isSimpleSchemaType(xmlType) && Types.isArray(fieldType)) {
                xmlType = null;
            }
            if ((elementType = types.getQNameString(typeQName = types.writeTypeAndSubTypeForPart(fieldType, xmlType))) == null) {
                QName anyQN = Constants.XSD_ANYTYPE;
                String prefix = types.getNamespaces().getCreatePrefix(anyQN.getNamespaceURI());
                elementType = prefix + ":" + anyQN.getLocalPart();
            }
            boolean isNillable = Types.isNullable(fieldType);
            if (this.typeDesc != null && (field = this.typeDesc.getFieldByName(fieldName)) != null && field.isElement()) {
                isNillable = ((ElementDesc)field).isNillable();
            }
            elem = types.createElement(fieldName, elementType, isNillable, isOmittable, where.getOwnerDocument());
        }
        if (isUnbounded) {
            elem.setAttribute("maxOccurs", "unbounded");
        }
        where.appendChild(elem);
    }

    protected void writeAttribute(Types types, String fieldName, Class fieldType, QName fieldXmlType, Element where) throws Exception {
        if (!types.isAcceptableAsAttribute(fieldType)) {
            throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", fieldName, fieldType.getName()));
        }
        Element elem = types.createAttributeElement(fieldName, fieldType, fieldXmlType, false, where.getOwnerDocument());
        where.appendChild(elem);
    }

    protected Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (!propName.equals("class") && (field = this.typeDesc.getFieldByName(propName)) != null && !field.isElement()) {
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if (this.propertyDescriptor[i].isReadable() && !this.propertyDescriptor[i].isIndexed()) {
                        Object propValue = this.propertyDescriptor[i].get(value);
                        if (qname.equals(MUST_UNDERSTAND_QNAME)) {
                            if (propValue.equals(Boolean.TRUE)) {
                                propValue = "1";
                            } else if (propValue.equals(Boolean.FALSE)) {
                                propValue = "0";
                            }
                        }
                        if (propValue != null) {
                            this.setAttributeProperty(propValue, qname, field.getXmlType(), field.getJavaType(), attrs, context);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    private void setAttributeProperty(Object propValue, QName qname, QName xmlType, Class javaType, AttributesImpl attrs, SerializationContext context) throws Exception {
        String localName;
        String namespace = qname.getNamespaceURI();
        if (attrs.getIndex(namespace, localName = qname.getLocalPart()) != -1) {
            return;
        }
        String propString = context.getValueAsString(propValue, xmlType, javaType);
        attrs.addAttribute(namespace, localName, context.attributeQName2String(qname), "CDATA", propString);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

