/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.tags.form;

import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import com.bmc.thirdparty.org.springframework.web.servlet.tags.form.TagWriter;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public abstract class AbstractHtmlElementBodyTag
extends AbstractHtmlElementTag
implements BodyTag {
    private BodyContent bodyContent;
    private TagWriter tagWriter;

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        this.onWriteTagContent();
        this.tagWriter = tagWriter;
        if (this.shouldRender()) {
            this.exposeAttributes();
            return 2;
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        if (this.shouldRender()) {
            if (this.bodyContent != null && StringUtils.hasText(this.bodyContent.getString())) {
                this.renderFromBodyContent(this.bodyContent, this.tagWriter);
            } else {
                this.renderDefaultContent(this.tagWriter);
            }
        }
        return 6;
    }

    protected void renderFromBodyContent(BodyContent bodyContent, TagWriter tagWriter) throws JspException {
        this.flushBufferedBodyContent(this.bodyContent);
    }

    public void doFinally() {
        super.doFinally();
        this.removeAttributes();
        this.tagWriter = null;
        this.bodyContent = null;
    }

    protected void onWriteTagContent() {
    }

    protected boolean shouldRender() throws JspException {
        return true;
    }

    protected void exposeAttributes() throws JspException {
    }

    protected void removeAttributes() {
    }

    protected void flushBufferedBodyContent(BodyContent bodyContent) throws JspException {
        try {
            bodyContent.writeOut((Writer)bodyContent.getEnclosingWriter());
        }
        catch (IOException e2) {
            throw new JspException("Unable to write buffered body content.", (Throwable)e2);
        }
    }

    protected abstract void renderDefaultContent(TagWriter var1) throws JspException;

    public void doInitBody() throws JspException {
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }
}

