/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.handler;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.context.ApplicationContextException;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import java.util.ArrayList;

public class BeanNameUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking for URL mappings in application context: " + this.getApplicationContext());
        }
        String[] beanNames = this.getApplicationContext().getBeanDefinitionNames();
        for (int i2 = 0; i2 < beanNames.length; ++i2) {
            String beanName = beanNames[i2];
            String[] urls = this.determineUrlsForHandler(beanName);
            if (urls.length > 0) {
                this.registerHandler(urls, beanName);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Rejected bean name '" + beanNames[i2] + "': no URL paths identified");
        }
    }

    protected String[] determineUrlsForHandler(String beanName) {
        ArrayList<String> urls = new ArrayList<String>();
        if (beanName.startsWith("/")) {
            urls.add(beanName);
        }
        String[] aliases = this.getApplicationContext().getAliases(beanName);
        for (int j2 = 0; j2 < aliases.length; ++j2) {
            if (!aliases[j2].startsWith("/")) continue;
            urls.add(aliases[j2]);
        }
        return StringUtils.toStringArray(urls);
    }
}

