/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.validation;

import com.bmc.thirdparty.org.springframework.beans.PropertyAccessException;
import com.bmc.thirdparty.org.springframework.context.support.DefaultMessageSourceResolvable;
import com.bmc.thirdparty.org.springframework.validation.BindingErrorProcessor;
import com.bmc.thirdparty.org.springframework.validation.BindingResult;
import com.bmc.thirdparty.org.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    public void processMissingFieldError(String missingField, BindingResult bindingResult) {
        String[] codes = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), missingField);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), missingField, "", true, codes, arguments, "Field '" + missingField + "' is required"));
    }

    public void processPropertyAccessException(PropertyAccessException ex, BindingResult bindingResult) {
        String field = ex.getPropertyChangeEvent().getPropertyName();
        Object value = ex.getPropertyChangeEvent().getNewValue();
        String[] codes = bindingResult.resolveMessageCodes(ex.getErrorCode(), field);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), field);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), field, value, true, codes, arguments, ex.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field) {
        String[] codes = new String[]{objectName + "." + field, field};
        String defaultMessage = field;
        return new Object[]{new DefaultMessageSourceResolvable(codes, defaultMessage)};
    }
}

